/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.hash;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.hash.MutableHashTable;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.operators.testutils.UniformIntPairGenerator;
import org.apache.flink.runtime.operators.testutils.UniformRecordGenerator;
import org.apache.flink.runtime.operators.testutils.UnionIterator;
import org.apache.flink.runtime.operators.testutils.types.IntPair;
import org.apache.flink.runtime.operators.testutils.types.IntPairComparator;
import org.apache.flink.runtime.operators.testutils.types.IntPairPairComparator;
import org.apache.flink.runtime.operators.testutils.types.IntPairSerializer;
import org.apache.flink.runtime.testutils.recordutils.RecordComparator;
import org.apache.flink.runtime.testutils.recordutils.RecordSerializer;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.NullKeyFieldException;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class HashTableITCase {
    private static final AbstractInvokable MEM_OWNER = new DummyInvokable();
    private MemoryManager memManager;
    private IOManager ioManager;
    private TypeSerializer<Record> recordBuildSideAccesssor;
    private TypeSerializer<Record> recordProbeSideAccesssor;
    private TypeComparator<Record> recordBuildSideComparator;
    private TypeComparator<Record> recordProbeSideComparator;
    private TypePairComparator<Record, Record> pactRecordComparator;
    private TypeSerializer<IntPair> pairBuildSideAccesssor;
    private TypeSerializer<IntPair> pairProbeSideAccesssor;
    private TypeComparator<IntPair> pairBuildSideComparator;
    private TypeComparator<IntPair> pairProbeSideComparator;
    private TypePairComparator<IntPair, IntPair> pairComparator;

    HashTableITCase() {
    }

    @BeforeEach
    void setup() {
        int[] keyPos = new int[]{0};
        Class[] keyType = new Class[]{IntValue.class};
        this.recordBuildSideAccesssor = RecordSerializer.get();
        this.recordProbeSideAccesssor = RecordSerializer.get();
        this.recordBuildSideComparator = new RecordComparator(keyPos, keyType);
        this.recordProbeSideComparator = new RecordComparator(keyPos, keyType);
        this.pactRecordComparator = new RecordPairComparatorFirstInt();
        this.pairBuildSideAccesssor = new IntPairSerializer();
        this.pairProbeSideAccesssor = new IntPairSerializer();
        this.pairBuildSideComparator = new IntPairComparator();
        this.pairProbeSideComparator = new IntPairComparator();
        this.pairComparator = new IntPairPairComparator();
        this.memManager = MemoryManagerBuilder.newBuilder().setMemorySize(0x2000000L).build();
        this.ioManager = new IOManagerAsync();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.ioManager.close();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.memManager.verifyEmpty()).withFailMessage("Not all memory was properly released to the memory manager --> Memory Leak.", new Object[0])).isTrue();
    }

    @Test
    void testIOBufferCountComputation() {
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)32)).isOne();
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)33)).isOne();
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)40)).isOne();
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)64)).isOne();
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)127)).isOne();
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)128)).isEqualTo(2);
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)129)).isEqualTo(2);
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)511)).isEqualTo(2);
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)512)).isEqualTo(3);
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)513)).isEqualTo(3);
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)2047)).isEqualTo(3);
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)2048)).isEqualTo(4);
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)2049)).isEqualTo(4);
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)8191)).isEqualTo(4);
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)8192)).isEqualTo(5);
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)8193)).isEqualTo(5);
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)Short.MAX_VALUE)).isEqualTo(5);
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)32768)).isEqualTo(6);
        Assertions.assertThat((int)MutableHashTable.getNumWriteBehindBuffers((int)Integer.MAX_VALUE)).isEqualTo(6);
    }

    @Test
    void testInMemoryMutableHashTable() throws IOException {
        List memSegments;
        int NUM_KEYS = 100000;
        int BUILD_VALS_PER_KEY = 3;
        int PROBE_VALS_PER_KEY = 10;
        UniformRecordGenerator buildInput = new UniformRecordGenerator(100000, 3, false);
        UniformRecordGenerator probeInput = new UniformRecordGenerator(100000, 10, true);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 896);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        MutableHashTable join = new MutableHashTable(this.recordBuildSideAccesssor, this.recordProbeSideAccesssor, this.recordBuildSideComparator, this.recordProbeSideComparator, this.pactRecordComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)probeInput);
        Record recordReuse = new Record();
        int numRecordsInJoinResult = 0;
        while (join.nextRecord()) {
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            while (buildSide.next((Object)recordReuse) != null) {
                ++numRecordsInJoinResult;
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).describedAs("Wrong number of records in join result.", new Object[0])).isEqualTo(3000000);
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testSpillingHashJoinOneRecursionPerformance() throws IOException {
        List memSegments;
        int NUM_KEYS = 1000000;
        int BUILD_VALS_PER_KEY = 3;
        int PROBE_VALS_PER_KEY = 10;
        UniformRecordGenerator buildInput = new UniformRecordGenerator(1000000, 3, false);
        UniformRecordGenerator probeInput = new UniformRecordGenerator(1000000, 10, true);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 896);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        MutableHashTable join = new MutableHashTable(this.recordBuildSideAccesssor, this.recordProbeSideAccesssor, this.recordBuildSideComparator, this.recordProbeSideComparator, this.pactRecordComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)probeInput);
        Record recordReuse = new Record();
        int numRecordsInJoinResult = 0;
        while (join.nextRecord()) {
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            while (buildSide.next((Object)recordReuse) != null) {
                ++numRecordsInJoinResult;
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).describedAs("Wrong number of records in join result.", new Object[0])).isEqualTo(30000000);
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testSpillingHashJoinOneRecursionValidity() throws IOException {
        List memSegments;
        int NUM_KEYS = 1000000;
        int BUILD_VALS_PER_KEY = 3;
        int PROBE_VALS_PER_KEY = 10;
        UniformRecordGenerator buildInput = new UniformRecordGenerator(1000000, 3, false);
        UniformRecordGenerator probeInput = new UniformRecordGenerator(1000000, 10, true);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 896);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        HashMap<Integer, Long> map = new HashMap<Integer, Long>(1000000);
        MutableHashTable join = new MutableHashTable(this.recordBuildSideAccesssor, this.recordProbeSideAccesssor, this.recordBuildSideComparator, this.recordProbeSideComparator, this.pactRecordComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)probeInput);
        Record recordReuse = new Record();
        while (join.nextRecord()) {
            int numBuildValues = 0;
            int key = 0;
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            Record record = (Record)buildSide.next((Object)recordReuse);
            if (record != null) {
                numBuildValues = 1;
                key = ((IntValue)record.getField(0, IntValue.class)).getValue();
            } else {
                Assertions.fail((String)"No build side values found for a probe key.");
            }
            while ((record = (Record)buildSide.next((Object)recordReuse)) != null) {
                ++numBuildValues;
            }
            if (numBuildValues != 3) {
                Assertions.fail((String)"Other than 3 build values!!!");
            }
            Record pr = (Record)join.getCurrentProbeRecord();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)pr.getField(0, IntValue.class)).getValue()).withFailMessage("Probe-side key was different than build-side key.", new Object[0])).isEqualTo(key);
            Long contained = (Long)map.get(key);
            contained = contained == null ? Long.valueOf(numBuildValues) : Long.valueOf(contained + (long)numBuildValues);
            map.put(key, contained);
        }
        join.close();
        ((MapAssert)Assertions.assertThat(map).withFailMessage("Wrong number of keys", new Object[0])).hasSize(1000000);
        for (Map.Entry entry : map.entrySet()) {
            long val = (Long)entry.getValue();
            int key = (Integer)entry.getKey();
            ((AbstractLongAssert)Assertions.assertThat((long)val).withFailMessage("Wrong number of values in per-key cross product for key %d", new Object[]{key})).isEqualTo(30L);
        }
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testSpillingHashJoinWithMassiveCollisions() throws IOException {
        List memSegments;
        int REPEATED_VALUE_1 = 40559;
        int REPEATED_VALUE_2 = 92882;
        int REPEATED_VALUE_COUNT_BUILD = 200000;
        int REPEATED_VALUE_COUNT_PROBE = 5;
        int NUM_KEYS = 1000000;
        int BUILD_VALS_PER_KEY = 3;
        int PROBE_VALS_PER_KEY = 10;
        UniformRecordGenerator build1 = new UniformRecordGenerator(1000000, 3, false);
        ConstantsKeyValuePairsIterator build2 = new ConstantsKeyValuePairsIterator(40559, 17, 200000);
        ConstantsKeyValuePairsIterator build3 = new ConstantsKeyValuePairsIterator(92882, 23, 200000);
        ArrayList<MutableObjectIterator<Object>> builds = new ArrayList<MutableObjectIterator<Object>>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformRecordGenerator probe1 = new UniformRecordGenerator(1000000, 10, true);
        ConstantsKeyValuePairsIterator probe2 = new ConstantsKeyValuePairsIterator(40559, 17, 5);
        ConstantsKeyValuePairsIterator probe3 = new ConstantsKeyValuePairsIterator(92882, 23, 5);
        ArrayList<MutableObjectIterator<Object>> probes = new ArrayList<MutableObjectIterator<Object>>();
        probes.add(probe1);
        probes.add(probe2);
        probes.add(probe3);
        UnionIterator probeInput = new UnionIterator(probes);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 896);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        HashMap<Integer, Long> map = new HashMap<Integer, Long>(1000000);
        MutableHashTable join = new MutableHashTable(this.recordBuildSideAccesssor, this.recordProbeSideAccesssor, this.recordBuildSideComparator, this.recordProbeSideComparator, this.pactRecordComparator, memSegments, this.ioManager);
        join.open(buildInput, probeInput);
        Record recordReuse = new Record();
        while (join.nextRecord()) {
            int numBuildValues = 0;
            Record probeRec = (Record)join.getCurrentProbeRecord();
            int key = ((IntValue)probeRec.getField(0, IntValue.class)).getValue();
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            Record record = (Record)buildSide.next((Object)recordReuse);
            if (record != null) {
                numBuildValues = 1;
                ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)record.getField(0, IntValue.class)).getValue()).withFailMessage("Probe-side key was different than build-side key.", new Object[0])).isEqualTo(key);
            } else {
                Assertions.fail((String)"No build side values found for a probe key.");
            }
            while ((record = (Record)buildSide.next((Object)recordReuse)) != null) {
                ++numBuildValues;
                ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)record.getField(0, IntValue.class)).getValue()).withFailMessage("Probe-side key was different than build-side key.", new Object[0])).isEqualTo(key);
            }
            Long contained = (Long)map.get(key);
            contained = contained == null ? Long.valueOf(numBuildValues) : Long.valueOf(contained + (long)numBuildValues);
            map.put(key, contained);
        }
        join.close();
        ((MapAssert)Assertions.assertThat(map).withFailMessage("Wrong number of keys", new Object[0])).hasSize(1000000);
        for (Map.Entry entry : map.entrySet()) {
            long val = (Long)entry.getValue();
            int key = (Integer)entry.getKey();
            ((AbstractLongAssert)Assertions.assertThat((long)val).withFailMessage("Wrong number of values in per-key cross product for key %d", new Object[]{key})).isEqualTo(key == 40559 || key == 92882 ? 3000045L : 30L);
        }
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testSpillingHashJoinWithTwoRecursions() throws IOException {
        List memSegments;
        int REPEATED_VALUE_1 = 40559;
        int REPEATED_VALUE_2 = 92882;
        int REPEATED_VALUE_COUNT_BUILD = 200000;
        int REPEATED_VALUE_COUNT_PROBE = 5;
        int NUM_KEYS = 1000000;
        int BUILD_VALS_PER_KEY = 3;
        int PROBE_VALS_PER_KEY = 10;
        UniformRecordGenerator build1 = new UniformRecordGenerator(1000000, 3, false);
        ConstantsKeyValuePairsIterator build2 = new ConstantsKeyValuePairsIterator(40559, 17, 200000);
        ConstantsKeyValuePairsIterator build3 = new ConstantsKeyValuePairsIterator(92882, 23, 200000);
        ArrayList<MutableObjectIterator<Object>> builds = new ArrayList<MutableObjectIterator<Object>>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformRecordGenerator probe1 = new UniformRecordGenerator(1000000, 10, true);
        ConstantsKeyValuePairsIterator probe2 = new ConstantsKeyValuePairsIterator(40559, 17, 5);
        ConstantsKeyValuePairsIterator probe3 = new ConstantsKeyValuePairsIterator(92882, 23, 5);
        ArrayList<MutableObjectIterator<Object>> probes = new ArrayList<MutableObjectIterator<Object>>();
        probes.add(probe1);
        probes.add(probe2);
        probes.add(probe3);
        UnionIterator probeInput = new UnionIterator(probes);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 896);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        HashMap<Integer, Long> map = new HashMap<Integer, Long>(1000000);
        MutableHashTable join = new MutableHashTable(this.recordBuildSideAccesssor, this.recordProbeSideAccesssor, this.recordBuildSideComparator, this.recordProbeSideComparator, this.pactRecordComparator, memSegments, this.ioManager);
        join.open(buildInput, probeInput);
        Record recordReuse = new Record();
        while (join.nextRecord()) {
            int numBuildValues = 0;
            Record probeRec = (Record)join.getCurrentProbeRecord();
            int key = ((IntValue)probeRec.getField(0, IntValue.class)).getValue();
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            Record record = (Record)buildSide.next((Object)recordReuse);
            if (record != null) {
                numBuildValues = 1;
                ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)record.getField(0, IntValue.class)).getValue()).withFailMessage("Probe-side key was different than build-side key.", new Object[0])).isEqualTo(key);
            } else {
                Assertions.fail((String)"No build side values found for a probe key.");
            }
            while ((record = (Record)buildSide.next((Object)recordReuse)) != null) {
                ++numBuildValues;
                ((AbstractIntegerAssert)Assertions.assertThat((int)((IntValue)record.getField(0, IntValue.class)).getValue()).withFailMessage("Probe-side key was different than build-side key.", new Object[0])).isEqualTo(key);
            }
            Long contained = (Long)map.get(key);
            contained = contained == null ? Long.valueOf(numBuildValues) : Long.valueOf(contained + (long)numBuildValues);
            map.put(key, contained);
        }
        join.close();
        ((MapAssert)Assertions.assertThat(map).withFailMessage("Wrong number of keys", new Object[0])).hasSize(1000000);
        for (Map.Entry entry : map.entrySet()) {
            long val = (Long)entry.getValue();
            int key = (Integer)entry.getKey();
            ((AbstractLongAssert)Assertions.assertThat((long)val).withFailMessage("Wrong number of values in per-key cross product for key " + key, new Object[0])).isEqualTo(key == 40559 || key == 92882 ? 3000045L : 30L);
        }
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testFailingHashJoinTooManyRecursions() throws IOException {
        List memSegments;
        int REPEATED_VALUE_1 = 40559;
        int REPEATED_VALUE_2 = 92882;
        int REPEATED_VALUE_COUNT = 3000000;
        int NUM_KEYS = 1000000;
        int BUILD_VALS_PER_KEY = 3;
        int PROBE_VALS_PER_KEY = 10;
        UniformRecordGenerator build1 = new UniformRecordGenerator(1000000, 3, false);
        ConstantsKeyValuePairsIterator build2 = new ConstantsKeyValuePairsIterator(40559, 17, 3000000);
        ConstantsKeyValuePairsIterator build3 = new ConstantsKeyValuePairsIterator(92882, 23, 3000000);
        ArrayList<MutableObjectIterator<Object>> builds = new ArrayList<MutableObjectIterator<Object>>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformRecordGenerator probe1 = new UniformRecordGenerator(1000000, 10, true);
        ConstantsKeyValuePairsIterator probe2 = new ConstantsKeyValuePairsIterator(40559, 17, 3000000);
        ConstantsKeyValuePairsIterator probe3 = new ConstantsKeyValuePairsIterator(92882, 23, 3000000);
        ArrayList<MutableObjectIterator<Object>> probes = new ArrayList<MutableObjectIterator<Object>>();
        probes.add(probe1);
        probes.add(probe2);
        probes.add(probe3);
        UnionIterator probeInput = new UnionIterator(probes);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 896);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        MutableHashTable join = new MutableHashTable(this.recordBuildSideAccesssor, this.recordProbeSideAccesssor, this.recordBuildSideComparator, this.recordProbeSideComparator, this.pactRecordComparator, memSegments, this.ioManager);
        join.open(buildInput, probeInput);
        Record recordReuse = new Record();
        try {
            while (join.nextRecord()) {
                MutableObjectIterator buildSide = join.getBuildSideIterator();
                if (buildSide.next((Object)recordReuse) == null) {
                    Assertions.fail((String)"No build side values found for a probe key.");
                }
                while (buildSide.next((Object)recordReuse) != null) {
                }
            }
            Assertions.fail((String)"Hash Join must have failed due to too many recursions.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testSparseProbeSpilling() throws IOException {
        List memSegments;
        int NUM_BUILD_KEYS = 1000000;
        boolean NUM_BUILD_VALS = true;
        int NUM_PROBE_KEYS = 20;
        boolean NUM_PROBE_VALS = true;
        UniformRecordGenerator buildInput = new UniformRecordGenerator(1000000, 1, false);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 128);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        MutableHashTable join = new MutableHashTable(this.recordBuildSideAccesssor, this.recordProbeSideAccesssor, this.recordBuildSideComparator, this.recordProbeSideComparator, this.pactRecordComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)new UniformRecordGenerator(20, 1, true));
        int expectedNumResults = Math.min(20, 1000000) * 1 * 1;
        Record recordReuse = new Record();
        int numRecordsInJoinResult = 0;
        while (join.nextRecord()) {
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            while (buildSide.next((Object)recordReuse) != null) {
                ++numRecordsInJoinResult;
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).withFailMessage("Wrong number of records in join result.", new Object[0])).isEqualTo(expectedNumResults);
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testSparseProbeSpillingWithOuterJoin() throws IOException {
        List memSegments;
        int NUM_BUILD_KEYS = 1000000;
        boolean NUM_BUILD_VALS = true;
        int NUM_PROBE_KEYS = 20;
        boolean NUM_PROBE_VALS = true;
        UniformRecordGenerator buildInput = new UniformRecordGenerator(1000000, 1, false);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 96);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        MutableHashTable join = new MutableHashTable(this.recordBuildSideAccesssor, this.recordProbeSideAccesssor, this.recordBuildSideComparator, this.recordProbeSideComparator, this.pactRecordComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)new UniformRecordGenerator(20, 1, true), true);
        int expectedNumResults = Math.max(20, 1000000) * 1 * 1;
        Record recordReuse = new Record();
        int numRecordsInJoinResult = 0;
        while (join.nextRecord()) {
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            while (buildSide.next((Object)recordReuse) != null) {
                ++numRecordsInJoinResult;
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).withFailMessage("Wrong number of records in join result.", new Object[0])).isEqualTo(expectedNumResults);
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void validateSpillingDuringInsertion() throws IOException {
        List memSegments;
        int NUM_BUILD_KEYS = 500000;
        boolean NUM_BUILD_VALS = true;
        int NUM_PROBE_KEYS = 10;
        boolean NUM_PROBE_VALS = true;
        UniformRecordGenerator buildInput = new UniformRecordGenerator(500000, 1, false);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 85);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        MutableHashTable join = new MutableHashTable(this.recordBuildSideAccesssor, this.recordProbeSideAccesssor, this.recordBuildSideComparator, this.recordProbeSideComparator, this.pactRecordComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)new UniformRecordGenerator(10, 1, true));
        Record recordReuse = new Record();
        int numRecordsInJoinResult = 0;
        int expectedNumResults = Math.min(10, 500000) * 1 * 1;
        while (join.nextRecord()) {
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            while (buildSide.next((Object)recordReuse) != null) {
                ++numRecordsInJoinResult;
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).withFailMessage("Wrong number of records in join result.", new Object[0])).isEqualTo(expectedNumResults);
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testInMemoryMutableHashTableIntPair() throws IOException {
        List memSegments;
        int NUM_KEYS = 100000;
        int BUILD_VALS_PER_KEY = 3;
        int PROBE_VALS_PER_KEY = 10;
        UniformIntPairGenerator buildInput = new UniformIntPairGenerator(100000, 3, false);
        UniformIntPairGenerator probeInput = new UniformIntPairGenerator(100000, 10, true);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 896);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        MutableHashTable join = new MutableHashTable(this.pairBuildSideAccesssor, this.pairProbeSideAccesssor, this.pairBuildSideComparator, this.pairProbeSideComparator, this.pairComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)probeInput);
        IntPair recordReuse = new IntPair();
        int numRecordsInJoinResult = 0;
        while (join.nextRecord()) {
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            while (buildSide.next((Object)recordReuse) != null) {
                ++numRecordsInJoinResult;
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).withFailMessage("Wrong number of records in join result.", new Object[0])).isEqualTo(3000000);
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testSpillingHashJoinOneRecursionPerformanceIntPair() throws IOException {
        List memSegments;
        int NUM_KEYS = 1000000;
        int BUILD_VALS_PER_KEY = 3;
        int PROBE_VALS_PER_KEY = 10;
        UniformIntPairGenerator buildInput = new UniformIntPairGenerator(1000000, 3, false);
        UniformIntPairGenerator probeInput = new UniformIntPairGenerator(1000000, 10, true);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 896);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        MutableHashTable join = new MutableHashTable(this.pairBuildSideAccesssor, this.pairProbeSideAccesssor, this.pairBuildSideComparator, this.pairProbeSideComparator, this.pairComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)probeInput);
        IntPair recordReuse = new IntPair();
        int numRecordsInJoinResult = 0;
        while (join.nextRecord()) {
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            while (buildSide.next((Object)recordReuse) != null) {
                ++numRecordsInJoinResult;
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).withFailMessage("Wrong number of records in join result.", new Object[0])).isEqualTo(30000000);
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testSpillingHashJoinOneRecursionValidityIntPair() throws IOException {
        List memSegments;
        int NUM_KEYS = 1000000;
        int BUILD_VALS_PER_KEY = 3;
        int PROBE_VALS_PER_KEY = 10;
        UniformIntPairGenerator buildInput = new UniformIntPairGenerator(1000000, 3, false);
        UniformIntPairGenerator probeInput = new UniformIntPairGenerator(1000000, 10, true);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 896);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        HashMap<Integer, Long> map = new HashMap<Integer, Long>(1000000);
        MutableHashTable join = new MutableHashTable(this.pairBuildSideAccesssor, this.pairProbeSideAccesssor, this.pairBuildSideComparator, this.pairProbeSideComparator, this.pairComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)probeInput);
        IntPair recordReuse = new IntPair();
        while (join.nextRecord()) {
            int numBuildValues = 0;
            int key = 0;
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            IntPair record = (IntPair)buildSide.next((Object)recordReuse);
            if (record != null) {
                numBuildValues = 1;
                key = record.getKey();
            } else {
                Assertions.fail((String)"No build side values found for a probe key.");
            }
            while ((record = (IntPair)buildSide.next((Object)recordReuse)) != null) {
                ++numBuildValues;
            }
            if (numBuildValues != 3) {
                Assertions.fail((String)"Other than 3 build values!!!");
            }
            IntPair pr = (IntPair)join.getCurrentProbeRecord();
            ((AbstractIntegerAssert)Assertions.assertThat((int)pr.getKey()).withFailMessage("Probe-side key was different than build-side key.", new Object[0])).isEqualTo(key);
            Long contained = (Long)map.get(key);
            contained = contained == null ? Long.valueOf(numBuildValues) : Long.valueOf(contained + (long)numBuildValues);
            map.put(key, contained);
        }
        join.close();
        ((MapAssert)Assertions.assertThat(map).withFailMessage("Wrong number of keys", new Object[0])).hasSize(1000000);
        for (Map.Entry entry : map.entrySet()) {
            long val = (Long)entry.getValue();
            int key = (Integer)entry.getKey();
            ((AbstractLongAssert)Assertions.assertThat((long)val).withFailMessage("Wrong number of values in per-key cross product for key %d", new Object[]{key})).isEqualTo(30L);
        }
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testSpillingHashJoinWithMassiveCollisionsIntPair() throws IOException {
        List memSegments;
        int REPEATED_VALUE_1 = 40559;
        int REPEATED_VALUE_2 = 92882;
        int REPEATED_VALUE_COUNT_BUILD = 200000;
        int REPEATED_VALUE_COUNT_PROBE = 5;
        int NUM_KEYS = 1000000;
        int BUILD_VALS_PER_KEY = 3;
        int PROBE_VALS_PER_KEY = 10;
        UniformIntPairGenerator build1 = new UniformIntPairGenerator(1000000, 3, false);
        ConstantsIntPairsIterator build2 = new ConstantsIntPairsIterator(40559, 17, 200000);
        ConstantsIntPairsIterator build3 = new ConstantsIntPairsIterator(92882, 23, 200000);
        ArrayList<MutableObjectIterator<Object>> builds = new ArrayList<MutableObjectIterator<Object>>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformIntPairGenerator probe1 = new UniformIntPairGenerator(1000000, 10, true);
        ConstantsIntPairsIterator probe2 = new ConstantsIntPairsIterator(40559, 17, 5);
        ConstantsIntPairsIterator probe3 = new ConstantsIntPairsIterator(92882, 23, 5);
        ArrayList<MutableObjectIterator<Object>> probes = new ArrayList<MutableObjectIterator<Object>>();
        probes.add(probe1);
        probes.add(probe2);
        probes.add(probe3);
        UnionIterator probeInput = new UnionIterator(probes);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 896);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        HashMap<Integer, Long> map = new HashMap<Integer, Long>(1000000);
        MutableHashTable join = new MutableHashTable(this.pairBuildSideAccesssor, this.pairProbeSideAccesssor, this.pairBuildSideComparator, this.pairProbeSideComparator, this.pairComparator, memSegments, this.ioManager);
        join.open(buildInput, probeInput);
        IntPair recordReuse = new IntPair();
        while (join.nextRecord()) {
            int numBuildValues = 0;
            IntPair probeRec = (IntPair)join.getCurrentProbeRecord();
            int key = probeRec.getKey();
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            IntPair record = (IntPair)buildSide.next((Object)recordReuse);
            if (record != null) {
                numBuildValues = 1;
                ((AbstractIntegerAssert)Assertions.assertThat((int)record.getKey()).withFailMessage("Probe-side key was different than build-side key.", new Object[0])).isEqualTo(key);
            } else {
                Assertions.fail((String)"No build side values found for a probe key.");
            }
            while ((record = (IntPair)buildSide.next((Object)recordReuse)) != null) {
                ++numBuildValues;
                ((AbstractIntegerAssert)Assertions.assertThat((int)record.getKey()).withFailMessage("Probe-side key was different than build-side key.", new Object[0])).isEqualTo(key);
            }
            Long contained = (Long)map.get(key);
            contained = contained == null ? Long.valueOf(numBuildValues) : Long.valueOf(contained + (long)numBuildValues);
            map.put(key, contained);
        }
        join.close();
        ((MapAssert)Assertions.assertThat(map).withFailMessage("Wrong number of keys", new Object[0])).hasSize(1000000);
        for (Map.Entry entry : map.entrySet()) {
            long val = (Long)entry.getValue();
            int key = (Integer)entry.getKey();
            ((AbstractLongAssert)Assertions.assertThat((long)val).withFailMessage("Wrong number of values in per-key cross product for key %d", new Object[]{key})).isEqualTo(key == 40559 || key == 92882 ? 3000045L : 30L);
        }
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testSpillingHashJoinWithTwoRecursionsIntPair() throws IOException {
        List memSegments;
        int REPEATED_VALUE_1 = 40559;
        int REPEATED_VALUE_2 = 92882;
        int REPEATED_VALUE_COUNT_BUILD = 200000;
        int REPEATED_VALUE_COUNT_PROBE = 5;
        int NUM_KEYS = 1000000;
        int BUILD_VALS_PER_KEY = 3;
        int PROBE_VALS_PER_KEY = 10;
        UniformIntPairGenerator build1 = new UniformIntPairGenerator(1000000, 3, false);
        ConstantsIntPairsIterator build2 = new ConstantsIntPairsIterator(40559, 17, 200000);
        ConstantsIntPairsIterator build3 = new ConstantsIntPairsIterator(92882, 23, 200000);
        ArrayList<MutableObjectIterator<Object>> builds = new ArrayList<MutableObjectIterator<Object>>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformIntPairGenerator probe1 = new UniformIntPairGenerator(1000000, 10, true);
        ConstantsIntPairsIterator probe2 = new ConstantsIntPairsIterator(40559, 17, 5);
        ConstantsIntPairsIterator probe3 = new ConstantsIntPairsIterator(92882, 23, 5);
        ArrayList<MutableObjectIterator<Object>> probes = new ArrayList<MutableObjectIterator<Object>>();
        probes.add(probe1);
        probes.add(probe2);
        probes.add(probe3);
        UnionIterator probeInput = new UnionIterator(probes);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 896);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        HashMap<Integer, Long> map = new HashMap<Integer, Long>(1000000);
        MutableHashTable join = new MutableHashTable(this.pairBuildSideAccesssor, this.pairProbeSideAccesssor, this.pairBuildSideComparator, this.pairProbeSideComparator, this.pairComparator, memSegments, this.ioManager);
        join.open(buildInput, probeInput);
        IntPair recordReuse = new IntPair();
        while (join.nextRecord()) {
            int numBuildValues = 0;
            IntPair probeRec = (IntPair)join.getCurrentProbeRecord();
            int key = probeRec.getKey();
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            IntPair record = (IntPair)buildSide.next((Object)recordReuse);
            if (record != null) {
                numBuildValues = 1;
                ((AbstractIntegerAssert)Assertions.assertThat((int)record.getKey()).withFailMessage("Probe-side key was different than build-side key.", new Object[0])).isEqualTo(key);
            } else {
                Assertions.fail((String)"No build side values found for a probe key.");
            }
            while ((record = (IntPair)buildSide.next((Object)recordReuse)) != null) {
                ++numBuildValues;
                ((AbstractIntegerAssert)Assertions.assertThat((int)record.getKey()).withFailMessage("Probe-side key was different than build-side key.", new Object[0])).isEqualTo(key);
            }
            Long contained = (Long)map.get(key);
            contained = contained == null ? Long.valueOf(numBuildValues) : Long.valueOf(contained + (long)numBuildValues);
            map.put(key, contained);
        }
        join.close();
        ((MapAssert)Assertions.assertThat(map).withFailMessage("Wrong number of keys", new Object[0])).hasSize(1000000);
        for (Map.Entry entry : map.entrySet()) {
            long val = (Long)entry.getValue();
            int key = (Integer)entry.getKey();
            ((AbstractLongAssert)Assertions.assertThat((long)val).withFailMessage("Wrong number of values in per-key cross product for key %d", new Object[]{key})).isEqualTo(key == 40559 || key == 92882 ? 3000045L : 30L);
        }
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testFailingHashJoinTooManyRecursionsIntPair() throws IOException {
        List memSegments;
        int REPEATED_VALUE_1 = 40559;
        int REPEATED_VALUE_2 = 92882;
        int REPEATED_VALUE_COUNT = 3000000;
        int NUM_KEYS = 1000000;
        int BUILD_VALS_PER_KEY = 3;
        int PROBE_VALS_PER_KEY = 10;
        UniformIntPairGenerator build1 = new UniformIntPairGenerator(1000000, 3, false);
        ConstantsIntPairsIterator build2 = new ConstantsIntPairsIterator(40559, 17, 3000000);
        ConstantsIntPairsIterator build3 = new ConstantsIntPairsIterator(92882, 23, 3000000);
        ArrayList<MutableObjectIterator<Object>> builds = new ArrayList<MutableObjectIterator<Object>>();
        builds.add(build1);
        builds.add(build2);
        builds.add(build3);
        UnionIterator buildInput = new UnionIterator(builds);
        UniformIntPairGenerator probe1 = new UniformIntPairGenerator(1000000, 10, true);
        ConstantsIntPairsIterator probe2 = new ConstantsIntPairsIterator(40559, 17, 3000000);
        ConstantsIntPairsIterator probe3 = new ConstantsIntPairsIterator(92882, 23, 3000000);
        ArrayList<MutableObjectIterator<Object>> probes = new ArrayList<MutableObjectIterator<Object>>();
        probes.add(probe1);
        probes.add(probe2);
        probes.add(probe3);
        UnionIterator probeInput = new UnionIterator(probes);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 896);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        MutableHashTable join = new MutableHashTable(this.pairBuildSideAccesssor, this.pairProbeSideAccesssor, this.pairBuildSideComparator, this.pairProbeSideComparator, this.pairComparator, memSegments, this.ioManager);
        join.open(buildInput, probeInput);
        IntPair recordReuse = new IntPair();
        try {
            while (join.nextRecord()) {
                MutableObjectIterator buildSide = join.getBuildSideIterator();
                if (buildSide.next((Object)recordReuse) == null) {
                    Assertions.fail((String)"No build side values found for a probe key.");
                }
                while (buildSide.next((Object)recordReuse) != null) {
                }
            }
            Assertions.fail((String)"Hash Join must have failed due to too many recursions.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testSparseProbeSpillingIntPair() throws IOException {
        List memSegments;
        int NUM_BUILD_KEYS = 1000000;
        boolean NUM_BUILD_VALS = true;
        int NUM_PROBE_KEYS = 20;
        boolean NUM_PROBE_VALS = true;
        UniformIntPairGenerator buildInput = new UniformIntPairGenerator(1000000, 1, false);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 128);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        MutableHashTable join = new MutableHashTable(this.pairBuildSideAccesssor, this.pairProbeSideAccesssor, this.pairBuildSideComparator, this.pairProbeSideComparator, this.pairComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)new UniformIntPairGenerator(20, 1, true));
        int expectedNumResults = Math.min(20, 1000000) * 1 * 1;
        IntPair recordReuse = new IntPair();
        int numRecordsInJoinResult = 0;
        while (join.nextRecord()) {
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            while (buildSide.next((Object)recordReuse) != null) {
                ++numRecordsInJoinResult;
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).withFailMessage("Wrong number of records in join result.", new Object[0])).isEqualTo(expectedNumResults);
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void validateSpillingDuringInsertionIntPair() throws IOException {
        List memSegments;
        int NUM_BUILD_KEYS = 500000;
        boolean NUM_BUILD_VALS = true;
        int NUM_PROBE_KEYS = 10;
        boolean NUM_PROBE_VALS = true;
        UniformIntPairGenerator buildInput = new UniformIntPairGenerator(500000, 1, false);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 85);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        MutableHashTable join = new MutableHashTable(this.pairBuildSideAccesssor, this.pairProbeSideAccesssor, this.pairBuildSideComparator, this.pairProbeSideComparator, this.pairComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)new UniformIntPairGenerator(10, 1, true));
        IntPair recordReuse = new IntPair();
        int numRecordsInJoinResult = 0;
        int expectedNumResults = Math.min(10, 500000) * 1 * 1;
        while (join.nextRecord()) {
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            while (buildSide.next((Object)recordReuse) != null) {
                ++numRecordsInJoinResult;
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).withFailMessage("Wrong number of records in join result.", new Object[0])).isEqualTo(expectedNumResults);
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testInMemoryReOpen() throws IOException {
        MutableObjectIterator buildSide;
        List memSegments;
        int NUM_KEYS = 100000;
        int BUILD_VALS_PER_KEY = 3;
        int PROBE_VALS_PER_KEY = 10;
        UniformIntPairGenerator buildInput = new UniformIntPairGenerator(100000, 3, false);
        UniformIntPairGenerator probeInput = new UniformIntPairGenerator(100000, 10, true);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 896);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        MutableHashTable join = new MutableHashTable(this.pairBuildSideAccesssor, this.pairProbeSideAccesssor, this.pairBuildSideComparator, this.pairProbeSideComparator, this.pairComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)probeInput);
        IntPair recordReuse = new IntPair();
        int numRecordsInJoinResult = 0;
        while (join.nextRecord()) {
            buildSide = join.getBuildSideIterator();
            while (buildSide.next((Object)recordReuse) != null) {
                ++numRecordsInJoinResult;
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).withFailMessage("Wrong number of records in join result.", new Object[0])).isEqualTo(3000000);
        join.close();
        buildInput = new UniformIntPairGenerator(100000, 3, false);
        probeInput = new UniformIntPairGenerator(100000, 10, true);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)probeInput);
        numRecordsInJoinResult = 0;
        while (join.nextRecord()) {
            buildSide = join.getBuildSideIterator();
            while (buildSide.next((Object)recordReuse) != null) {
                ++numRecordsInJoinResult;
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).withFailMessage("Wrong number of records in join result.", new Object[0])).isEqualTo(3000000);
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testInMemoryReOpenWithSmallMemory() throws Exception {
        MutableObjectIterator buildSide;
        List memSegments;
        int NUM_KEYS = 10000;
        int BUILD_VALS_PER_KEY = 3;
        int PROBE_VALS_PER_KEY = 10;
        UniformIntPairGenerator buildInput = new UniformIntPairGenerator(10000, 3, false);
        UniformIntPairGenerator probeInput = new UniformIntPairGenerator(10000, 10, true);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 33);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        MutableHashTable join = new MutableHashTable(this.pairBuildSideAccesssor, this.pairProbeSideAccesssor, this.pairBuildSideComparator, this.pairProbeSideComparator, this.pairComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)probeInput);
        IntPair recordReuse = new IntPair();
        int numRecordsInJoinResult = 0;
        while (join.nextRecord()) {
            buildSide = join.getBuildSideIterator();
            while (buildSide.next((Object)recordReuse) != null) {
                ++numRecordsInJoinResult;
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).withFailMessage("Wrong number of records in join result.", new Object[0])).isEqualTo(300000);
        join.close();
        buildInput = new UniformIntPairGenerator(10000, 3, false);
        probeInput = new UniformIntPairGenerator(10000, 10, true);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)probeInput);
        numRecordsInJoinResult = 0;
        while (join.nextRecord()) {
            buildSide = join.getBuildSideIterator();
            while (buildSide.next((Object)recordReuse) != null) {
                ++numRecordsInJoinResult;
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).withFailMessage("Wrong number of records in join result.", new Object[0])).isEqualTo(300000);
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testBucketsNotFulfillSegment() throws Exception {
        List memSegments;
        int NUM_KEYS = 10000;
        int BUILD_VALS_PER_KEY = 3;
        int PROBE_VALS_PER_KEY = 10;
        UniformIntPairGenerator buildInput = new UniformIntPairGenerator(10000, 3, false);
        UniformIntPairGenerator probeInput = new UniformIntPairGenerator(10000, 10, true);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 33);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        for (MemorySegment segment : memSegments) {
            int newBucketOffset = segment.size() - 128;
            segment.put(newBucketOffset + 0, (byte)0);
            segment.put(newBucketOffset + 1, (byte)0);
            segment.putShort(newBucketOffset + 2, (short)-1);
            segment.putLong(newBucketOffset + 4, -1L);
        }
        MutableHashTable join = new MutableHashTable(this.pairBuildSideAccesssor, this.pairProbeSideAccesssor, this.pairBuildSideComparator, this.pairProbeSideComparator, this.pairComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)probeInput);
        IntPair recordReuse = new IntPair();
        int numRecordsInJoinResult = 0;
        while (join.nextRecord()) {
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            while (buildSide.next((Object)recordReuse) != null) {
                ++numRecordsInJoinResult;
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).withFailMessage("Wrong number of records in join result.", new Object[0])).isEqualTo(300000);
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testHashWithBuildSideOuterJoin1() throws Exception {
        List memSegments;
        int NUM_KEYS = 20000;
        boolean BUILD_VALS_PER_KEY = true;
        boolean PROBE_VALS_PER_KEY = true;
        UniformIntPairGenerator buildInput = new UniformIntPairGenerator(40000, 1, false);
        UniformIntPairGenerator probeInput = new UniformIntPairGenerator(20000, 1, true);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 33);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        MutableHashTable join = new MutableHashTable(this.pairBuildSideAccesssor, this.pairProbeSideAccesssor, this.pairBuildSideComparator, this.pairProbeSideComparator, this.pairComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)probeInput, true);
        IntPair recordReuse = new IntPair();
        int numRecordsInJoinResult = 0;
        while (join.nextRecord()) {
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            while (buildSide.next((Object)recordReuse) != null) {
                ++numRecordsInJoinResult;
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).withFailMessage("Wrong number of records in join result.", new Object[0])).isEqualTo(40000);
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    @Test
    void testHashWithBuildSideOuterJoin2() throws Exception {
        List memSegments;
        int NUM_KEYS = 40000;
        int BUILD_VALS_PER_KEY = 2;
        boolean PROBE_VALS_PER_KEY = true;
        UniformIntPairGenerator buildInput = new UniformIntPairGenerator(40000, 2, false);
        UniformIntPairGenerator probeInput = new UniformIntPairGenerator(40000, 1, true);
        try {
            memSegments = this.memManager.allocatePages((Object)MEM_OWNER, 33);
        }
        catch (MemoryAllocationException maex) {
            Assertions.fail((String)"Memory for the Join could not be provided.");
            return;
        }
        MutableHashTable join = new MutableHashTable(this.pairBuildSideAccesssor, this.pairProbeSideAccesssor, this.pairBuildSideComparator, this.pairProbeSideComparator, this.pairComparator, memSegments, this.ioManager);
        join.open((MutableObjectIterator)buildInput, (MutableObjectIterator)probeInput, true);
        IntPair recordReuse = new IntPair();
        int numRecordsInJoinResult = 0;
        while (join.nextRecord()) {
            MutableObjectIterator buildSide = join.getBuildSideIterator();
            IntPair next = (IntPair)buildSide.next((Object)recordReuse);
            if (next == null && join.getCurrentProbeRecord() == null) {
                Assertions.fail((String)"Should not return join result that both probe and build element are null.");
            }
            while (next != null) {
                ++numRecordsInJoinResult;
                next = (IntPair)buildSide.next((Object)recordReuse);
            }
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)numRecordsInJoinResult).withFailMessage("Wrong number of records in join result.", new Object[0])).isEqualTo(80000);
        join.close();
        this.memManager.release((Collection)join.getFreedMemory());
    }

    public static final class RecordPairComparatorFirstInt
    extends TypePairComparator<Record, Record> {
        private int key;

        public void setReference(Record reference) {
            try {
                this.key = ((IntValue)reference.getField(0, IntValue.class)).getValue();
            }
            catch (NullPointerException npex) {
                throw new NullKeyFieldException();
            }
        }

        public boolean equalToReference(Record candidate) {
            try {
                return this.key == ((IntValue)candidate.getField(0, IntValue.class)).getValue();
            }
            catch (NullPointerException npex) {
                throw new NullKeyFieldException();
            }
        }

        public int compareToReference(Record candidate) {
            try {
                int i = ((IntValue)candidate.getField(0, IntValue.class)).getValue();
                return i - this.key;
            }
            catch (NullPointerException npex) {
                throw new NullKeyFieldException();
            }
        }
    }

    public static final class ConstantsKeyValuePairsIterator
    implements MutableObjectIterator<Record> {
        private final IntValue key;
        private final IntValue value;
        private int numLeft;

        public ConstantsKeyValuePairsIterator(int key, int value, int count) {
            this.key = new IntValue(key);
            this.value = new IntValue(value);
            this.numLeft = count;
        }

        public Record next(Record reuse) {
            if (this.numLeft > 0) {
                --this.numLeft;
                reuse.clear();
                reuse.setField(0, (Value)this.key);
                reuse.setField(1, (Value)this.value);
                return reuse;
            }
            return null;
        }

        public Record next() {
            return this.next(new Record(2));
        }
    }

    private static final class ConstantsIntPairsIterator
    implements MutableObjectIterator<IntPair> {
        private final int key;
        private final int value;
        private int numLeft;

        public ConstantsIntPairsIterator(int key, int value, int count) {
            this.key = key;
            this.value = value;
            this.numLeft = count;
        }

        public IntPair next(IntPair reuse) {
            if (this.numLeft > 0) {
                --this.numLeft;
                reuse.setKey(this.key);
                reuse.setValue(this.value);
                return reuse;
            }
            return null;
        }

        public IntPair next() {
            return this.next(new IntPair());
        }
    }
}

