/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.drivers;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.runtime.operators.AllReduceDriver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.drivers.DriverTestData;
import org.apache.flink.runtime.operators.drivers.GatheringCollector;
import org.apache.flink.runtime.operators.drivers.TestTaskContext;
import org.apache.flink.runtime.operators.testutils.DiscardingOutputCollector;
import org.apache.flink.runtime.util.EmptyMutableObjectIterator;
import org.apache.flink.runtime.util.RegularToMutableObjectIterator;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AllReduceDriverTest {
    AllReduceDriverTest() {
    }

    @Test
    void testAllReduceDriverImmutableEmpty() {
        try {
            TestTaskContext context = new TestTaskContext();
            List<Tuple2<String, Integer>> data = DriverTestData.createReduceImmutableData();
            TypeInformation typeInfo = TypeExtractor.getForObject(data.get(0));
            MutableObjectIterator input = EmptyMutableObjectIterator.get();
            context.setDriverStrategy(DriverStrategy.ALL_REDUCE);
            context.setInput1(input, typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            context.setCollector(new DiscardingOutputCollector());
            AllReduceDriver driver = new AllReduceDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testAllReduceDriverImmutable() {
        try {
            TestTaskContext context = new TestTaskContext();
            List<Tuple2<String, Integer>> data = DriverTestData.createReduceImmutableData();
            TypeInformation typeInfo = TypeExtractor.getForObject(data.get(0));
            RegularToMutableObjectIterator input = new RegularToMutableObjectIterator(data.iterator(), typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            GatheringCollector result = new GatheringCollector(typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            context.setDriverStrategy(DriverStrategy.ALL_REDUCE);
            context.setInput1(input, typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            context.setCollector(result);
            context.setUdf(new ConcatSumFirstReducer());
            AllReduceDriver driver = new AllReduceDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            Tuple2 res = (Tuple2)result.getList().get(0);
            char[] foundString = ((String)res.f0).toCharArray();
            Arrays.sort(foundString);
            char[] expectedString = "abcddeeeffff".toCharArray();
            Arrays.sort(expectedString);
            Assertions.assertThat((char[])foundString).isEqualTo((Object)expectedString);
            Assertions.assertThat((Integer)((Integer)res.f1)).isEqualTo(78);
            context = new TestTaskContext();
            data = DriverTestData.createReduceImmutableData();
            typeInfo = TypeExtractor.getForObject(data.get(0));
            input = new RegularToMutableObjectIterator(data.iterator(), typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            result = new GatheringCollector(typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            context.setDriverStrategy(DriverStrategy.ALL_REDUCE);
            context.setInput1(input, typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            context.setCollector(result);
            context.setUdf(new ConcatSumSecondReducer());
            driver = new AllReduceDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            res = (Tuple2)result.getList().get(0);
            foundString = ((String)res.f0).toCharArray();
            Arrays.sort(foundString);
            expectedString = "abcddeeeffff".toCharArray();
            Arrays.sort(expectedString);
            Assertions.assertThat((char[])foundString).isEqualTo((Object)expectedString);
            Assertions.assertThat((Integer)((Integer)res.f1)).isEqualTo(78);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testAllReduceDriverMutable() {
        try {
            TestTaskContext context = new TestTaskContext();
            List<Tuple2<StringValue, IntValue>> data = DriverTestData.createReduceMutableData();
            TypeInformation typeInfo = TypeExtractor.getForObject(data.get(0));
            RegularToMutableObjectIterator input = new RegularToMutableObjectIterator(data.iterator(), typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            GatheringCollector result = new GatheringCollector(typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            context.setDriverStrategy(DriverStrategy.ALL_REDUCE);
            context.setInput1(input, typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            context.setCollector(result);
            context.setUdf(new ConcatSumFirstMutableReducer());
            AllReduceDriver driver = new AllReduceDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            Tuple2 res = (Tuple2)result.getList().get(0);
            char[] foundString = ((StringValue)res.f0).getValue().toCharArray();
            Arrays.sort(foundString);
            char[] expectedString = "abcddeeeffff".toCharArray();
            Arrays.sort(expectedString);
            Assertions.assertThat((char[])foundString).isEqualTo((Object)expectedString);
            Assertions.assertThat((int)((IntValue)res.f1).getValue()).isEqualTo(78);
            context = new TestTaskContext();
            data = DriverTestData.createReduceMutableData();
            typeInfo = TypeExtractor.getForObject(data.get(0));
            input = new RegularToMutableObjectIterator(data.iterator(), typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            result = new GatheringCollector(typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            context.setDriverStrategy(DriverStrategy.ALL_REDUCE);
            context.setInput1(input, typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            context.setCollector(result);
            context.setUdf(new ConcatSumSecondMutableReducer());
            driver = new AllReduceDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            res = (Tuple2)result.getList().get(0);
            foundString = ((StringValue)res.f0).getValue().toCharArray();
            Arrays.sort(foundString);
            expectedString = "abcddeeeffff".toCharArray();
            Arrays.sort(expectedString);
            Assertions.assertThat((char[])foundString).isEqualTo((Object)expectedString);
            Assertions.assertThat((int)((IntValue)res.f1).getValue()).isEqualTo(78);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private static final class ConcatSumFirstReducer
    extends RichReduceFunction<Tuple2<String, Integer>> {
        private ConcatSumFirstReducer() {
        }

        public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) {
            value1.f0 = (String)value1.f0 + (String)value2.f0;
            value1.f1 = (Integer)value1.f1 + (Integer)value2.f1;
            return value1;
        }
    }

    public static final class ConcatSumSecondReducer
    extends RichReduceFunction<Tuple2<String, Integer>> {
        public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) {
            value2.f0 = (String)value1.f0 + (String)value2.f0;
            value2.f1 = (Integer)value1.f1 + (Integer)value2.f1;
            return value2;
        }
    }

    public static final class ConcatSumFirstMutableReducer
    extends RichReduceFunction<Tuple2<StringValue, IntValue>> {
        public Tuple2<StringValue, IntValue> reduce(Tuple2<StringValue, IntValue> value1, Tuple2<StringValue, IntValue> value2) {
            ((StringValue)value1.f0).setValue((CharSequence)(((StringValue)value1.f0).getValue() + ((StringValue)value2.f0).getValue()));
            ((IntValue)value1.f1).setValue(((IntValue)value1.f1).getValue() + ((IntValue)value2.f1).getValue());
            return value1;
        }
    }

    public static final class ConcatSumSecondMutableReducer
    extends RichReduceFunction<Tuple2<StringValue, IntValue>> {
        public Tuple2<StringValue, IntValue> reduce(Tuple2<StringValue, IntValue> value1, Tuple2<StringValue, IntValue> value2) {
            ((StringValue)value2.f0).setValue((CharSequence)(((StringValue)value1.f0).getValue() + ((StringValue)value2.f0).getValue()));
            ((IntValue)value2.f1).setValue(((IntValue)value1.f1).getValue() + ((IntValue)value2.f1).getValue());
            return value2;
        }
    }
}

