/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.drivers;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.runtime.operators.AllGroupReduceDriver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.drivers.DriverTestData;
import org.apache.flink.runtime.operators.drivers.GatheringCollector;
import org.apache.flink.runtime.operators.drivers.TestTaskContext;
import org.apache.flink.runtime.operators.testutils.DiscardingOutputCollector;
import org.apache.flink.runtime.util.EmptyMutableObjectIterator;
import org.apache.flink.runtime.util.RegularToMutableObjectIterator;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AllGroupReduceDriverTest {
    AllGroupReduceDriverTest() {
    }

    @Test
    void testAllReduceDriverImmutableEmpty() {
        try {
            TestTaskContext context = new TestTaskContext();
            List<Tuple2<String, Integer>> data = DriverTestData.createReduceImmutableData();
            TypeInformation typeInfo = TypeExtractor.getForObject(data.get(0));
            MutableObjectIterator input = EmptyMutableObjectIterator.get();
            context.setDriverStrategy(DriverStrategy.ALL_GROUP_REDUCE);
            context.setInput1(input, typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            context.setCollector(new DiscardingOutputCollector());
            AllGroupReduceDriver driver = new AllGroupReduceDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testAllReduceDriverImmutable() {
        try {
            TestTaskContext context = new TestTaskContext();
            List<Tuple2<String, Integer>> data = DriverTestData.createReduceImmutableData();
            TypeInformation typeInfo = TypeExtractor.getForObject(data.get(0));
            RegularToMutableObjectIterator input = new RegularToMutableObjectIterator(data.iterator(), typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            GatheringCollector result = new GatheringCollector(typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            context.setDriverStrategy(DriverStrategy.ALL_GROUP_REDUCE);
            context.setInput1(input, typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            context.setCollector(result);
            context.setUdf(new ConcatSumReducer());
            AllGroupReduceDriver driver = new AllGroupReduceDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            Tuple2 res = (Tuple2)result.getList().get(0);
            char[] foundString = ((String)res.f0).toCharArray();
            Arrays.sort(foundString);
            char[] expectedString = "abcddeeeffff".toCharArray();
            Arrays.sort(expectedString);
            Assertions.assertThat((char[])foundString).isEqualTo((Object)expectedString);
            Assertions.assertThat((Integer)((Integer)res.f1)).isEqualTo(78);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testAllReduceDriverMutable() {
        try {
            TestTaskContext context = new TestTaskContext();
            List<Tuple2<StringValue, IntValue>> data = DriverTestData.createReduceMutableData();
            TypeInformation typeInfo = TypeExtractor.getForObject(data.get(0));
            RegularToMutableObjectIterator input = new RegularToMutableObjectIterator(data.iterator(), typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            GatheringCollector result = new GatheringCollector(typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            context.setDriverStrategy(DriverStrategy.ALL_GROUP_REDUCE);
            context.setInput1(input, typeInfo.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            context.setCollector(result);
            context.setUdf(new ConcatSumMutableReducer());
            AllGroupReduceDriver driver = new AllGroupReduceDriver();
            driver.setup(context);
            driver.prepare();
            driver.run();
            Tuple2 res = (Tuple2)result.getList().get(0);
            char[] foundString = ((StringValue)res.f0).getValue().toCharArray();
            Arrays.sort(foundString);
            char[] expectedString = "abcddeeeffff".toCharArray();
            Arrays.sort(expectedString);
            Assertions.assertThat((char[])foundString).isEqualTo((Object)expectedString);
            Assertions.assertThat((int)((IntValue)res.f1).getValue()).isEqualTo(78);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private static final class ConcatSumReducer
    extends RichGroupReduceFunction<Tuple2<String, Integer>, Tuple2<String, Integer>> {
        private ConcatSumReducer() {
        }

        public void reduce(Iterable<Tuple2<String, Integer>> values, Collector<Tuple2<String, Integer>> out) {
            Tuple2<String, Integer> current = new Tuple2<String, Integer>((Object)"", (Object)0);
            for (Tuple2<String, Integer> next : values) {
                next.f0 = (String)current.f0 + (String)next.f0;
                next.f1 = (Integer)current.f1 + (Integer)next.f1;
                current = next;
            }
            out.collect((Object)current);
        }
    }

    private static final class ConcatSumMutableReducer
    extends RichGroupReduceFunction<Tuple2<StringValue, IntValue>, Tuple2<StringValue, IntValue>> {
        private ConcatSumMutableReducer() {
        }

        public void reduce(Iterable<Tuple2<StringValue, IntValue>> values, Collector<Tuple2<StringValue, IntValue>> out) {
            Tuple2<StringValue, IntValue> current = new Tuple2<StringValue, IntValue>((Object)new StringValue((CharSequence)""), (Object)new IntValue(0));
            for (Tuple2<StringValue, IntValue> next : values) {
                ((StringValue)next.f0).append((StringValue)current.f0);
                ((IntValue)next.f1).setValue(((IntValue)current.f1).getValue() + ((IntValue)next.f1).getValue());
                current = next;
            }
            out.collect((Object)current);
        }
    }
}

