/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JobManagerJobGroupTest {
    JobManagerJobGroupTest() {
    }

    @Test
    void testGenerateScopeDefault() throws Exception {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        JobManagerJobMetricGroup jmGroup = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"theHostName").addJob(new JobID(), "myJobName");
        Assertions.assertThat((Object[])jmGroup.getScopeComponents()).containsExactly((Object[])new String[]{"theHostName", "jobmanager", "myJobName"});
        Assertions.assertThat((String)jmGroup.getMetricIdentifier("name")).isEqualTo("theHostName.jobmanager.myJobName.name");
        registry.closeAsync().get();
    }

    @Test
    void testGenerateScopeCustom() throws Exception {
        Configuration cfg = new Configuration();
        cfg.set(MetricOptions.SCOPE_NAMING_JM, (Object)"abc");
        cfg.set(MetricOptions.SCOPE_NAMING_JM_JOB, (Object)"some-constant.<job_name>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        JobManagerJobMetricGroup jmGroup = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"theHostName").addJob(new JobID(), "myJobName");
        Assertions.assertThat((Object[])jmGroup.getScopeComponents()).containsExactly((Object[])new String[]{"some-constant", "myJobName"});
        Assertions.assertThat((String)jmGroup.getMetricIdentifier("name")).isEqualTo("some-constant.myJobName.name");
        registry.closeAsync().get();
    }

    @Test
    void testGenerateScopeCustomWildcard() throws Exception {
        Configuration cfg = new Configuration();
        cfg.set(MetricOptions.SCOPE_NAMING_JM, (Object)"peter");
        cfg.set(MetricOptions.SCOPE_NAMING_JM_JOB, (Object)"*.some-constant.<job_id>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        JobID jid = new JobID();
        JobManagerJobMetricGroup jmGroup = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"theHostName").addJob(jid, "myJobName");
        Assertions.assertThat((Object[])jmGroup.getScopeComponents()).containsExactly((Object[])new String[]{"peter", "some-constant", jid.toString()});
        Assertions.assertThat((String)jmGroup.getMetricIdentifier("name")).isEqualTo("peter.some-constant." + jid + ".name");
        registry.closeAsync().get();
    }

    @Test
    void testCreateQueryServiceMetricInfo() {
        JobID jid = new JobID();
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        JobManagerJobMetricGroup jmj = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"theHostName").addJob(jid, "myJobName");
        QueryScopeInfo.JobQueryScopeInfo info = jmj.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assertions.assertThat((String)info.scope).isEmpty();
        Assertions.assertThat((String)info.jobID).isEqualTo(jid.toString());
    }
}

