/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.LeaderInformationRegister;

public abstract class LeaderElectionEvent {
    public boolean isIsLeaderEvent() {
        return false;
    }

    public boolean isNotLeaderEvent() {
        return false;
    }

    public boolean isLeaderInformationChangeEvent() {
        return false;
    }

    public boolean isAllKnownLeaderInformationEvent() {
        return false;
    }

    public boolean isErrorEvent() {
        return false;
    }

    public IsLeaderEvent asIsLeaderEvent() {
        return this.as(IsLeaderEvent.class);
    }

    public <T> T as(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalStateException("Cannot cast object.");
    }

    public static class IsLeaderEvent
    extends LeaderElectionEvent {
        private final UUID leaderSessionID;

        public IsLeaderEvent(UUID leaderSessionID) {
            this.leaderSessionID = leaderSessionID;
        }

        public UUID getLeaderSessionID() {
            return this.leaderSessionID;
        }

        @Override
        public boolean isIsLeaderEvent() {
            return true;
        }
    }

    public static class ErrorEvent
    extends LeaderElectionEvent {
        private final Throwable error;

        ErrorEvent(Throwable error) {
            this.error = error;
        }

        public Throwable getError() {
            return this.error;
        }

        @Override
        public boolean isErrorEvent() {
            return true;
        }
    }

    public static class AllLeaderInformationChangeEvent
    extends LeaderElectionEvent {
        private final LeaderInformationRegister leaderInformationRegister;

        AllLeaderInformationChangeEvent(LeaderInformationRegister leaderInformationRegister) {
            this.leaderInformationRegister = leaderInformationRegister;
        }

        @Override
        public boolean isAllKnownLeaderInformationEvent() {
            return true;
        }

        public LeaderInformationRegister getLeaderInformationRegister() {
            return this.leaderInformationRegister;
        }
    }

    public static class LeaderInformationChangeEvent
    extends LeaderElectionEvent {
        private final String componentId;
        private final LeaderInformation leaderInformation;

        LeaderInformationChangeEvent(String componentId, LeaderInformation leaderInformation) {
            this.componentId = componentId;
            this.leaderInformation = leaderInformation;
        }

        public LeaderInformation getLeaderInformation() {
            return this.leaderInformation;
        }

        public String getComponentId() {
            return this.componentId;
        }

        @Override
        public boolean isLeaderInformationChangeEvent() {
            return true;
        }
    }

    public static class NotLeaderEvent
    extends LeaderElectionEvent {
        @Override
        public boolean isNotLeaderEvent() {
            return true;
        }
    }
}

