/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.jobmanager.JobManagerProcessSpec;
import org.apache.flink.runtime.jobmanager.JobManagerProcessUtils;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtilsTestBase;
import org.apache.flink.runtime.util.config.memory.jobmanager.JobManagerFlinkMemoryUtils;
import org.apache.flink.testutils.logging.LoggerAuditingExtension;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableTypeAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

class JobManagerProcessUtilsTest
extends ProcessMemoryUtilsTestBase<JobManagerProcessSpec> {
    private static final Logger LOG = LoggerFactory.getLogger(JobManagerProcessUtilsTest.class);
    private static final MemorySize JVM_HEAP_SIZE = MemorySize.parse((String)"1152m");
    private static final MemorySize TOTAL_FLINK_MEM_SIZE = MemorySize.parse((String)"1280m");
    private static final MemorySize TOTAL_PROCESS_MEM_SIZE = MemorySize.parse((String)"1536m");
    @RegisterExtension
    private final LoggerAuditingExtension testLoggerResource = new LoggerAuditingExtension(JobManagerFlinkMemoryUtils.class, Level.INFO);

    public JobManagerProcessUtilsTest() {
        super(JobManagerProcessUtils.JM_PROCESS_MEMORY_OPTIONS, (ConfigOption<MemorySize>)JobManagerOptions.TOTAL_PROCESS_MEMORY);
    }

    @Test
    void testGenerateDynamicConfigurations() {
        Configuration config = new Configuration();
        config.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)MemorySize.parse((String)"1m"));
        config.set(JobManagerOptions.OFF_HEAP_MEMORY, (Object)MemorySize.parse((String)"2m"));
        config.set(JobManagerOptions.JVM_METASPACE, (Object)MemorySize.parse((String)"3m"));
        config.set(JobManagerOptions.JVM_OVERHEAD_MIN, (Object)MemorySize.parse((String)"4m"));
        config.set(JobManagerOptions.JVM_OVERHEAD_MAX, (Object)MemorySize.parse((String)"5m"));
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)config);
        String dynamicConfigsStr = JobManagerProcessUtils.generateDynamicConfigsStr((JobManagerProcessSpec)jobManagerProcessSpec);
        Map<String, String> configs = JobManagerProcessUtilsTest.parseAndAssertJobManagerResourceDynamicConfig(dynamicConfigsStr);
        Assertions.assertThat((Comparable)MemorySize.parse((String)configs.get(JobManagerOptions.JVM_HEAP_MEMORY.key()))).isEqualTo((Object)jobManagerProcessSpec.getJvmHeapMemorySize());
        Assertions.assertThat((Comparable)MemorySize.parse((String)configs.get(JobManagerOptions.OFF_HEAP_MEMORY.key()))).isEqualTo((Object)jobManagerProcessSpec.getJvmDirectMemorySize());
        Assertions.assertThat((Comparable)MemorySize.parse((String)configs.get(JobManagerOptions.JVM_METASPACE.key()))).isEqualTo((Object)jobManagerProcessSpec.getJvmMetaspaceSize());
        Assertions.assertThat((Comparable)MemorySize.parse((String)configs.get(JobManagerOptions.JVM_OVERHEAD_MIN.key()))).isEqualTo((Object)jobManagerProcessSpec.getJvmOverheadSize());
        Assertions.assertThat((Comparable)MemorySize.parse((String)configs.get(JobManagerOptions.JVM_OVERHEAD_MAX.key()))).isEqualTo((Object)jobManagerProcessSpec.getJvmOverheadSize());
    }

    private static Map<String, String> parseAndAssertJobManagerResourceDynamicConfig(String dynamicParameterStr) {
        HashMap<String, String> config = new HashMap<String, String>();
        String[] dynamicParameterTokens = dynamicParameterStr.split(" ");
        Assertions.assertThat((int)(dynamicParameterTokens.length % 2)).isZero();
        for (int i = 0; i < dynamicParameterTokens.length; ++i) {
            String configStr = dynamicParameterTokens[i];
            if (i % 2 == 0) {
                Assertions.assertThat((String)configStr).isEqualTo("-D");
                continue;
            }
            Object[] configEntry = configStr.split("=");
            Assertions.assertThat((Object[])configEntry).hasSize(2);
            config.put((String)configEntry[0], (String)configEntry[1]);
        }
        Assertions.assertThat(config).containsKey((Object)JobManagerOptions.JVM_HEAP_MEMORY.key());
        Assertions.assertThat(config).containsKey((Object)JobManagerOptions.OFF_HEAP_MEMORY.key());
        Assertions.assertThat(config).containsKey((Object)JobManagerOptions.JVM_METASPACE.key());
        Assertions.assertThat(config).containsKey((Object)JobManagerOptions.JVM_OVERHEAD_MIN.key());
        Assertions.assertThat(config).containsKey((Object)JobManagerOptions.JVM_OVERHEAD_MAX.key());
        return config;
    }

    @Test
    void testConfigJvmHeapMemory() {
        MemorySize jvmHeapSize = MemorySize.parse((String)"50m");
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)jvmHeapSize);
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)conf);
        Assertions.assertThat((Comparable)jobManagerProcessSpec.getJvmHeapMemorySize()).isEqualTo((Object)jvmHeapSize);
    }

    @Test
    void testLogFailureOfJvmHeapSizeMinSizeVerification() {
        MemorySize jvmHeapMemory = MemorySize.parse((String)"50m");
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)jvmHeapMemory);
        JobManagerProcessUtils.processSpecFromConfig((Configuration)conf);
        Assertions.assertThat((List)this.testLoggerResource.getMessages()).anyMatch(str -> str.contains(String.format("The configured or derived JVM heap memory size (%s) is less than its recommended minimum value (%s)", jvmHeapMemory.toHumanReadableString(), JobManagerOptions.MIN_JVM_HEAP_SIZE.toHumanReadableString())));
    }

    @Test
    void testConfigOffHeapMemory() {
        MemorySize offHeapMemory = MemorySize.parse((String)"100m");
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.OFF_HEAP_MEMORY, (Object)offHeapMemory);
        this.validateInAllConfigurationsWithoutExplicitTotalFlinkAndJvmHeapMem(conf, jobManagerProcessSpec -> Assertions.assertThat((Comparable)jobManagerProcessSpec.getJvmDirectMemorySize()).isEqualTo((Object)offHeapMemory));
    }

    @Test
    void testFlinkInternalMemorySizeAddUpFailure() {
        MemorySize totalFlinkMemory = MemorySize.parse((String)"199m");
        MemorySize jvmHeap = MemorySize.parse((String)"100m");
        MemorySize offHeapMemory = MemorySize.parse((String)"100m");
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.TOTAL_FLINK_MEMORY, (Object)totalFlinkMemory);
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)jvmHeap);
        conf.set(JobManagerOptions.OFF_HEAP_MEMORY, (Object)offHeapMemory);
        this.validateFail(conf);
    }

    @Test
    void testJvmHeapExceedsTotalFlinkMemoryFailure() {
        MemorySize totalFlinkMemory = MemorySize.ofMebiBytes((long)100L);
        MemorySize jvmHeap = MemorySize.ofMebiBytes((long)150L);
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.TOTAL_FLINK_MEMORY, (Object)totalFlinkMemory);
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)jvmHeap);
        this.validateFail(conf);
    }

    @Test
    void testOffHeapMemoryDerivedFromJvmHeapAndTotalFlinkMemory() {
        MemorySize jvmHeap = MemorySize.ofMebiBytes((long)150L);
        MemorySize defaultOffHeap = (MemorySize)JobManagerOptions.OFF_HEAP_MEMORY.defaultValue();
        MemorySize expectedOffHeap = MemorySize.ofMebiBytes((long)100L).add(defaultOffHeap);
        MemorySize totalFlinkMemory = jvmHeap.add(expectedOffHeap);
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.TOTAL_FLINK_MEMORY, (Object)totalFlinkMemory);
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)jvmHeap);
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)conf);
        Assertions.assertThat((Comparable)jobManagerProcessSpec.getJvmDirectMemorySize()).isEqualTo((Object)expectedOffHeap);
        Assertions.assertThat((List)this.testLoggerResource.getMessages()).anyMatch(str -> str.contains(String.format("The Off-Heap Memory size (%s) is derived the configured Total Flink Memory size (%s) minus the configured JVM Heap Memory size (%s). The default Off-Heap Memory size (%s) is ignored.", expectedOffHeap.toHumanReadableString(), totalFlinkMemory.toHumanReadableString(), jvmHeap.toHumanReadableString(), defaultOffHeap.toHumanReadableString())));
    }

    @Test
    void testDeriveFromRequiredFineGrainedOptions() {
        MemorySize jvmHeap = MemorySize.ofMebiBytes((long)150L);
        MemorySize offHeap = MemorySize.ofMebiBytes((long)50L);
        MemorySize totalFlinkMemory = MemorySize.ofMebiBytes((long)200L);
        MemorySize expectedOffHeap = MemorySize.ofMebiBytes((long)50L);
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.TOTAL_FLINK_MEMORY, (Object)totalFlinkMemory);
        conf.set(JobManagerOptions.OFF_HEAP_MEMORY, (Object)offHeap);
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)jvmHeap);
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)conf);
        Assertions.assertThat((Comparable)jobManagerProcessSpec.getJvmDirectMemorySize()).isEqualTo((Object)expectedOffHeap);
    }

    @Override
    protected JobManagerProcessSpec processSpecFromConfig(Configuration config) {
        return JobManagerProcessUtils.processSpecFromConfig((Configuration)config);
    }

    @Override
    protected void validateInAllConfigurations(Configuration customConfig, Consumer<JobManagerProcessSpec> validateFunc) {
        this.validateInConfigWithExplicitJvmHeap(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkAndJvmHeapMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalProcessMem(customConfig, validateFunc);
    }

    @Override
    protected void validateFailInAllConfigurations(Configuration customConfig) {
        this.validateFailInConfigWithExplicitJvmHeap(customConfig);
        this.validateFailInConfigWithExplicitTotalFlinkMem(customConfig);
        this.validateFailInConfigWithExplicitTotalFlinkAndJvmHeapMem(customConfig);
        this.validateFailInConfigWithExplicitTotalProcessMem(customConfig);
    }

    private void validateInAllConfigurationsWithoutExplicitTotalFlinkAndJvmHeapMem(Configuration customConfig, Consumer<JobManagerProcessSpec> validateFunc) {
        this.validateInConfigWithExplicitJvmHeap(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalFlinkMem(customConfig, validateFunc);
        this.validateInConfigWithExplicitTotalProcessMem(customConfig, validateFunc);
    }

    private void validateInConfigWithExplicitJvmHeap(Configuration customConfig, Consumer<JobManagerProcessSpec> validateFunc) {
        LOG.info("Validating in configuration with explicit jvm heap.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitJvmHeap();
        config.addAll(customConfig);
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)config);
        Assertions.assertThat((Comparable)jobManagerProcessSpec.getJvmHeapMemorySize()).isEqualTo((Object)JVM_HEAP_SIZE);
        validateFunc.accept(jobManagerProcessSpec);
    }

    private void validateFailInConfigWithExplicitJvmHeap(Configuration customConfig) {
        LOG.info("Validating failing in configuration with explicit jvm heap.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitJvmHeap();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    private void validateInConfigWithExplicitTotalFlinkMem(Configuration customConfig, Consumer<JobManagerProcessSpec> validateFunc) {
        LOG.info("Validating in configuration with explicit total flink memory size.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitTotalFlinkMem();
        config.addAll(customConfig);
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)config);
        Assertions.assertThat((Comparable)jobManagerProcessSpec.getTotalFlinkMemorySize()).isEqualTo((Object)TOTAL_FLINK_MEM_SIZE);
        validateFunc.accept(jobManagerProcessSpec);
    }

    private void validateFailInConfigWithExplicitTotalFlinkMem(Configuration customConfig) {
        LOG.info("Validating failing in configuration with explicit total flink memory size.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitTotalFlinkMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    private void validateInConfigWithExplicitTotalFlinkAndJvmHeapMem(Configuration customConfig, Consumer<JobManagerProcessSpec> validateFunc) {
        LOG.info("Validating in configuration with explicit total flink and jvm heap memory size.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitTotalFlinkAndJvmHeapMem();
        config.addAll(customConfig);
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)config);
        Assertions.assertThat((Comparable)jobManagerProcessSpec.getTotalFlinkMemorySize()).isEqualTo((Object)TOTAL_FLINK_MEM_SIZE);
        Assertions.assertThat((Comparable)jobManagerProcessSpec.getJvmHeapMemorySize()).isEqualTo((Object)JVM_HEAP_SIZE);
        validateFunc.accept(jobManagerProcessSpec);
    }

    private void validateFailInConfigWithExplicitTotalFlinkAndJvmHeapMem(Configuration customConfig) {
        LOG.info("Validating failing in configuration with explicit total flink and jvm heap memory size.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitTotalFlinkAndJvmHeapMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    private void validateInConfigWithExplicitTotalProcessMem(Configuration customConfig, Consumer<JobManagerProcessSpec> validateFunc) {
        LOG.info("Validating in configuration with explicit total process memory size.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitTotalProcessMem();
        config.addAll(customConfig);
        JobManagerProcessSpec jobManagerProcessSpec = JobManagerProcessUtils.processSpecFromConfig((Configuration)config);
        Assertions.assertThat((Comparable)jobManagerProcessSpec.getTotalProcessMemorySize()).isEqualTo((Object)TOTAL_PROCESS_MEM_SIZE);
        validateFunc.accept(jobManagerProcessSpec);
    }

    private void validateFailInConfigWithExplicitTotalProcessMem(Configuration customConfig) {
        LOG.info("Validating failing in configuration with explicit total process memory size.");
        Configuration config = JobManagerProcessUtilsTest.configWithExplicitTotalProcessMem();
        config.addAll(customConfig);
        this.validateFail(config);
    }

    @Override
    protected void validateFail(Configuration config) {
        ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(IllegalConfigurationException.class).as("Configuration did not fail as expected.", new Object[0])).isThrownBy(() -> JobManagerProcessUtils.processSpecFromConfig((Configuration)config));
    }

    @Override
    protected void configWithFineGrainedOptions(Configuration configuration, MemorySize totalFlinkMemorySize) {
        MemorySize heapSize = new MemorySize(totalFlinkMemorySize.getBytes() / 2L);
        MemorySize offHeapSize = totalFlinkMemorySize.subtract(heapSize);
        configuration.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)heapSize);
        configuration.set(JobManagerOptions.OFF_HEAP_MEMORY, (Object)offHeapSize);
    }

    private static Configuration configWithExplicitJvmHeap() {
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)JVM_HEAP_SIZE);
        return conf;
    }

    private static Configuration configWithExplicitTotalFlinkMem() {
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.TOTAL_FLINK_MEMORY, (Object)TOTAL_FLINK_MEM_SIZE);
        return conf;
    }

    private static Configuration configWithExplicitTotalFlinkAndJvmHeapMem() {
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.TOTAL_FLINK_MEMORY, (Object)TOTAL_FLINK_MEM_SIZE);
        conf.set(JobManagerOptions.JVM_HEAP_MEMORY, (Object)JVM_HEAP_SIZE);
        return conf;
    }

    private static Configuration configWithExplicitTotalProcessMem() {
        Configuration conf = new Configuration();
        conf.set(JobManagerOptions.TOTAL_PROCESS_MEMORY, (Object)TOTAL_PROCESS_MEM_SIZE);
        return conf;
    }
}

