/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle.TierFactoryInitializer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TestingTierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.disk.DiskTierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.memory.MemoryTierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteTierFactory;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TierFactoryInitializerTest {
    private static Path tmpDir;

    @BeforeAll
    public static void before(@TempDir Path path) throws Exception {
        tmpDir = TempDirUtils.newFolder((Path)path, (String[])new String[]{UUID.randomUUID().toString()}).toPath();
    }

    @AfterAll
    public static void after() throws IOException {
        FileUtils.deleteDirectory((File)tmpDir.toFile());
    }

    @Test
    void testInitEphemeralTiers() {
        Configuration configuration = new Configuration();
        List tierFactories = TierFactoryInitializer.initializeTierFactories((Configuration)configuration);
        Assertions.assertThat((List)tierFactories).hasSize(2);
        Assertions.assertThat((Object)((TierFactory)tierFactories.get(0))).isInstanceOf(MemoryTierFactory.class);
        Assertions.assertThat((Object)((TierFactory)tierFactories.get(1))).isInstanceOf(DiskTierFactory.class);
    }

    @Test
    void testInitEphemeralTiersWithRemoteTier() {
        Configuration configuration = new Configuration();
        configuration.set(NettyShuffleEnvironmentOptions.NETWORK_HYBRID_SHUFFLE_REMOTE_STORAGE_BASE_PATH, (Object)tmpDir.toString());
        List tierFactories = TierFactoryInitializer.initializeTierFactories((Configuration)configuration);
        Assertions.assertThat((List)tierFactories).hasSize(3);
        Assertions.assertThat((Object)((TierFactory)tierFactories.get(0))).isInstanceOf(MemoryTierFactory.class);
        Assertions.assertThat((Object)((TierFactory)tierFactories.get(1))).isInstanceOf(DiskTierFactory.class);
        Assertions.assertThat((Object)((TierFactory)tierFactories.get(2))).isInstanceOf(RemoteTierFactory.class);
    }

    @Test
    void testInitDurableTiersWithExternalRemoteTier() {
        Configuration configuration = new Configuration();
        configuration.set(NettyShuffleEnvironmentOptions.NETWORK_HYBRID_SHUFFLE_EXTERNAL_REMOTE_TIER_FACTORY_CLASS_NAME, (Object)ExternalRemoteTierFactory.class.getName());
        List tierFactories = TierFactoryInitializer.initializeTierFactories((Configuration)configuration);
        Assertions.assertThat((List)tierFactories).hasSize(1);
        Assertions.assertThat((Object)((TierFactory)tierFactories.get(0))).isInstanceOf(ExternalRemoteTierFactory.class);
    }

    @Test
    void testInitDurableExternalRemoteTierWithHigherPriority() {
        Configuration configuration = new Configuration();
        configuration.set(NettyShuffleEnvironmentOptions.NETWORK_HYBRID_SHUFFLE_REMOTE_STORAGE_BASE_PATH, (Object)tmpDir.toString());
        configuration.set(NettyShuffleEnvironmentOptions.NETWORK_HYBRID_SHUFFLE_EXTERNAL_REMOTE_TIER_FACTORY_CLASS_NAME, (Object)ExternalRemoteTierFactory.class.getName());
        List tierFactories = TierFactoryInitializer.initializeTierFactories((Configuration)configuration);
        Assertions.assertThat((List)tierFactories).hasSize(1);
        Assertions.assertThat((Object)((TierFactory)tierFactories.get(0))).isInstanceOf(ExternalRemoteTierFactory.class);
    }

    public static class ExternalRemoteTierFactory
    extends TestingTierFactory {
        @Override
        public void setup(Configuration configuration) {
        }
    }
}

