/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.index;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.flink.runtime.io.network.partition.hybrid.HybridShuffleTestUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.TestingFileDataIndexSpilledRegionManager;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexCache;
import org.apache.flink.runtime.io.network.partition.hybrid.index.TestingFileDataIndexRegion;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FileDataIndexCacheTest {
    private FileDataIndexCache<TestingFileDataIndexRegion> indexCache;
    private TestingFileDataIndexSpilledRegionManager<TestingFileDataIndexRegion> spilledRegionManager;
    private final int numSubpartitions = 1;
    private int numRetainedIndexEntry = 10;

    FileDataIndexCacheTest() {
    }

    @BeforeEach
    void before(@TempDir Path tmpPath) throws Exception {
        Path indexFilePath = Files.createFile(tmpPath.resolve(UUID.randomUUID().toString()), new FileAttribute[0]);
        TestingFileDataIndexSpilledRegionManager.Factory testingSpilledRegionManagerFactory = new TestingFileDataIndexSpilledRegionManager.Factory();
        this.indexCache = new FileDataIndexCache(1, indexFilePath, (long)this.numRetainedIndexEntry, testingSpilledRegionManagerFactory);
        this.spilledRegionManager = testingSpilledRegionManagerFactory.getLastSpilledRegionManager();
    }

    @Test
    void testPutAndGet() {
        this.indexCache.put(0, HybridShuffleTestUtils.createTestRegions(0, 0L, 3, 1));
        Optional regionOpt = this.indexCache.get(0, 0);
        Assertions.assertThat((Optional)regionOpt).hasValueSatisfying(region -> {
            Assertions.assertThat((int)region.getFirstBufferIndex()).isEqualTo(0);
            Assertions.assertThat((long)region.getRegionStartOffset()).isEqualTo(0L);
            Assertions.assertThat((int)region.getNumBuffers()).isEqualTo(3);
        });
    }

    @Test
    void testCachedRegionRemovedWhenExceedsRetainedEntry(@TempDir Path tmpPath) throws Exception {
        this.numRetainedIndexEntry = 3;
        Path indexFilePath = Files.createFile(tmpPath.resolve(UUID.randomUUID().toString()), new FileAttribute[0]);
        TestingFileDataIndexSpilledRegionManager.Factory testingSpilledRegionManagerFactory = new TestingFileDataIndexSpilledRegionManager.Factory();
        this.indexCache = new FileDataIndexCache(1, indexFilePath, (long)this.numRetainedIndexEntry, testingSpilledRegionManagerFactory);
        this.spilledRegionManager = testingSpilledRegionManagerFactory.getLastSpilledRegionManager();
        List<TestingFileDataIndexRegion> regionList = HybridShuffleTestUtils.createTestRegions(0, 0L, 3, 3);
        this.indexCache.put(0, regionList);
        Assertions.assertThat((int)this.spilledRegionManager.getSpilledRegionSize(0)).isZero();
        this.indexCache.put(0, HybridShuffleTestUtils.createTestRegions(9, 9L, 3, 1));
        Assertions.assertThat((int)this.spilledRegionManager.getSpilledRegionSize(0)).isEqualTo(1);
        TestingFileDataIndexRegion region = this.spilledRegionManager.getRegion(0, 0);
        Assertions.assertThat((Object)region).isNotNull();
        HybridShuffleTestUtils.assertRegionEquals(region, regionList.get(0));
        this.indexCache.put(0, HybridShuffleTestUtils.createTestRegions(12, 12L, 3, 1));
        Assertions.assertThat((int)this.spilledRegionManager.getSpilledRegionSize(0)).isEqualTo(2);
        TestingFileDataIndexRegion region2 = this.spilledRegionManager.getRegion(0, 3);
        Assertions.assertThat((Object)region2).isNotNull();
        HybridShuffleTestUtils.assertRegionEquals(region2, regionList.get(1));
    }

    @Test
    void testGetNonExistentRegion() {
        Optional region = this.indexCache.get(0, 0);
        Assertions.assertThat((Optional)region).isNotPresent();
    }

    @Test
    void testCacheLoadSpilledRegion(@TempDir Path tmpPath) throws Exception {
        this.numRetainedIndexEntry = 1;
        Path indexFilePath = Files.createFile(tmpPath.resolve(UUID.randomUUID().toString()), new FileAttribute[0]);
        TestingFileDataIndexSpilledRegionManager.Factory testingSpilledRegionManagerFactory = new TestingFileDataIndexSpilledRegionManager.Factory();
        this.indexCache = new FileDataIndexCache(1, indexFilePath, (long)this.numRetainedIndexEntry, testingSpilledRegionManagerFactory);
        this.spilledRegionManager = testingSpilledRegionManagerFactory.getLastSpilledRegionManager();
        this.indexCache.put(0, HybridShuffleTestUtils.createTestRegions(0, 0L, 1, 2));
        Assertions.assertThat((int)this.spilledRegionManager.getSpilledRegionSize(0)).isEqualTo(1);
        Assertions.assertThat((int)this.spilledRegionManager.getFindRegionInvoked()).isZero();
        Optional regionOpt = this.indexCache.get(0, 0);
        Assertions.assertThat((int)this.spilledRegionManager.getSpilledRegionSize(0)).isEqualTo(2);
        Assertions.assertThat((Optional)regionOpt).isPresent();
        Assertions.assertThat((int)this.spilledRegionManager.getFindRegionInvoked()).isEqualTo(1);
        Assertions.assertThat((Optional)this.indexCache.get(0, 0)).isPresent();
        Assertions.assertThat((int)this.spilledRegionManager.getFindRegionInvoked()).isEqualTo(1);
    }
}

