/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.filecache;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.filecache.FileCache;
import org.apache.flink.shaded.guava32.com.google.common.io.Files;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.InstantiationUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileCacheReadsFromBlobTest {
    private static final String testFileContent = "Goethe - Faust: Der Tragoedie erster Teil\nProlog im Himmel.\nDer Herr. Die himmlischen Heerscharen. Nachher Mephistopheles. Die drei\nErzengel treten vor.\nRAPHAEL: Die Sonne toent, nach alter Weise, In Brudersphaeren Wettgesang,\nUnd ihre vorgeschriebne Reise Vollendet sie mit Donnergang. Ihr Anblick\ngibt den Engeln Staerke, Wenn keiner Sie ergruenden mag; die unbegreiflich\nhohen Werke Sind herrlich wie am ersten Tag.\nGABRIEL: Und schnell und unbegreiflich schnelle Dreht sich umher der Erde\nPracht; Es wechselt Paradieseshelle Mit tiefer, schauervoller Nacht. Es\nschaeumt das Meer in breiten Fluessen Am tiefen Grund der Felsen auf, Und\nFels und Meer wird fortgerissen Im ewig schnellem Sphaerenlauf.\nMICHAEL: Und Stuerme brausen um die Wette Vom Meer aufs Land, vom Land\naufs Meer, und bilden wuetend eine Kette Der tiefsten Wirkung rings umher.\nDa flammt ein blitzendes Verheeren Dem Pfade vor des Donnerschlags. Doch\ndeine Boten, Herr, verehren Das sanfte Wandeln deines Tags.";
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private FileCache fileCache;
    private final PermanentBlobKey permanentBlobKey = new PermanentBlobKey();
    private final PermanentBlobService blobService = new PermanentBlobService(){

        public File getFile(JobID jobId, PermanentBlobKey key) throws IOException {
            if (key.equals((Object)FileCacheReadsFromBlobTest.this.permanentBlobKey)) {
                File f = FileCacheReadsFromBlobTest.this.temporaryFolder.newFile("cacheFile");
                FileUtils.writeFileUtf8((File)f, (String)FileCacheReadsFromBlobTest.testFileContent);
                return f;
            }
            throw new IllegalArgumentException("This service contains only entry for " + FileCacheReadsFromBlobTest.this.permanentBlobKey);
        }

        public void close() throws IOException {
        }
    };

    @Before
    public void setup() throws Exception {
        this.fileCache = new FileCache(new String[]{this.temporaryFolder.newFolder().getAbsolutePath()}, this.blobService);
    }

    @After
    public void shutdown() {
        this.fileCache.shutdown();
    }

    @Test
    public void testFileDownloadedFromBlob() throws Exception {
        JobID jobID = new JobID();
        ExecutionAttemptID attemptID = ExecutionGraphTestUtils.createExecutionAttemptId();
        String fileName = "test_file";
        DistributedCache.DistributedCacheEntry entry = new DistributedCache.DistributedCacheEntry("test_file", Boolean.valueOf(false), InstantiationUtil.serializeObject((Object)this.permanentBlobKey));
        Future copyResult = this.fileCache.createTmpFile("test_file", entry, jobID, attemptID);
        Path dstPath = (Path)copyResult.get();
        String actualContent = Files.toString((File)new File(dstPath.toUri()), (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)dstPath.getFileSystem().exists(dstPath));
        Assert.assertEquals((Object)testFileContent, (Object)actualContent);
    }
}

