/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.pekko;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.stream.Stream;
import org.apache.flink.runtime.rpc.pekko.RpcSerializedValue;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class RpcSerializedValueTest {
    RpcSerializedValueTest() {
    }

    @Test
    void testNullValue() throws Exception {
        RpcSerializedValue serializedValue = RpcSerializedValue.valueOf(null);
        Assertions.assertThat((byte[])serializedValue.getSerializedData()).isNull();
        Assertions.assertThat((int)serializedValue.getSerializedDataLength()).isEqualTo(0);
        Assertions.assertThat((Object)serializedValue.deserializeValue(this.getClass().getClassLoader())).isNull();
        RpcSerializedValue otherSerializedValue = RpcSerializedValue.valueOf(null);
        Assertions.assertThat((Object)otherSerializedValue).isEqualTo((Object)serializedValue);
        Assertions.assertThat((int)otherSerializedValue.hashCode()).isEqualTo(serializedValue.hashCode());
        RpcSerializedValue clonedSerializedValue = (RpcSerializedValue)InstantiationUtil.clone((Serializable)serializedValue);
        Assertions.assertThat((byte[])clonedSerializedValue.getSerializedData()).isNull();
        Assertions.assertThat((int)clonedSerializedValue.getSerializedDataLength()).isEqualTo(0);
        Assertions.assertThat((Object)clonedSerializedValue.deserializeValue(this.getClass().getClassLoader())).isNull();
        Assertions.assertThat((Object)clonedSerializedValue).isEqualTo((Object)serializedValue);
        Assertions.assertThat((int)clonedSerializedValue.hashCode()).isEqualTo(serializedValue.hashCode());
    }

    static Stream<Object> serializationArguments() {
        return Stream.of(true, (byte)5, (short)6, 5, 5L, Float.valueOf(5.5f), 6.5, Character.valueOf('c'), "string", Instant.now(), BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.TEN), BigDecimal.valueOf(Math.PI));
    }

    @ParameterizedTest
    @MethodSource(value={"serializationArguments"})
    void testNotNullValues(Object value) throws Exception {
        RpcSerializedValue serializedValue = RpcSerializedValue.valueOf((Object)value);
        Assertions.assertThat((byte[])serializedValue.getSerializedData()).isNotNull();
        Assertions.assertThat((int)serializedValue.getSerializedDataLength()).isGreaterThan(0);
        Assertions.assertThat((Object)serializedValue.deserializeValue(this.getClass().getClassLoader())).isEqualTo(value);
        RpcSerializedValue otherSerializedValue = RpcSerializedValue.valueOf((Object)value);
        Assertions.assertThat((Object)otherSerializedValue).isEqualTo((Object)serializedValue);
        Assertions.assertThat((int)otherSerializedValue.hashCode()).isEqualTo(serializedValue.hashCode());
        RpcSerializedValue clonedSerializedValue = (RpcSerializedValue)InstantiationUtil.clone((Serializable)serializedValue);
        Assertions.assertThat((byte[])clonedSerializedValue.getSerializedData()).isEqualTo((Object)serializedValue.getSerializedData());
        Assertions.assertThat((Object)clonedSerializedValue.deserializeValue(this.getClass().getClassLoader())).isEqualTo(value);
        Assertions.assertThat((Object)clonedSerializedValue).isEqualTo((Object)serializedValue);
        Assertions.assertThat((int)clonedSerializedValue.hashCode()).isEqualTo(serializedValue.hashCode());
    }
}

