/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.pekko;

import com.typesafe.config.Config;
import java.util.Optional;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.pekko.PekkoUtils;
import org.apache.flink.runtime.rpc.pekko.RobustActorSystem;
import org.apache.flink.util.concurrent.TestingUncaughtExceptionHandler;
import org.apache.pekko.actor.AbstractActor;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.japi.pf.ReceiveBuilder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class RobustActorSystemTest {
    private RobustActorSystem robustActorSystem = null;
    private TestingUncaughtExceptionHandler testingUncaughtExceptionHandler = null;

    RobustActorSystemTest() {
    }

    @BeforeEach
    void setup() {
        this.testingUncaughtExceptionHandler = new TestingUncaughtExceptionHandler();
        this.robustActorSystem = RobustActorSystem.create((String)"testSystem", (Config)PekkoUtils.getForkJoinExecutorConfig((RpcSystem.ForkJoinExecutorConfiguration)RpcUtils.getTestForkJoinExecutorConfiguration()), (Thread.UncaughtExceptionHandler)this.testingUncaughtExceptionHandler);
    }

    @AfterEach
    void teardown() {
        this.robustActorSystem.terminate();
        this.testingUncaughtExceptionHandler = null;
    }

    @Test
    void testUncaughtExceptionHandler() {
        UnknownError error = new UnknownError("Foobar");
        this.robustActorSystem.dispatcher().execute(() -> {
            throw error;
        });
        Throwable uncaughtException = this.testingUncaughtExceptionHandler.waitForUncaughtException();
        Assertions.assertThat((Throwable)uncaughtException).isSameAs((Object)error);
    }

    @Test
    void testUncaughtExceptionHandlerFromActor() {
        UnknownError error = new UnknownError();
        ActorRef actor = this.robustActorSystem.actorOf(Props.create(UncaughtExceptionActor.class, (Object[])new Object[]{error}));
        actor.tell((Object)new Failure(), null);
        Throwable uncaughtException = this.testingUncaughtExceptionHandler.waitForUncaughtException();
        Assertions.assertThat((Throwable)uncaughtException).isSameAs((Object)error);
    }

    @Test
    void testHonorClassloadingErrorBeforeShutdown() {
        this.robustActorSystem.uncaughtExceptionHandler().uncaughtException(Thread.currentThread(), new NoClassDefFoundError(""));
        Assertions.assertThat((Optional)this.testingUncaughtExceptionHandler.findUncaughtExceptionNow()).isPresent();
    }

    @ParameterizedTest
    @ValueSource(classes={NoClassDefFoundError.class, ClassNotFoundException.class})
    void testIgnoreClassloadingErrorAfterShutdown(Class<? extends Throwable> exceptionClass) throws Exception {
        this.robustActorSystem.terminate();
        this.robustActorSystem.getWhenTerminated().toCompletableFuture().join();
        this.robustActorSystem.uncaughtExceptionHandler().uncaughtException(Thread.currentThread(), exceptionClass.getDeclaredConstructor(String.class).newInstance(""));
        Assertions.assertThat((Optional)this.testingUncaughtExceptionHandler.findUncaughtExceptionNow()).isEmpty();
    }

    private static class UncaughtExceptionActor
    extends AbstractActor {
        private final Error failure;

        public UncaughtExceptionActor(Error failure) {
            this.failure = failure;
        }

        public AbstractActor.Receive createReceive() {
            return ReceiveBuilder.create().match(Failure.class, ignored -> {
                throw this.failure;
            }).build();
        }
    }

    private static class Failure {
        private Failure() {
        }
    }
}

