/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.pekko;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RpcOptions;
import org.apache.flink.runtime.rpc.Local;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.pekko.PekkoRpcServiceUtils;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class MessageSerializationTest {
    private static RpcService rpcService1;
    private static RpcService rpcService2;
    private static final int maxFrameSize = 32000;

    MessageSerializationTest() {
    }

    @BeforeAll
    static void setup() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set(RpcOptions.FRAMESIZE, (Object)"32000b");
        rpcService1 = PekkoRpcServiceUtils.remoteServiceBuilder((Configuration)configuration, (String)"localhost", (int)0).createAndStart();
        rpcService2 = PekkoRpcServiceUtils.remoteServiceBuilder((Configuration)configuration, (String)"localhost", (int)0).createAndStart();
    }

    @AfterAll
    static void teardown() throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<CompletableFuture> terminationFutures = new ArrayList<CompletableFuture>(2);
        terminationFutures.add(rpcService1.closeAsync());
        terminationFutures.add(rpcService2.closeAsync());
        FutureUtils.waitForAll(terminationFutures).get();
    }

    @Test
    void testNonSerializableLocalMessageTransfer() throws Exception {
        LinkedBlockingQueue<Object> linkedBlockingQueue = new LinkedBlockingQueue<Object>();
        TestEndpoint testEndpoint = new TestEndpoint(rpcService1, linkedBlockingQueue);
        testEndpoint.start();
        TestGateway testGateway = (TestGateway)testEndpoint.getSelfGateway(TestGateway.class);
        NonSerializableObject expected = new NonSerializableObject(42);
        testGateway.foobar(expected);
        Assertions.assertThat((Object)linkedBlockingQueue.take()).isSameAs((Object)expected);
    }

    @Test
    void testNonSerializableRemoteMessageTransfer() throws Exception {
        LinkedBlockingQueue<Object> linkedBlockingQueue = new LinkedBlockingQueue<Object>();
        TestEndpoint testEndpoint = new TestEndpoint(rpcService1, linkedBlockingQueue);
        testEndpoint.start();
        String address = testEndpoint.getAddress();
        TestGateway remoteGateway = (TestGateway)rpcService2.connect(address, TestGateway.class).get();
        Assertions.assertThatThrownBy(() -> remoteGateway.foobar(new Object())).isInstanceOf(IOException.class);
    }

    @Test
    void testSerializableRemoteMessageTransfer() throws Exception {
        LinkedBlockingQueue<Object> linkedBlockingQueue = new LinkedBlockingQueue<Object>();
        TestEndpoint testEndpoint = new TestEndpoint(rpcService1, linkedBlockingQueue);
        testEndpoint.start();
        String address = testEndpoint.getAddress();
        CompletableFuture remoteGatewayFuture = rpcService2.connect(address, TestGateway.class);
        TestGateway remoteGateway = (TestGateway)remoteGatewayFuture.get();
        int expected = 42;
        remoteGateway.foobar(expected);
        Assertions.assertThat((Object)linkedBlockingQueue.take()).isEqualTo((Object)expected);
    }

    @Test
    void testMaximumFramesizeRemoteMessageTransfer() throws Throwable {
        LinkedBlockingQueue<Object> linkedBlockingQueue = new LinkedBlockingQueue<Object>();
        TestEndpoint testEndpoint = new TestEndpoint(rpcService1, linkedBlockingQueue);
        testEndpoint.start();
        String address = testEndpoint.getAddress();
        TestGateway remoteGateway = (TestGateway)rpcService2.connect(address, TestGateway.class).get();
        int bufferSize = 32001;
        byte[] buffer = new byte[bufferSize];
        CompletableFuture<Void> completableFuture = remoteGateway.foobar(buffer);
        Assertions.assertThatThrownBy(completableFuture::get).hasCauseInstanceOf(TimeoutException.class);
    }

    private static class TestEndpoint
    extends RpcEndpoint
    implements TestGateway {
        private final LinkedBlockingQueue<Object> queue;

        protected TestEndpoint(RpcService rpcService, LinkedBlockingQueue<Object> queue) {
            super(rpcService);
            this.queue = queue;
        }

        @Override
        public CompletableFuture<Void> foobar(Object object) throws InterruptedException {
            this.queue.put(object);
            return CompletableFuture.completedFuture(null);
        }
    }

    private static interface TestGateway
    extends RpcGateway {
        @Local
        public CompletableFuture<Void> foobar(Object var1) throws IOException, InterruptedException;
    }

    private static class NonSerializableObject {
        private final Object object = new Object();
        private final int value;

        NonSerializableObject(int value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NonSerializableObject) {
                NonSerializableObject nonSerializableObject = (NonSerializableObject)obj;
                return this.value == nonSerializableObject.value;
            }
            return false;
        }

        public int hashCode() {
            return this.value * 41;
        }
    }
}

