/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.pekko;

import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.pekko.PekkoRpcService;
import org.apache.flink.runtime.rpc.pekko.PekkoRpcServiceConfiguration;
import org.apache.flink.runtime.rpc.pekko.PekkoUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MainThreadValidationTest {
    MainThreadValidationTest() {
    }

    @Test
    void failIfNotInMainThread() throws Exception {
        try {
            assert (false);
            return;
        }
        catch (AssertionError assertionError) {
            PekkoRpcService pekkoRpcService = new PekkoRpcService(PekkoUtils.createDefaultActorSystem(), PekkoRpcServiceConfiguration.defaultConfiguration());
            try {
                TestEndpoint testEndpoint = new TestEndpoint((RpcService)pekkoRpcService);
                testEndpoint.start();
                ((TestGateway)testEndpoint.getSelfGateway(TestGateway.class)).someConcurrencyCriticalFunction();
                Assertions.assertThatThrownBy(() -> testEndpoint.someConcurrencyCriticalFunction()).isInstanceOf(AssertionError.class);
                testEndpoint.closeAsync();
            }
            finally {
                pekkoRpcService.closeAsync().get();
            }
            return;
        }
    }

    private static class TestEndpoint
    extends RpcEndpoint
    implements TestGateway {
        private TestEndpoint(RpcService rpcService) {
            super(rpcService);
        }

        @Override
        public void someConcurrencyCriticalFunction() {
            this.validateRunsInMainThread();
        }
    }

    static interface TestGateway
    extends RpcGateway {
        public void someConcurrencyCriticalFunction();
    }
}

