/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.itcases;

import java.nio.file.Path;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.QueryableStateOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.queryablestate.client.QueryableStateClient;
import org.apache.flink.queryablestate.itcases.AbstractQueryableStateTestBase;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.util.CheckpointStorageUtils;
import org.apache.flink.streaming.util.StateBackendUtils;
import org.apache.flink.test.junit5.InjectClusterClient;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

public class NonHAQueryableStateRocksDBBackendITCase
extends AbstractQueryableStateTestBase {
    private static final int NUM_TMS = 2;
    private static final int NUM_SLOTS_PER_TM = 2;
    private static final int QS_PROXY_PORT_RANGE_START = 9094;
    private static final int QS_SERVER_PORT_RANGE_START = 9099;
    @TempDir
    static Path tmpStateBackendDir;
    @RegisterExtension
    static final MiniClusterExtension MINI_CLUSTER_RESOURCE;

    @Override
    protected StreamExecutionEnvironment createEnv() throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StateBackendUtils.configureRocksDBStateBackend((StreamExecutionEnvironment)env);
        CheckpointStorageUtils.configureFileSystemCheckpointStorage((StreamExecutionEnvironment)env, (String)tmpStateBackendDir.toUri().toString());
        return env;
    }

    @BeforeAll
    static void setup(@InjectClusterClient RestClusterClient<?> injectedClusterClient) throws Exception {
        client = new QueryableStateClient("localhost", 9094);
        clusterClient = injectedClusterClient;
    }

    @AfterAll
    static void tearDown() {
        client.shutdownAndWait();
    }

    private static Configuration getConfig() {
        Configuration config = new Configuration();
        config.set(QueryableStateOptions.ENABLE_QUERYABLE_STATE_PROXY_SERVER, (Object)true);
        config.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, (Object)MemorySize.parse((String)"4m"));
        config.set(TaskManagerOptions.MINI_CLUSTER_NUM_TASK_MANAGERS, (Object)2);
        config.set(TaskManagerOptions.NUM_TASK_SLOTS, (Object)2);
        config.set(QueryableStateOptions.CLIENT_NETWORK_THREADS, (Object)1);
        config.set(QueryableStateOptions.PROXY_NETWORK_THREADS, (Object)1);
        config.set(QueryableStateOptions.SERVER_NETWORK_THREADS, (Object)1);
        config.set(QueryableStateOptions.PROXY_PORT_RANGE, (Object)"9094-9096");
        config.set(QueryableStateOptions.SERVER_PORT_RANGE, (Object)"9099-9101");
        config.set(WebOptions.SUBMIT_ENABLE, (Object)false);
        return config;
    }

    static {
        MINI_CLUSTER_RESOURCE = new MiniClusterExtension(() -> new MiniClusterResourceConfiguration.Builder().setConfiguration(NonHAQueryableStateRocksDBBackendITCase.getConfig()).setNumberTaskManagers(2).setNumberSlotsPerTaskManager(2).build());
    }
}

