/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.Arrays;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.junit.Assert;

public class TestingFunctions {

    public static class TableFunc1
    extends TableFunction<String> {
        public void eval(String str) {
            if (str.contains("#")) {
                Arrays.stream(str.split("#")).forEach(x$0 -> this.collect(x$0));
            }
        }

        public void eval(String str, String prefix) {
            if (str.contains("#")) {
                Arrays.stream(str.split("#")).forEach(s -> this.collect(prefix + s));
            }
        }
    }

    public static class ByteMaxAggFunction
    extends MaxAggFunction<Byte> {
        @Override
        Byte getInitValue() {
            return (byte)0;
        }

        @Override
        TypeInformation<?> getValueTypeInfo() {
            return Types.BYTE;
        }
    }

    static abstract class MaxAggFunction<T extends Comparable>
    extends AggregateFunction<T, MaxAccumulator<T>> {
        MaxAggFunction() {
        }

        public T getValue(MaxAccumulator<T> accumulator) {
            if (((Boolean)accumulator.f1).booleanValue()) {
                return (T)((Comparable)accumulator.f0);
            }
            return null;
        }

        public MaxAccumulator<T> createAccumulator() {
            MaxAccumulator accumulator = new MaxAccumulator();
            accumulator.f0 = this.getInitValue();
            accumulator.f1 = false;
            return accumulator;
        }

        public void accumulate(MaxAccumulator<T> acc, Object value) {
            if (value != null) {
                Comparable t = (Comparable)value;
                if (!((Boolean)acc.f1).booleanValue() || ((Comparable)acc.f0).compareTo(t) < 0) {
                    acc.f0 = t;
                    acc.f1 = true;
                }
            }
        }

        public void merge(MaxAccumulator<T> accumulator, Iterable<MaxAccumulator<T>> its) {
            for (MaxAccumulator<T> a : its) {
                if (!((Boolean)a.f1).booleanValue()) continue;
                this.accumulate(accumulator, a.f0);
            }
        }

        public void resetAccumulator(MaxAccumulator<T> accumulator) {
            accumulator.f0 = this.getInitValue();
            accumulator.f1 = false;
        }

        abstract T getInitValue();

        abstract TypeInformation<?> getValueTypeInfo();
    }

    static class MaxAccumulator<T extends Comparable>
    extends Tuple2<T, Boolean> {
        MaxAccumulator() {
        }
    }

    public static class RichFunc0
    extends ScalarFunction {
        private boolean openCalled = false;
        private boolean closeCalled = false;

        public void open(FunctionContext context) throws Exception {
            super.open(context);
            if (this.openCalled) {
                Assert.fail((String)"Open called more than once.");
            } else {
                this.openCalled = true;
            }
            if (this.closeCalled) {
                Assert.fail((String)"Close called before open.");
            }
        }

        public Integer eval(Integer index) {
            if (!this.openCalled) {
                Assert.fail((String)"Open was not called before eval.");
            }
            if (this.closeCalled) {
                Assert.fail((String)"Close called before eval.");
            }
            return index + 1;
        }

        public void close() throws Exception {
            super.close();
            if (this.closeCalled) {
                Assert.fail((String)"Close called more than once.");
            } else {
                this.closeCalled = true;
            }
            if (!this.openCalled) {
                Assert.fail((String)"Open was not called before close.");
            }
        }
    }
}

