/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream;

import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.python.PythonFunctionRunner;
import org.apache.flink.python.PythonOptions;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.python.PythonFunctionInfo;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.AbstractArrowPythonAggregateFunctionOperator;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.AbstractStreamArrowPythonAggregateFunctionOperatorTest;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.stream.StreamArrowPythonRowTimeBoundedRowsOperator;
import org.apache.flink.table.runtime.utils.PassThroughPythonAggregateFunctionRunner;
import org.apache.flink.table.runtime.utils.PythonTestUtils;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.junit.jupiter.api.Test;

class StreamArrowPythonRowTimeBoundedRowsOperatorTest
extends AbstractStreamArrowPythonAggregateFunctionOperatorTest {
    StreamArrowPythonRowTimeBoundedRowsOperatorTest() {
    }

    @Test
    void testOverWindowAggregateFunction() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(new Configuration());
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c2", 0L, 1L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c4", 1L, 1L), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c6", 2L, 10L), initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c2", "c8", 3L, 2L), initialTime + 3L));
        testHarness.processWatermark(Long.MAX_VALUE);
        testHarness.close();
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c2", 0L, 1L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c4", 1L, 1L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", "c8", 3L, 2L, 3L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c6", 2L, 10L, 1L)));
        expectedOutput.add(new Watermark(Long.MAX_VALUE));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testFinishBundleTriggeredOnWatermark() throws Exception {
        Configuration conf = new Configuration();
        conf.set(PythonOptions.MAX_BUNDLE_SIZE, (Object)10);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(conf);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c2", 0L, 1L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c4", 1L, 1L), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c6", 2L, 10L), initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c2", "c8", 3L, 2L), initialTime + 3L));
        testHarness.processWatermark(new Watermark(10000L));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c2", 0L, 1L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c4", 1L, 1L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", "c8", 3L, 2L, 3L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c6", 2L, 10L, 1L)));
        expectedOutput.add(new Watermark(10000L));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    @Test
    void testFinishBundleTriggeredByCount() throws Exception {
        Configuration conf = new Configuration();
        conf.set(PythonOptions.MAX_BUNDLE_SIZE, (Object)6);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(conf);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c2", 0L, 1L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c4", 1L, 1L), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c6", 2L, 10L), initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c2", "c8", 3L, 2L), initialTime + 3L));
        this.assertOutputEquals("FinishBundle should not be triggered.", expectedOutput, testHarness.getOutput());
        testHarness.processWatermark(new Watermark(1000L));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c2", 0L, 1L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c4", 1L, 1L, 0L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", "c8", 3L, 2L, 3L)));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", "c6", 2L, 10L, 1L)));
        expectedOutput.add(new Watermark(1000L));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    @Override
    public LogicalType[] getOutputLogicalType() {
        return new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.BIGINT().getLogicalType()};
    }

    @Override
    public RowType getInputType() {
        return new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new VarCharType()), new RowType.RowField("f2", (LogicalType)new VarCharType()), new RowType.RowField("f3", (LogicalType)new BigIntType()), new RowType.RowField("rowTime", (LogicalType)new BigIntType())));
    }

    @Override
    public RowType getOutputType() {
        return new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new VarCharType()), new RowType.RowField("f2", (LogicalType)new VarCharType()), new RowType.RowField("f3", (LogicalType)new BigIntType()), new RowType.RowField("rowTime", (LogicalType)new BigIntType()), new RowType.RowField("agg", (LogicalType)new BigIntType())));
    }

    @Override
    public AbstractArrowPythonAggregateFunctionOperator getTestOperator(Configuration config, PythonFunctionInfo[] pandasAggregateFunctions, RowType inputType, RowType outputType, int[] groupingSet, int[] udafInputOffsets) {
        RowType udfInputType = (RowType)Projection.of((int[])udafInputOffsets).project((LogicalType)inputType);
        RowType udfOutputType = (RowType)Projection.range((int)inputType.getFieldCount(), (int)outputType.getFieldCount()).project((LogicalType)outputType);
        return new PassThroughStreamArrowPythonRowTimeBoundedRowsOperator(config, pandasAggregateFunctions, inputType, udfInputType, udfOutputType, 3, 1L, ProjectionCodeGenerator.generateProjection((CodeGeneratorContext)new CodeGeneratorContext((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader()), (String)"UdafInputProjection", (RowType)inputType, (RowType)udfInputType, (int[])udafInputOffsets));
    }

    private static class PassThroughStreamArrowPythonRowTimeBoundedRowsOperator
    extends StreamArrowPythonRowTimeBoundedRowsOperator {
        PassThroughStreamArrowPythonRowTimeBoundedRowsOperator(Configuration config, PythonFunctionInfo[] pandasAggFunctions, RowType inputType, RowType udfInputType, RowType udfOutputType, int inputTimeFieldIndex, long lowerBoundary, GeneratedProjection inputGeneratedProjection) {
            super(config, 1000L, 2000L, pandasAggFunctions, inputType, udfInputType, udfOutputType, inputTimeFieldIndex, lowerBoundary, inputGeneratedProjection);
        }

        public PythonFunctionRunner createPythonFunctionRunner() {
            return new PassThroughPythonAggregateFunctionRunner(this.getContainingTask().getEnvironment(), this.getRuntimeContext().getTaskInfo().getTaskName(), PythonTestUtils.createTestProcessEnvironmentManager(), this.udfInputType, this.udfOutputType, this.getFunctionUrn(), this.createUserDefinedFunctionsProto(), PythonTestUtils.createMockFlinkMetricContainer(), false);
        }
    }
}

