/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.util.CompressionUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class CompressionUtilsTest {
    private static final int S_IFLNK = 40960;

    CompressionUtilsTest() {
    }

    @Test
    void testSymlink(@TempDir Path zipPath, @TempDir Path target) throws IOException {
        File zipFile = Files.createTempFile(zipPath, null, null, new FileAttribute[0]).toFile();
        try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));){
            String file1 = "zipFile1";
            ZipArchiveEntry entry = new ZipArchiveEntry(file1);
            entry.setUnixMode(420);
            zipOut.putArchiveEntry(entry);
            zipOut.write(new byte[]{1, 1, 1, 1, 1});
            zipOut.closeArchiveEntry();
            String file2 = "zipFile2";
            entry = new ZipArchiveEntry(file2);
            entry.setUnixMode(420);
            zipOut.putArchiveEntry(entry);
            zipOut.write(new byte[]{2, 2, 2, 2, 2});
            zipOut.closeArchiveEntry();
            entry = new ZipArchiveEntry("softlink");
            entry.setUnixMode(41380);
            zipOut.putArchiveEntry(entry);
            zipOut.write(file1.getBytes(ConfigConstants.DEFAULT_CHARSET));
            zipOut.closeArchiveEntry();
        }
        String targetPath = target.toString();
        CompressionUtils.extractZipFileWithPermissions((String)zipFile.getCanonicalPath(), (String)targetPath);
        Path softLink = new File(targetPath, "softlink").toPath();
        Assertions.assertThat((boolean)Files.isSymbolicLink(softLink)).isTrue();
        Assertions.assertThat((String)Files.readSymbolicLink(softLink).toString()).endsWith((CharSequence)"zipFile1");
        Path file1Path = new File(targetPath, "zipFile1").toPath();
        Assertions.assertThat((boolean)Files.isRegularFile(file1Path, new LinkOption[0])).isTrue();
        Assertions.assertThat((byte[])Files.readAllBytes(file1Path)).isEqualTo((Object)new byte[]{1, 1, 1, 1, 1});
        Path file2Path = new File(targetPath, "zipFile2").toPath();
        Assertions.assertThat((boolean)Files.isRegularFile(file2Path, new LinkOption[0])).isTrue();
        Assertions.assertThat((byte[])Files.readAllBytes(file2Path)).isEqualTo((Object)new byte[]{2, 2, 2, 2, 2});
    }

    @Test
    void testSymlinkWithoutTargetFile(@TempDir Path zipPath, @TempDir Path target) throws IOException {
        File zipFile = Files.createTempFile(zipPath, null, null, new FileAttribute[0]).toFile();
        try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));){
            ZipArchiveEntry entry = new ZipArchiveEntry("softlink");
            entry.setUnixMode(41380);
            zipOut.putArchiveEntry(entry);
            zipOut.write("targetFile".getBytes(ConfigConstants.DEFAULT_CHARSET));
            zipOut.closeArchiveEntry();
        }
        String targetPath = target.toString();
        CompressionUtils.extractZipFileWithPermissions((String)zipFile.getCanonicalPath(), (String)targetPath);
        Path softLink = new File(targetPath, "softlink").toPath();
        Assertions.assertThat((boolean)Files.isSymbolicLink(softLink)).isTrue();
        Assertions.assertThat((String)Files.readSymbolicLink(softLink).toString()).endsWith((CharSequence)"targetFile");
    }

    @Test
    void testExpandOutOfTargetDir(@TempDir Path zipPath, @TempDir Path target) throws IOException {
        File zipFile = Files.createTempFile(zipPath, null, null, new FileAttribute[0]).toFile();
        try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));){
            String file1 = "../zipFile";
            ZipArchiveEntry entry = new ZipArchiveEntry(file1);
            zipOut.putArchiveEntry(entry);
            zipOut.write(new byte[]{1, 1, 1, 1, 1});
            zipOut.closeArchiveEntry();
        }
        String targetPath = target.toString();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> CompressionUtils.extractZipFileWithPermissions((String)zipFile.getCanonicalPath(), (String)targetPath)).isInstanceOf(IOException.class)).hasMessageContaining("Expand ../zipFile would create a file outside of");
    }

    @Test
    void testPermissionRestored(@TempDir Path zipPath, @TempDir Path target) throws IOException {
        File zipFile = Files.createTempFile(zipPath, null, null, new FileAttribute[0]).toFile();
        try (ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipFile));){
            String file1 = "zipFile";
            ZipArchiveEntry entry = new ZipArchiveEntry(file1);
            entry.setUnixMode(237);
            zipOut.putArchiveEntry(entry);
            zipOut.write(new byte[]{1, 1, 1, 1, 1});
            zipOut.closeArchiveEntry();
        }
        String targetPath = target.toString();
        CompressionUtils.extractZipFileWithPermissions((String)zipFile.getCanonicalPath(), (String)targetPath);
        Path path = new File(targetPath, "zipFile").toPath();
        Assertions.assertThat((int)this.toUnixMode(Files.getPosixFilePermissions(path, new LinkOption[0]))).isEqualTo(237);
    }

    private int toUnixMode(Set<PosixFilePermission> permission) {
        int mode = 0;
        for (PosixFilePermission action : PosixFilePermission.values()) {
            mode <<= 1;
            mode += permission.contains((Object)action) ? 1 : 0;
        }
        return mode;
    }
}

