/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.env;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.Path;
import org.apache.flink.python.PythonOptions;
import org.apache.flink.python.env.PythonDependencyInfo;
import org.apache.flink.util.OperatingSystem;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;

class PythonDependencyInfoTest {
    private DistributedCache distributedCache;

    public PythonDependencyInfoTest() {
        HashMap<String, CompletableFuture<Path>> distributeCachedFiles = new HashMap<String, CompletableFuture<Path>>();
        distributeCachedFiles.put("python_file_{SHA256_0}", CompletableFuture.completedFuture(new Path("/distributed_cache/file0")));
        distributeCachedFiles.put("python_file_{SHA256_1}", CompletableFuture.completedFuture(new Path("/distributed_cache/file1")));
        distributeCachedFiles.put("python_requirements_file_{SHA256}", CompletableFuture.completedFuture(new Path("/distributed_cache/file2")));
        distributeCachedFiles.put("python_requirements_cache_{SHA256}", CompletableFuture.completedFuture(new Path("/distributed_cache/file3")));
        distributeCachedFiles.put("python_archive_{SHA256_0}", CompletableFuture.completedFuture(new Path("/distributed_cache/file4")));
        distributeCachedFiles.put("python_archive_{SHA256_1}", CompletableFuture.completedFuture(new Path("/distributed_cache/file5")));
        this.distributedCache = new DistributedCache(distributeCachedFiles);
    }

    @Test
    void testParsePythonFiles() {
        Assumptions.assumeThat((boolean)OperatingSystem.isWindows()).isFalse();
        Configuration config = new Configuration();
        HashMap<String, String> pythonFiles = new HashMap<String, String>();
        pythonFiles.put("python_file_{SHA256_0}", "test_file1.py");
        pythonFiles.put("python_file_{SHA256_1}", "test_file2.py");
        config.set(PythonOptions.PYTHON_FILES_DISTRIBUTED_CACHE_INFO, pythonFiles);
        PythonDependencyInfo dependencyInfo = PythonDependencyInfo.create((ReadableConfig)config, (DistributedCache)this.distributedCache);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("/distributed_cache/file0", "test_file1.py");
        expected.put("/distributed_cache/file1", "test_file2.py");
        Assertions.assertThat((Map)dependencyInfo.getPythonFiles()).isEqualTo(expected);
    }

    @Test
    void testParsePythonRequirements() throws IOException {
        Assumptions.assumeThat((boolean)OperatingSystem.isWindows()).isFalse();
        Configuration config = new Configuration();
        config.set(PythonOptions.PYTHON_REQUIREMENTS_FILE_DISTRIBUTED_CACHE_INFO, new HashMap());
        ((Map)config.get(PythonOptions.PYTHON_REQUIREMENTS_FILE_DISTRIBUTED_CACHE_INFO)).put("file", "python_requirements_file_{SHA256}");
        PythonDependencyInfo dependencyInfo = PythonDependencyInfo.create((ReadableConfig)config, (DistributedCache)this.distributedCache);
        Assertions.assertThat((String)((String)dependencyInfo.getRequirementsFilePath().get())).isEqualTo("/distributed_cache/file2");
        Assertions.assertThat((Optional)dependencyInfo.getRequirementsCacheDir()).isNotPresent();
        ((Map)config.get(PythonOptions.PYTHON_REQUIREMENTS_FILE_DISTRIBUTED_CACHE_INFO)).put("cache", "python_requirements_cache_{SHA256}");
        dependencyInfo = PythonDependencyInfo.create((ReadableConfig)config, (DistributedCache)this.distributedCache);
        Assertions.assertThat((String)((String)dependencyInfo.getRequirementsFilePath().get())).isEqualTo("/distributed_cache/file2");
        Assertions.assertThat((String)((String)dependencyInfo.getRequirementsCacheDir().get())).isEqualTo("/distributed_cache/file3");
    }

    @Test
    void testParsePythonArchives() {
        Assumptions.assumeThat((boolean)OperatingSystem.isWindows()).isFalse();
        Configuration config = new Configuration();
        HashMap<String, String> pythonArchives = new HashMap<String, String>();
        pythonArchives.put("python_archive_{SHA256_0}", "py27.zip");
        pythonArchives.put("python_archive_{SHA256_1}", "py37");
        config.set(PythonOptions.PYTHON_ARCHIVES_DISTRIBUTED_CACHE_INFO, pythonArchives);
        PythonDependencyInfo dependencyInfo = PythonDependencyInfo.create((ReadableConfig)config, (DistributedCache)this.distributedCache);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("/distributed_cache/file4", "py27.zip");
        expected.put("/distributed_cache/file5", "py37");
        Assertions.assertThat((Map)dependencyInfo.getArchives()).isEqualTo(expected);
    }

    @Test
    void testParsePythonExec() {
        Configuration config = new Configuration();
        config.set(PythonOptions.PYTHON_EXECUTABLE, (Object)"/usr/bin/python3");
        PythonDependencyInfo dependencyInfo = PythonDependencyInfo.create((ReadableConfig)config, (DistributedCache)this.distributedCache);
        Assertions.assertThat((String)dependencyInfo.getPythonExec()).isEqualTo("/usr/bin/python3");
    }
}

