/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.python;

import java.util.List;
import org.apache.flink.client.python.PythonShellParser;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PythonShellParserTest {
    PythonShellParserTest() {
    }

    @Test
    void testParseLocalWithoutOptions() {
        String[] args = new String[]{"local"};
        List commandOptions = PythonShellParser.parseLocal((String[])args);
        String[] expectedCommandOptions = new String[]{"local"};
        Assertions.assertThat((Object[])commandOptions.toArray()).isEqualTo((Object)expectedCommandOptions);
    }

    @Test
    void testParseRemoteWithoutOptions() {
        String[] args = new String[]{"remote", "localhost", "8081"};
        List commandOptions = PythonShellParser.parseRemote((String[])args);
        String[] expectedCommandOptions = new String[]{"remote", "-m", "localhost:8081"};
        Assertions.assertThat((Object[])commandOptions.toArray()).isEqualTo((Object)expectedCommandOptions);
    }

    @Test
    void testParseYarnWithoutOptions() {
        String[] args = new String[]{"yarn"};
        List commandOptions = PythonShellParser.parseYarn((String[])args);
        String[] expectedCommandOptions = new String[]{"yarn", "-m", "yarn-cluster"};
        Assertions.assertThat((Object[])commandOptions.toArray()).isEqualTo((Object)expectedCommandOptions);
    }

    @Test
    void testParseYarnWithOptions() {
        String[] args = new String[]{"yarn", "-jm", "1024m", "-tm", "4096m"};
        List commandOptions = PythonShellParser.parseYarn((String[])args);
        String[] expectedCommandOptions = new String[]{"yarn", "-m", "yarn-cluster", "-yjm", "1024m", "-ytm", "4096m"};
        Assertions.assertThat((Object[])commandOptions.toArray()).isEqualTo((Object)expectedCommandOptions);
    }
}

