/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.python;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.flink.client.python.PythonDriver;
import org.apache.flink.client.python.PythonDriverOptions;
import org.apache.flink.client.python.PythonEnvUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import py4j.GatewayServer;

class PythonDriverTest {
    PythonDriverTest() {
    }

    @Test
    void testStartGatewayServer() throws ExecutionException, InterruptedException {
        GatewayServer gatewayServer = PythonEnvUtils.startGatewayServer();
        try {
            Socket socket = new Socket("localhost", gatewayServer.getListeningPort());
            assert (socket.isConnected());
        }
        catch (IOException e) {
            throw new RuntimeException("Connect Gateway Server failed");
        }
        finally {
            gatewayServer.shutdown();
        }
    }

    @Test
    void testConstructCommandsWithEntryPointModule() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--input");
        args.add("in.txt");
        PythonDriverOptions pythonDriverOptions = new PythonDriverOptions("xxx", null, args);
        List commands = PythonDriver.constructPythonCommands((PythonDriverOptions)pythonDriverOptions);
        Assertions.assertThat((List)commands).containsExactly((Object[])new String[]{"-u", "-m", "xxx", "--input", "in.txt"});
    }

    @Test
    void testConstructCommandsWithEntryPointScript() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--input");
        args.add("in.txt");
        PythonDriverOptions pythonDriverOptions = new PythonDriverOptions(null, "xxx.py", args);
        List commands = PythonDriver.constructPythonCommands((PythonDriverOptions)pythonDriverOptions);
        Assertions.assertThat((List)commands).containsExactly((Object[])new String[]{"-u", "xxx.py", "--input", "in.txt"});
    }
}

