/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.OrcFileFormatFactory;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.utils.StatisticsReportTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.DateTimeUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class OrcFormatStatisticsReportTest
extends StatisticsReportTestBase {
    private static OrcFileFormatFactory.OrcBulkDecodingFormat orcBulkDecodingFormat;

    @BeforeEach
    public void setup(@TempDir File file) throws Exception {
        super.setup(file);
        this.createFileSystemSource();
        Configuration configuration = new Configuration();
        orcBulkDecodingFormat = new OrcFileFormatFactory.OrcBulkDecodingFormat((ReadableConfig)configuration);
    }

    protected String[] properties() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("'format'='orc'");
        ret.add("'orc.compress'='snappy'");
        return ret.toArray(new String[0]);
    }

    @Test
    public void testOrcFormatStatsReportWithSingleFile() throws Exception {
        DataType dataType = this.tEnv.from("sourceTable").getResolvedSchema().toPhysicalRowDataType();
        this.tEnv.fromValues((AbstractDataType)dataType, (Iterable)this.getData()).executeInsert("sourceTable").await();
        Assertions.assertThat((Object[])this.folder.listFiles()).hasSize(1);
        Object[] files = this.folder.listFiles();
        Assertions.assertThat((Object[])files).isNotNull();
        TableStats tableStats = orcBulkDecodingFormat.reportStatistics(Collections.singletonList(new Path(((File)files[0]).toURI().toString())), dataType);
        OrcFormatStatisticsReportTest.assertOrcFormatTableStatsEquals(tableStats, 3, 1L);
    }

    @Test
    public void testOrcFormatStatsReportWithMultiFile() throws Exception {
        DataType dataType = this.tEnv.from("sourceTable").getResolvedSchema().toPhysicalRowDataType();
        this.tEnv.fromValues((AbstractDataType)dataType, (Iterable)this.getData()).executeInsert("sourceTable").await();
        this.tEnv.fromValues((AbstractDataType)dataType, (Iterable)this.getData()).executeInsert("sourceTable").await();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.folder.listFiles()).isNotNull()).hasSize(2);
        File[] files = this.folder.listFiles();
        ArrayList<Path> paths = new ArrayList<Path>();
        assert (files != null);
        paths.add(new Path(files[0].toURI().toString()));
        paths.add(new Path(files[1].toURI().toString()));
        TableStats tableStats = orcBulkDecodingFormat.reportStatistics(paths, dataType);
        OrcFormatStatisticsReportTest.assertOrcFormatTableStatsEquals(tableStats, 6, 2L);
    }

    @Test
    public void testOrcFormatStatsReportWithEmptyFile() {
        TableStats tableStats = orcBulkDecodingFormat.reportStatistics(null, null);
        Assertions.assertThat((Object)tableStats).isEqualTo((Object)TableStats.UNKNOWN);
    }

    protected Map<String, String> ddlTypesMap() {
        Map ddlTypes = super.ddlTypesMap();
        ddlTypes.remove("timestamp with local time zone");
        ddlTypes.remove("binary(1)");
        ddlTypes.remove("varbinary(1)");
        ddlTypes.remove("time");
        return ddlTypes;
    }

    protected Map<String, List<Object>> getDataMap() {
        Map dataMap = super.getDataMap();
        dataMap.remove("timestamp with local time zone");
        dataMap.remove("binary(1)");
        dataMap.remove("varbinary(1)");
        dataMap.remove("time");
        return dataMap;
    }

    protected static void assertOrcFormatTableStatsEquals(TableStats tableStats, int expectedRowCount, long nullCount) {
        HashMap<String, ColumnStats> expectedColumnStatsMap = new HashMap<String, ColumnStats>();
        expectedColumnStatsMap.put("f_boolean", new ColumnStats.Builder().setNullCount(Long.valueOf(nullCount)).build());
        expectedColumnStatsMap.put("f_tinyint", new ColumnStats.Builder().setMax((Comparable)Long.valueOf(3L)).setMin((Comparable)Long.valueOf(1L)).setNullCount(Long.valueOf(0L)).build());
        expectedColumnStatsMap.put("f_smallint", new ColumnStats.Builder().setMax((Comparable)Long.valueOf(128L)).setMin((Comparable)Long.valueOf(100L)).setNullCount(Long.valueOf(0L)).build());
        expectedColumnStatsMap.put("f_int", new ColumnStats.Builder().setMax((Comparable)Long.valueOf(45536L)).setMin((Comparable)Long.valueOf(31000L)).setNullCount(Long.valueOf(nullCount)).build());
        expectedColumnStatsMap.put("f_bigint", new ColumnStats.Builder().setMax((Comparable)Long.valueOf(1238123899121L)).setMin((Comparable)Long.valueOf(1238123899000L)).setNullCount(Long.valueOf(0L)).build());
        expectedColumnStatsMap.put("f_float", new ColumnStats.Builder().setMax((Comparable)Double.valueOf(33.333f)).setMin((Comparable)Double.valueOf(33.311f)).setNullCount(Long.valueOf(nullCount)).build());
        expectedColumnStatsMap.put("f_double", new ColumnStats.Builder().setMax((Comparable)Double.valueOf(10.1)).setMin((Comparable)Double.valueOf(1.1)).setNullCount(Long.valueOf(0L)).build());
        expectedColumnStatsMap.put("f_string", new ColumnStats.Builder().setMax((Comparable)((Object)"def")).setMin((Comparable)((Object)"abcd")).setNullCount(Long.valueOf(0L)).build());
        expectedColumnStatsMap.put("f_decimal5", new ColumnStats.Builder().setMax((Comparable)new BigDecimal("223.45")).setMin((Comparable)new BigDecimal("123.45")).setNullCount(Long.valueOf(0L)).build());
        expectedColumnStatsMap.put("f_decimal14", new ColumnStats.Builder().setMax((Comparable)new BigDecimal("123333333355.33")).setMin((Comparable)new BigDecimal("123333333333.33")).setNullCount(Long.valueOf(0L)).build());
        expectedColumnStatsMap.put("f_decimal38", new ColumnStats.Builder().setMax((Comparable)new BigDecimal("123433343334333433343334333433343334.34")).setMin((Comparable)new BigDecimal("123433343334333433343334333433343334.33")).setNullCount(Long.valueOf(nullCount)).build());
        expectedColumnStatsMap.put("f_date", new ColumnStats.Builder().setMax((Comparable)Date.valueOf("1990-10-16")).setMin((Comparable)Date.valueOf("1990-10-14")).setNullCount(Long.valueOf(0L)).build());
        expectedColumnStatsMap.put("f_timestamp3", new ColumnStats.Builder().setMax((Comparable)DateTimeUtils.parseTimestampData((String)"1990-10-16 12:12:43.123", (int)3).toTimestamp()).setMin((Comparable)DateTimeUtils.parseTimestampData((String)"1990-10-14 12:12:43.123", (int)3).toTimestamp()).setNullCount(Long.valueOf(0L)).build());
        expectedColumnStatsMap.put("f_timestamp9", new ColumnStats.Builder().setMax((Comparable)DateTimeUtils.parseTimestampData((String)"1990-10-16 12:12:43.123", (int)3).toTimestamp()).setMin((Comparable)DateTimeUtils.parseTimestampData((String)"1990-10-14 12:12:43.123", (int)3).toTimestamp()).setNullCount(Long.valueOf(0L)).build());
        expectedColumnStatsMap.put("f_timestamp_wtz", new ColumnStats.Builder().setMax((Comparable)DateTimeUtils.parseTimestampData((String)"1990-10-16 12:12:43.123", (int)3).toTimestamp()).setMin((Comparable)DateTimeUtils.parseTimestampData((String)"1990-10-14 12:12:43.123", (int)3).toTimestamp()).setNullCount(Long.valueOf(0L)).build());
        expectedColumnStatsMap.put("f_row", null);
        expectedColumnStatsMap.put("f_array", null);
        expectedColumnStatsMap.put("f_map", null);
        Assertions.assertThat((Object)tableStats).isEqualTo((Object)new TableStats((long)expectedRowCount, expectedColumnStatsMap));
    }
}

