/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.migration;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.flink.FlinkVersion;
import org.apache.flink.test.migration.SnapshotGeneratorUtils;
import org.apache.flink.test.util.MigrationTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationTestsSnapshotGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationTestsSnapshotGenerator.class);
    private static final String DEFAULT_PATH_PREFIXES = "src/test/java,src/test/scala";
    private static final Option OPTION_HELP = Option.builder().longOpt("help").required(false).hasArg(false).desc("print this help information.").build();
    private static final Option OPTION_DIR = Option.builder().longOpt("dir").required().hasArg().desc("The root directory for scanning. Required.").build();
    private static final Option OPTION_VERSION = Option.builder().longOpt("version").required().hasArg().desc("The version to generate. Required.").build();
    private static final Option OPTION_PREFIXES = Option.builder().longOpt("prefixes").required(false).hasArg().desc("The prefix paths to scan under the root directory, separated by \",\". Default to \"src/test/java,src/test/scala\"").build();
    private static final Option OPTION_CLASSES = Option.builder().longOpt("classes").required(false).hasArg().desc("The specified qualified class name to generate test data, separated by \",\". This option has a higher priority than the prefix option.").build();
    private static final Pattern VERSION_PATTERN = Pattern.compile("v?([0-9]+)[._]([0-9]+)");
    private static final String CLASS_NAME_GROUP = "className";
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("(?<className>[a-zA-Z0-9]*(Test|ITCase))(.java|.scala)");

    public static void main(String[] args) throws Throwable {
        List<Class<?>> migrationTests;
        for (String s : args) {
            if (!s.equals("--" + OPTION_HELP.getLongOpt())) continue;
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.setOptionComparator(null);
            helpFormatter.printHelp("java " + MigrationTestsSnapshotGenerator.class.getName(), MigrationTestsSnapshotGenerator.createOptions());
            return;
        }
        DefaultParser parser = new DefaultParser();
        Options options = MigrationTestsSnapshotGenerator.createOptions();
        CommandLine commandLine = parser.parse(options, args);
        File rootDirectory = new File(commandLine.getOptionValue(OPTION_DIR));
        if (!rootDirectory.exists() || !rootDirectory.isDirectory()) {
            throw new FileNotFoundException(rootDirectory + " does not exist or is not a directory.");
        }
        String versionName = commandLine.getOptionValue(OPTION_VERSION);
        Matcher versionMatcher = VERSION_PATTERN.matcher(versionName);
        if (!versionMatcher.matches()) {
            throw new IllegalArgumentException("Version " + versionName + "could not be parsed, please specify the version with format like 1.17, 1_17, v1_17, v1.17");
        }
        FlinkVersion version = FlinkVersion.valueOf((int)Integer.parseInt(versionMatcher.group(1)), (int)Integer.parseInt(versionMatcher.group(2)));
        LOG.info("Start test data generating for module {} and version {}", (Object)rootDirectory, (Object)version);
        if (commandLine.hasOption(OPTION_CLASSES)) {
            migrationTests = MigrationTestsSnapshotGenerator.loadSpecifiedMigrationTests(commandLine.getOptionValue(OPTION_CLASSES).split(",\\s*"));
        } else {
            String[] prefixes = commandLine.getOptionValue(OPTION_PREFIXES, DEFAULT_PATH_PREFIXES).split(",\\s*");
            migrationTests = MigrationTestsSnapshotGenerator.findMigrationTests(rootDirectory.getAbsolutePath(), prefixes);
        }
        for (Class<?> migrationTestClass : migrationTests) {
            LOG.info("Start test data generating for {}", (Object)migrationTestClass.getName());
            SnapshotGeneratorUtils.executeGenerate(migrationTestClass, version);
            LOG.info("Finish test data generating for {}", (Object)migrationTestClass.getName());
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        options.addOption(OPTION_HELP);
        options.addOption(OPTION_DIR);
        options.addOption(OPTION_VERSION);
        options.addOption(OPTION_PREFIXES);
        options.addOption(OPTION_CLASSES);
        return options;
    }

    private static List<Class<?>> loadSpecifiedMigrationTests(String[] specifiedClassNames) throws Exception {
        ArrayList migrationTestClasses = new ArrayList();
        for (String name : specifiedClassNames) {
            try {
                Class<?> clazz = Class.forName(name);
                if (!MigrationTest.class.isAssignableFrom(clazz)) continue;
                migrationTestClasses.add(clazz);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Class " + name + " does not exist.");
            }
        }
        return migrationTestClasses;
    }

    private static List<Class<?>> findMigrationTests(String rootDirectory, String[] prefixes) throws Exception {
        ArrayList migrationTestClasses = new ArrayList();
        for (String prefix : prefixes) {
            MigrationTestsSnapshotGenerator.recursivelyFindMigrationTests(rootDirectory, prefix, "", migrationTestClasses);
        }
        return migrationTestClasses;
    }

    private static void recursivelyFindMigrationTests(String rootDirectory, String prefix, String packageName, List<Class<?>> result) throws Exception {
        File codeDirectory = new File(rootDirectory + File.separator + prefix);
        if (!codeDirectory.exists()) {
            LOG.debug("{} doesn't exist and will be skipped.", (Object)codeDirectory);
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(codeDirectory.toPath());){
            for (Path entry : stream) {
                File file = entry.toFile();
                if (file.isDirectory()) {
                    MigrationTestsSnapshotGenerator.recursivelyFindMigrationTests(rootDirectory, prefix + File.separator + file.getName(), MigrationTestsSnapshotGenerator.qualifiedName(packageName, file.getName()), result);
                    continue;
                }
                Matcher m = CLASS_NAME_PATTERN.matcher(file.getName());
                if (!m.matches()) continue;
                String className = MigrationTestsSnapshotGenerator.qualifiedName(packageName, m.group(CLASS_NAME_GROUP));
                try {
                    Class<?> clazz = Class.forName(className, false, MigrationTestsSnapshotGenerator.class.getClassLoader());
                    if (!MigrationTest.class.isAssignableFrom(clazz)) continue;
                    result.add(Class.forName(className));
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("The class " + className + " is not found, which might be excluded from the classpath.");
                }
            }
        }
    }

    private static String qualifiedName(String packageName, String simpleName) {
        return packageName.isEmpty() ? simpleName : packageName + "." + simpleName;
    }
}

