/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.local.AbstractRecoverableFsDataOutputStreamTest;
import org.apache.flink.runtime.fs.hdfs.HadoopRecoverableFsDataOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HadoopRecoverableFsDataOutputStreamTest
extends AbstractRecoverableFsDataOutputStreamTest {
    public Tuple2<RecoverableFsDataOutputStream, Closeable> createTestInstance(java.nio.file.Path target, java.nio.file.Path temp, List<AbstractRecoverableFsDataOutputStreamTest.Event> testLog) throws IOException {
        TestFSDataOutputStream fos = new TestFSDataOutputStream(new BufferedOutputStream(Files.newOutputStream(temp, new OpenOption[0])), testLog);
        HadoopRecoverableFsDataOutputStream testOutStreamInstance = new HadoopRecoverableFsDataOutputStream((FileSystem)FileSystem.getLocal((Configuration)new Configuration()), new Path(target.toUri()), new Path(temp.toUri()), (FSDataOutputStream)fos);
        return new Tuple2((Object)testOutStreamInstance, fos::actualClose);
    }

    private static class TestFSDataOutputStream
    extends FSDataOutputStream {
        private final List<AbstractRecoverableFsDataOutputStreamTest.Event> events;

        public TestFSDataOutputStream(OutputStream out, List<AbstractRecoverableFsDataOutputStreamTest.Event> events) throws IOException {
            super(out, new FileSystem.Statistics("test_stats"));
            this.events = events;
        }

        public void hflush() throws IOException {
            super.hflush();
            this.events.add(AbstractRecoverableFsDataOutputStreamTest.Event.FLUSH);
        }

        public void hsync() throws IOException {
            super.hsync();
            this.events.add(AbstractRecoverableFsDataOutputStreamTest.Event.SYNC);
        }

        public void close() {
            this.events.add(AbstractRecoverableFsDataOutputStreamTest.Event.CLOSE);
        }

        public void actualClose() throws IOException {
            super.close();
        }
    }
}

