/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public abstract class KafkaTestEnvironment {
    protected static final String KAFKA_HOST = "localhost";

    public static Config createConfig() {
        return new Config();
    }

    public abstract void prepare(Config var1) throws Exception;

    public void shutdown() throws Exception {
    }

    public abstract void deleteTestTopic(String var1);

    public abstract void createTestTopic(String var1, int var2, int var3, Properties var4);

    public void createTestTopic(String topic, int numberOfPartitions, int replicationFactor) {
        this.createTestTopic(topic, numberOfPartitions, replicationFactor, new Properties());
    }

    public abstract Properties getStandardProperties();

    public abstract Properties getSecureProperties();

    public abstract String getBrokerConnectionString();

    public abstract String getVersion();

    public Properties getIdempotentProducerConfig() {
        Properties props = new Properties();
        props.put("enable.idempotence", "true");
        props.put("acks", "all");
        props.put("retries", "3");
        return props;
    }

    public Properties getTransactionalProducerConfig() {
        Properties props = new Properties();
        props.put("transactional.id", UUID.randomUUID().toString());
        return props;
    }

    public abstract KafkaOffsetHandler createOffsetHandler();

    public abstract void restartBroker(int var1) throws Exception;

    public abstract void stopBroker(int var1) throws Exception;

    public abstract int getLeaderToShutDown(String var1) throws Exception;

    public abstract boolean isSecureRunSupported();

    protected void maybePrintDanglingThreadStacktrace(String threadNameKeyword) {
        for (Map.Entry<Thread, StackTraceElement[]> threadEntry : Thread.getAllStackTraces().entrySet()) {
            if (!threadEntry.getKey().getName().contains(threadNameKeyword)) continue;
            System.out.println("Dangling thread found:");
            for (StackTraceElement ste : threadEntry.getValue()) {
                System.out.println(ste);
            }
        }
    }

    public static class Config {
        private int numKafkaClusters = 1;
        private int kafkaServersNumber = 1;
        private Properties kafkaServerProperties = null;
        private boolean secureMode = false;

        private Config() {
        }

        public int getKafkaServersNumber() {
            return this.kafkaServersNumber;
        }

        public Config setKafkaServersNumber(int kafkaServersNumber) {
            this.kafkaServersNumber = kafkaServersNumber;
            return this;
        }

        public Properties getKafkaServerProperties() {
            return this.kafkaServerProperties;
        }

        public Config setKafkaServerProperties(Properties kafkaServerProperties) {
            this.kafkaServerProperties = kafkaServerProperties;
            return this;
        }

        public boolean isSecureMode() {
            return this.secureMode;
        }

        public Config setSecureMode(boolean secureMode) {
            this.secureMode = secureMode;
            return this;
        }

        public Config setHideKafkaBehindProxy(boolean hideKafkaBehindProxy) {
            return this;
        }
    }

    public static interface KafkaOffsetHandler {
        public Long getCommittedOffset(String var1, int var2);

        public void setCommittedOffset(String var1, int var2, long var3);

        public void close();
    }
}

