/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.testutils;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.connector.kafka.dynamic.metadata.ClusterMetadata;
import org.apache.flink.connector.kafka.dynamic.metadata.KafkaStream;
import org.apache.flink.connector.kafka.testutils.YamlFileMetadataService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class YamlFileMetadataServiceTest {
    @Test
    public void testParseFile() throws IOException {
        YamlFileMetadataService yamlFileMetadataService = new YamlFileMetadataService(Resources.getResource((String)"stream-metadata.yaml").getPath(), Duration.ZERO);
        Set<KafkaStream> kafkaStreams = yamlFileMetadataService.parseFile();
        Properties propertiesForCluster0 = new Properties();
        propertiesForCluster0.setProperty("bootstrap.servers", "bootstrap-server-0:443");
        Properties propertiesForCluster1 = new Properties();
        propertiesForCluster1.setProperty("bootstrap.servers", "bootstrap-server-1:443");
        Properties propertiesForCluster2 = new Properties();
        propertiesForCluster2.setProperty("bootstrap.servers", "bootstrap-server-2:443");
        Assertions.assertThat(kafkaStreams).containsExactlyInAnyOrderElementsOf((Iterable)ImmutableSet.of((Object)new KafkaStream("stream0", (Map)ImmutableMap.of((Object)"cluster0", (Object)new ClusterMetadata((Set)ImmutableSet.of((Object)"topic0", (Object)"topic1"), propertiesForCluster0), (Object)"cluster1", (Object)new ClusterMetadata((Set)ImmutableSet.of((Object)"topic2", (Object)"topic3"), propertiesForCluster1))), (Object)new KafkaStream("stream1", (Map)ImmutableMap.of((Object)"cluster2", (Object)new ClusterMetadata((Set)ImmutableSet.of((Object)"topic4", (Object)"topic5"), propertiesForCluster2)))));
    }
}

