/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.testutils;

import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.connector.kafka.testutils.KafkaSourceExternalContext;
import org.apache.flink.connector.testframe.external.ExternalContextFactory;
import org.testcontainers.containers.KafkaContainer;

public class KafkaSourceExternalContextFactory
implements ExternalContextFactory<KafkaSourceExternalContext> {
    private final KafkaContainer kafkaContainer;
    private final List<URL> connectorJars;
    private final KafkaSourceExternalContext.SplitMappingMode splitMappingMode;

    public KafkaSourceExternalContextFactory(KafkaContainer kafkaContainer, List<URL> connectorJars, KafkaSourceExternalContext.SplitMappingMode splitMappingMode) {
        this.kafkaContainer = kafkaContainer;
        this.connectorJars = connectorJars;
        this.splitMappingMode = splitMappingMode;
    }

    protected String getBootstrapServer() {
        String internalEndpoints = this.kafkaContainer.getNetworkAliases().stream().map(host -> String.join((CharSequence)":", host, Integer.toString(9092))).collect(Collectors.joining(","));
        return String.join((CharSequence)",", this.kafkaContainer.getBootstrapServers(), internalEndpoints);
    }

    public KafkaSourceExternalContext createExternalContext(String testName) {
        return new KafkaSourceExternalContext(this.getBootstrapServer(), this.splitMappingMode, this.connectorJars);
    }
}

