/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.assigners.FileSplitAssigner;
import org.apache.flink.connector.file.src.assigners.SimpleSplitAssigner;
import org.apache.flink.connector.file.src.enumerate.FileEnumerator;
import org.apache.flink.connector.file.src.impl.ContinuousFileSplitEnumerator;
import org.apache.flink.connector.file.src.testutils.TestingFileEnumerator;
import org.apache.flink.connector.testutils.source.reader.TestingSplitEnumeratorContext;
import org.apache.flink.core.fs.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ContinuousFileSplitEnumeratorTest {
    private static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static long splitId = 1L;

    ContinuousFileSplitEnumeratorTest() {
    }

    @Test
    void testDiscoverSplitWhenNoReaderRegistered() throws Exception {
        TestingFileEnumerator fileEnumerator = new TestingFileEnumerator(new FileSourceSplit[0]);
        TestingSplitEnumeratorContext context = new TestingSplitEnumeratorContext(4);
        ContinuousFileSplitEnumerator enumerator = ContinuousFileSplitEnumeratorTest.createEnumerator(fileEnumerator, (SplitEnumeratorContext<FileSourceSplit>)context);
        FileSourceSplit split = ContinuousFileSplitEnumeratorTest.createRandomSplit();
        fileEnumerator.addSplits(split);
        context.triggerAllActions();
        Assertions.assertThat((Collection)enumerator.snapshotState(1L).getSplits()).contains((Object[])new FileSourceSplit[]{split});
    }

    @Test
    void testDiscoverWhenReaderRegistered() throws Exception {
        TestingFileEnumerator fileEnumerator = new TestingFileEnumerator(new FileSourceSplit[0]);
        TestingSplitEnumeratorContext context = new TestingSplitEnumeratorContext(4);
        ContinuousFileSplitEnumerator enumerator = ContinuousFileSplitEnumeratorTest.createEnumerator(fileEnumerator, (SplitEnumeratorContext<FileSourceSplit>)context);
        context.registerReader(2, "localhost");
        enumerator.addReader(2);
        enumerator.handleSplitRequest(2, "localhost");
        FileSourceSplit split = ContinuousFileSplitEnumeratorTest.createRandomSplit();
        fileEnumerator.addSplits(split);
        context.triggerAllActions();
        Assertions.assertThat((Collection)enumerator.snapshotState(1L).getSplits()).isEmpty();
        Assertions.assertThat((List)((TestingSplitEnumeratorContext.SplitAssignmentState)context.getSplitAssignments().get(2)).getAssignedSplits()).contains((Object[])new FileSourceSplit[]{split});
    }

    @Test
    void testRequestingReaderUnavailableWhenSplitDiscovered() throws Exception {
        TestingFileEnumerator fileEnumerator = new TestingFileEnumerator(new FileSourceSplit[0]);
        TestingSplitEnumeratorContext context = new TestingSplitEnumeratorContext(4);
        ContinuousFileSplitEnumerator enumerator = ContinuousFileSplitEnumeratorTest.createEnumerator(fileEnumerator, (SplitEnumeratorContext<FileSourceSplit>)context);
        context.registerReader(2, "localhost");
        enumerator.addReader(2);
        enumerator.handleSplitRequest(2, "localhost");
        context.registeredReaders().remove(2);
        FileSourceSplit split = ContinuousFileSplitEnumeratorTest.createRandomSplit();
        fileEnumerator.addSplits(split);
        context.triggerAllActions();
        Assertions.assertThat((Map)context.getSplitAssignments()).doesNotContainKey((Object)2);
        Assertions.assertThat((Collection)enumerator.snapshotState(1L).getSplits()).contains((Object[])new FileSourceSplit[]{split});
    }

    private static FileSourceSplit createRandomSplit() {
        return new FileSourceSplit(String.valueOf(splitId++), Path.fromLocalFile((File)new File(TMP_DIR, "foo")), 0L, 0L, 0L, 0L);
    }

    private static ContinuousFileSplitEnumerator createEnumerator(FileEnumerator fileEnumerator, SplitEnumeratorContext<FileSourceSplit> context) {
        ContinuousFileSplitEnumerator enumerator = new ContinuousFileSplitEnumerator(context, fileEnumerator, (FileSplitAssigner)new SimpleSplitAssigner(Collections.emptyList()), new Path[]{Path.fromLocalFile((File)TMP_DIR)}, Collections.emptySet(), 10L);
        enumerator.start();
        return enumerator;
    }
}

