/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.utils;

import java.io.IOException;
import org.apache.flink.streaming.api.functions.sink.filesystem.PartFileInfo;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;

public class PartSizeAndCheckpointRollingPolicy<IN, BucketID>
implements RollingPolicy<IN, BucketID> {
    private final long maxPartSize;
    private final boolean rollingOnCheckpoint;

    public PartSizeAndCheckpointRollingPolicy(long maxPartSize, boolean rollingOnCheckpoint) {
        this.maxPartSize = maxPartSize;
        this.rollingOnCheckpoint = rollingOnCheckpoint;
    }

    public boolean shouldRollOnCheckpoint(PartFileInfo<BucketID> partFileState) {
        return this.rollingOnCheckpoint;
    }

    public boolean shouldRollOnEvent(PartFileInfo<BucketID> partFileState, IN element) throws IOException {
        return partFileState.getSize() >= this.maxPartSize;
    }

    public boolean shouldRollOnProcessingTime(PartFileInfo<BucketID> partFileState, long currentTime) {
        return false;
    }
}

