/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.deployment.ClusterClientFactory;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.deployment.StandaloneClusterDescriptor;
import org.apache.flink.client.deployment.StandaloneClusterId;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.runtime.util.datafabric.DefaultTLSConfigurer;
import org.apache.flink.util.Preconditions;

@Internal
public class StandaloneClientFactory
implements ClusterClientFactory<StandaloneClusterId> {
    @Override
    public boolean isCompatibleWith(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return "remote".equalsIgnoreCase((String)configuration.get(DeploymentOptions.TARGET));
    }

    public StandaloneClusterDescriptor createClusterDescriptor(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        DefaultTLSConfigurer.apply((Configuration)configuration);
        return new StandaloneClusterDescriptor(configuration);
    }

    @Override
    @Nullable
    public StandaloneClusterId getClusterId(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return StandaloneClusterId.getInstance();
    }

    @Override
    public ClusterSpecification getClusterSpecification(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return new ClusterSpecification.ClusterSpecificationBuilder().createClusterSpecification();
    }
}

