/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class ClientOptions {
    public static final ConfigOption<Duration> CLIENT_TIMEOUT = ConfigOptions.key((String)"client.timeout").durationType().defaultValue((Object)Duration.ofSeconds(60L)).withDeprecatedKeys(new String[]{"akka.client.timeout"}).withDescription("Timeout on the client side.");
    public static final ConfigOption<Duration> CLIENT_RETRY_PERIOD = ConfigOptions.key((String)"client.retry-period").durationType().defaultValue((Object)Duration.ofMillis(2000L)).withDescription("The interval (in ms) between consecutive retries of failed attempts to execute commands through the CLI or Flink's clients, wherever retry is supported (default 2sec).");
    public static final ConfigOption<Duration> CLIENT_HEARTBEAT_TIMEOUT = ConfigOptions.key((String)"client.heartbeat.timeout").durationType().defaultValue((Object)Duration.ofMillis(180000L)).withDescription(Description.builder().text("Cancel the job if the dispatcher hasn't received the client's heartbeat after timeout when '%s' and '%s' are both true.", new InlineElement[]{TextElement.text((String)DeploymentOptions.ATTACHED.key()), TextElement.text((String)DeploymentOptions.SHUTDOWN_IF_ATTACHED.key())}).build());
    public static final ConfigOption<Duration> CLIENT_HEARTBEAT_INTERVAL = ConfigOptions.key((String)"client.heartbeat.interval").durationType().defaultValue((Object)Duration.ofMillis(30000L)).withDescription(Description.builder().text("Time interval for job client to report its heartbeat when '%s' and '%s' are both true. Cancel the job if timeout configured by '%s'.", new InlineElement[]{TextElement.text((String)DeploymentOptions.ATTACHED.key()), TextElement.text((String)DeploymentOptions.SHUTDOWN_IF_ATTACHED.key()), TextElement.text((String)CLIENT_HEARTBEAT_TIMEOUT.key())}).build());
}

