/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.utils;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.state.v2.AggregatingState;
import org.apache.flink.api.common.state.v2.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.v2.ListState;
import org.apache.flink.api.common.state.v2.ListStateDescriptor;
import org.apache.flink.api.common.state.v2.MapStateDescriptor;
import org.apache.flink.api.common.state.v2.ReducingState;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.cep.configuration.SharedBufferCacheConfig;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBuffer;

public class TestSharedBuffer<V>
extends SharedBuffer<V> {
    private final MockKeyedStateStore keyedStateStore;

    private TestSharedBuffer(MockKeyedStateStore stateStore, TypeSerializer<V> valueSerializer) {
        super((KeyedStateStore)stateStore, valueSerializer);
        this.keyedStateStore = stateStore;
    }

    private TestSharedBuffer(MockKeyedStateStore stateStore, TypeSerializer<V> valueSerializer, SharedBufferCacheConfig sharedBufferCacheConfig) {
        super((KeyedStateStore)stateStore, valueSerializer, sharedBufferCacheConfig);
        this.keyedStateStore = stateStore;
    }

    public long getStateWrites() {
        return this.keyedStateStore.stateWrites;
    }

    public long getStateReads() {
        return this.keyedStateStore.stateReads;
    }

    public long getStateAccesses() {
        return this.getStateWrites() + this.getStateReads();
    }

    public static <T> TestSharedBuffer<T> createTestBuffer(TypeSerializer<T> typeSerializer) {
        return new TestSharedBuffer<T>(new MockKeyedStateStore(), typeSerializer);
    }

    public static <T> TestSharedBuffer<T> createTestBuffer(TypeSerializer<T> typeSerializer, SharedBufferCacheConfig sharedBufferCacheConfig) {
        return new TestSharedBuffer<T>(new MockKeyedStateStore(), typeSerializer, sharedBufferCacheConfig);
    }

    private static class MockKeyedStateStore
    implements KeyedStateStore {
        private long stateWrites = 0L;
        private long stateReads = 0L;

        private MockKeyedStateStore() {
        }

        public <T> ValueState<T> getState(ValueStateDescriptor<T> stateProperties) {
            return new ValueState<T>(){
                private T value;

                public T value() throws IOException {
                    ++stateReads;
                    return this.value;
                }

                public void update(T value) throws IOException {
                    ++stateWrites;
                    this.value = value;
                }

                public void clear() {
                    this.value = null;
                }
            };
        }

        public <T> org.apache.flink.api.common.state.ListState<T> getListState(org.apache.flink.api.common.state.ListStateDescriptor<T> stateProperties) {
            throw new UnsupportedOperationException();
        }

        public <T> org.apache.flink.api.common.state.ReducingState<T> getReducingState(ReducingStateDescriptor<T> stateProperties) {
            throw new UnsupportedOperationException();
        }

        public <IN, ACC, OUT> org.apache.flink.api.common.state.AggregatingState<IN, OUT> getAggregatingState(org.apache.flink.api.common.state.AggregatingStateDescriptor<IN, ACC, OUT> stateProperties) {
            throw new UnsupportedOperationException();
        }

        public <UK, UV> MapState<UK, UV> getMapState(org.apache.flink.api.common.state.MapStateDescriptor<UK, UV> stateProperties) {
            return new MapState<UK, UV>(){
                private Map<UK, UV> values;

                private Map<UK, UV> getOrSetMap() {
                    if (this.values == null) {
                        this.values = new HashMap();
                    }
                    return this.values;
                }

                public UV get(UK key) throws Exception {
                    ++stateReads;
                    if (this.values == null) {
                        return null;
                    }
                    return this.values.get(key);
                }

                public void put(UK key, UV value) throws Exception {
                    ++stateWrites;
                    this.getOrSetMap().put(key, value);
                }

                public void putAll(Map<UK, UV> map) throws Exception {
                    ++stateWrites;
                    this.getOrSetMap().putAll(map);
                }

                public void remove(UK key) throws Exception {
                    if (this.values == null) {
                        return;
                    }
                    ++stateWrites;
                    this.values.remove(key);
                }

                public boolean contains(UK key) throws Exception {
                    if (this.values == null) {
                        return false;
                    }
                    ++stateReads;
                    return this.values.containsKey(key);
                }

                public Iterable<Map.Entry<UK, UV>> entries() throws Exception {
                    if (this.values == null) {
                        return Collections.emptyList();
                    }
                    return () -> new CountingIterator(this.values.entrySet().iterator());
                }

                public Iterable<UK> keys() throws Exception {
                    if (this.values == null) {
                        return Collections.emptyList();
                    }
                    return () -> new CountingIterator(this.values.keySet().iterator());
                }

                public Iterable<UV> values() throws Exception {
                    if (this.values == null) {
                        return Collections.emptyList();
                    }
                    return () -> new CountingIterator(this.values.values().iterator());
                }

                public Iterator<Map.Entry<UK, UV>> iterator() throws Exception {
                    if (this.values == null) {
                        return Collections.emptyIterator();
                    }
                    return new CountingIterator(this.values.entrySet().iterator());
                }

                public boolean isEmpty() throws Exception {
                    if (this.values == null) {
                        return true;
                    }
                    return this.values.isEmpty();
                }

                public void clear() {
                    ++stateWrites;
                    this.values = null;
                }
            };
        }

        public <T> org.apache.flink.api.common.state.v2.ValueState<T> getValueState(@Nonnull org.apache.flink.api.common.state.v2.ValueStateDescriptor<T> stateProperties) {
            throw new UnsupportedOperationException();
        }

        public <T> ListState<T> getListState(@Nonnull ListStateDescriptor<T> stateProperties) {
            throw new UnsupportedOperationException();
        }

        public <UK, UV> org.apache.flink.api.common.state.v2.MapState<UK, UV> getMapState(@Nonnull MapStateDescriptor<UK, UV> stateProperties) {
            throw new UnsupportedOperationException();
        }

        public <T> ReducingState<T> getReducingState(@Nonnull org.apache.flink.api.common.state.v2.ReducingStateDescriptor<T> stateProperties) {
            throw new UnsupportedOperationException();
        }

        public <IN, ACC, OUT> AggregatingState<IN, OUT> getAggregatingState(@Nonnull AggregatingStateDescriptor<IN, ACC, OUT> stateProperties) {
            throw new UnsupportedOperationException();
        }

        private class CountingIterator<T>
        implements Iterator<T> {
            private final Iterator<T> iterator;

            CountingIterator(Iterator<T> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                ++MockKeyedStateStore.this.stateReads;
                return this.iterator.next();
            }

            @Override
            public void remove() {
                ++MockKeyedStateStore.this.stateWrites;
                this.iterator.remove();
            }
        }
    }
}

