/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.cep.Event;
import org.apache.flink.cep.nfa.ComputationState;
import org.apache.flink.cep.nfa.NFA;
import org.apache.flink.cep.nfa.NFAState;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.cep.pattern.conditions.SimpleCondition;
import org.apache.flink.cep.utils.NFATestHarness;
import org.apache.flink.cep.utils.NFATestUtilities;
import org.apache.flink.cep.utils.NFAUtils;
import org.apache.flink.shaded.guava32.com.google.common.collect.Lists;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.junit.Assert;
import org.junit.Test;

public class UntilConditionITCase {
    public static final SimpleCondition<Event> UNTIL_CONDITION = SimpleCondition.of((FilterFunction & Serializable)value -> value.getPrice() == 5.0);

    @Test
    public void testUntilConditionFollowedByOneOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event breaking = new Event(44, "a", 5.0);
        Event ignored = new Event(45, "a", 6.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)breaking, 6L));
        inputEvents.add(new StreamRecord((Object)ignored, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().until(UNTIL_CONDITION).followedBy("end").where(UNTIL_CONDITION);
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, breaking}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, breaking})}));
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"start", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testUntilConditionFollowedByOneOrMoreCombinations() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        Event breaking = new Event(44, "a", 5.0);
        Event ignored = new Event(45, "a", 6.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)breaking, 6L));
        inputEvents.add(new StreamRecord((Object)ignored, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().allowCombinations().until(UNTIL_CONDITION).followedBy("end").where(UNTIL_CONDITION);
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, breaking}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, breaking}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent3, breaking}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, breaking})}));
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"start", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testUntilConditionFollowedByOneOrMoreConsecutive() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event breaking = new Event(45, "a", 5.0);
        Event ignored = new Event(46, "a", 6.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)breaking, 7L));
        inputEvents.add(new StreamRecord((Object)ignored, 8L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().consecutive().until(UNTIL_CONDITION).followedBy("end").where(UNTIL_CONDITION);
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, breaking}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, breaking})}));
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"start", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testUntilConditionFollowedByOneOrMoreConsecutive2() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "b", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        Event breaking = new Event(45, "a", 5.0);
        Event ignored = new Event(46, "a", 6.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)breaking, 7L));
        inputEvents.add(new StreamRecord((Object)ignored, 8L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().consecutive().until(UNTIL_CONDITION).followedBy("end").where(UNTIL_CONDITION);
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, breaking})}));
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"start", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testUntilConditionFollowedByZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event breaking = new Event(44, "a", 5.0);
        Event ignored = new Event(45, "a", 6.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)breaking, 6L));
        inputEvents.add(new StreamRecord((Object)ignored, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().until(UNTIL_CONDITION).followedBy("end").where(UNTIL_CONDITION);
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, breaking}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, breaking}), Lists.newArrayList((Object[])new Event[]{startEvent, breaking})}));
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"start", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testUntilConditionFollowedByZeroOrMoreCombinations() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(43, "a", 4.0);
        Event breaking = new Event(44, "a", 5.0);
        Event ignored = new Event(45, "a", 6.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)breaking, 6L));
        inputEvents.add(new StreamRecord((Object)ignored, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().allowCombinations().until(UNTIL_CONDITION).followedBy("end").where(UNTIL_CONDITION);
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3, breaking}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, breaking}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent3, breaking}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, breaking}), Lists.newArrayList((Object[])new Event[]{startEvent, breaking})}));
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"start", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testUntilConditionFollowedByZeroOrMoreConsecutive() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event breaking = new Event(45, "a", 5.0);
        Event ignored = new Event(46, "a", 6.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)breaking, 7L));
        inputEvents.add(new StreamRecord((Object)ignored, 8L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().consecutive().until(UNTIL_CONDITION).followedBy("end").where(UNTIL_CONDITION);
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, breaking}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, breaking}), Lists.newArrayList((Object[])new Event[]{startEvent, breaking})}));
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"start", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testUntilConditionFollowedByAnyOneOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event breaking = new Event(44, "a", 5.0);
        Event middleEvent3 = new Event(45, "a", 6.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)breaking, 6L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().until(UNTIL_CONDITION);
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent3})}));
    }

    @Test
    public void testUntilConditionFollowedByAnyZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event breaking = new Event(44, "a", 5.0);
        Event middleEvent3 = new Event(45, "a", 6.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)breaking, 6L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedByAny("middle").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("a"))).oneOrMore().optional().until(UNTIL_CONDITION);
        NFA nfa = NFAUtils.compile(pattern, false);
        List<List<Event>> resultingPatterns = NFATestUtilities.feedNFA(inputEvents, nfa);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent2}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent3}), Lists.newArrayList((Object[])new Event[]{startEvent})}));
    }

    @Test
    public void testUntilConditionWithEmptyWhere() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(40, "d", 1.0);
        Event breaking = new Event(44, "a", 5.0);
        Event ignored = new Event(45, "a", 6.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)breaking, 6L));
        inputEvents.add(new StreamRecord((Object)ignored, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").oneOrMore().until(UNTIL_CONDITION);
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1})}));
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"start", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testIterativeUntilConditionOneOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(40, "d", 1.0);
        Event breaking = new Event(44, "a", 5.0);
        Event ignored = new Event(45, "a", 6.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)breaking, 6L));
        inputEvents.add(new StreamRecord((Object)ignored, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").oneOrMore().until((IterativeCondition)new IterativeCondition<Event>(){

            public boolean filter(Event value, IterativeCondition.Context<Event> ctx) throws Exception {
                double sum = 0.0;
                for (Event middle : ctx.getEventsForPattern("middle")) {
                    sum += middle.getPrice();
                }
                return sum == 6.0;
            }
        });
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1})}));
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"start", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }

    @Test
    public void testIterativeUntilConditionZeroOrMore() throws Exception {
        ArrayList<StreamRecord<Event>> inputEvents = new ArrayList<StreamRecord<Event>>();
        Event startEvent = new Event(40, "c", 1.0);
        Event middleEvent1 = new Event(41, "a", 2.0);
        Event middleEvent2 = new Event(42, "a", 3.0);
        Event middleEvent3 = new Event(40, "d", 1.0);
        Event breaking = new Event(44, "a", 5.0);
        Event ignored = new Event(45, "a", 6.0);
        inputEvents.add(new StreamRecord((Object)startEvent, 1L));
        inputEvents.add(new StreamRecord((Object)middleEvent1, 3L));
        inputEvents.add(new StreamRecord((Object)middleEvent2, 4L));
        inputEvents.add(new StreamRecord((Object)middleEvent3, 5L));
        inputEvents.add(new StreamRecord((Object)breaking, 6L));
        inputEvents.add(new StreamRecord((Object)ignored, 7L));
        Pattern pattern = Pattern.begin((String)"start").where((IterativeCondition)SimpleCondition.of((FilterFunction & Serializable)value -> value.getName().equals("c"))).followedBy("middle").oneOrMore().optional().until((IterativeCondition)new IterativeCondition<Event>(){

            public boolean filter(Event value, IterativeCondition.Context<Event> ctx) throws Exception {
                double sum = 0.0;
                for (Event middle : ctx.getEventsForPattern("middle")) {
                    sum += middle.getPrice();
                }
                return sum == 6.0;
            }
        });
        NFA nfa = NFAUtils.compile(pattern, false);
        NFAState nfaState = nfa.createInitialNFAState();
        NFATestHarness nfaTestHarness = NFATestHarness.forNFA(nfa).withNFAState(nfaState).build();
        List<List<Event>> resultingPatterns = nfaTestHarness.feedRecords(inputEvents);
        NFATestUtilities.comparePatterns(resultingPatterns, Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2, middleEvent3}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1, middleEvent2}), Lists.newArrayList((Object[])new Event[]{startEvent, middleEvent1}), Lists.newArrayList((Object[])new Event[]{startEvent})}));
        Assert.assertEquals((long)1L, (long)nfaState.getPartialMatches().size());
        Assert.assertEquals((Object)"start", (Object)((ComputationState)nfaState.getPartialMatches().peek()).getCurrentStateName());
    }
}

