/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.formats.avro.generated.Address;
import org.apache.flink.formats.avro.typeutils.AvroSerializer;
import org.assertj.core.api.Condition;

class AvroSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Object, Object> {
    AvroSerializerUpgradeTest() {
    }

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("generic-avro-serializer", flinkVersion, GenericAvroSerializerSetup.class, GenericAvroSerializerVerifier.class));
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("specific-avro-serializer", flinkVersion, SpecificAvroSerializerSetup.class, SpecificAvroSerializerVerifier.class));
        return testSpecifications;
    }

    public static final class GenericAvroSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<GenericRecord> {
        public TypeSerializer<GenericRecord> createPriorSerializer() {
            return new AvroSerializer(GenericRecord.class, Address.getClassSchema());
        }

        public GenericRecord createTestData() {
            GenericData.Record record = new GenericData.Record(Address.getClassSchema());
            record.put("num", (Object)239);
            record.put("street", (Object)"Baker Street");
            record.put("city", (Object)"London");
            record.put("state", (Object)"London");
            record.put("zip", (Object)"NW1 6XE");
            return record;
        }
    }

    public static final class GenericAvroSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<GenericRecord> {
        public TypeSerializer<GenericRecord> createUpgradedSerializer() {
            return new AvroSerializer(GenericRecord.class, Address.getClassSchema());
        }

        public Condition<GenericRecord> testDataCondition() {
            GenericData.Record record = new GenericData.Record(Address.getClassSchema());
            record.put("num", (Object)239);
            record.put("street", (Object)"Baker Street");
            record.put("city", (Object)"London");
            record.put("state", (Object)"London");
            record.put("zip", (Object)"NW1 6XE");
            return new Condition(arg_0 -> ((GenericData.Record)record).equals(arg_0), "record is " + record, new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<GenericRecord>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class SpecificAvroSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Address> {
        public TypeSerializer<Address> createPriorSerializer() {
            AvroSerializer avroSerializer = new AvroSerializer(Address.class);
            return avroSerializer;
        }

        public Address createTestData() {
            Address addr = new Address();
            addr.setNum(239);
            addr.setStreet("Baker Street");
            addr.setCity("London");
            addr.setState("London");
            addr.setZip("NW1 6XE");
            return addr;
        }
    }

    public static final class SpecificAvroSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Address> {
        public TypeSerializer<Address> createUpgradedSerializer() {
            AvroSerializer avroSerializer = new AvroSerializer(Address.class);
            return avroSerializer;
        }

        public Condition<Address> testDataCondition() {
            Address addr = new Address();
            addr.setNum(239);
            addr.setStreet("Baker Street");
            addr.setCity("London");
            addr.setState("London");
            addr.setZip("NW1 6XE");
            return new Condition(arg_0 -> ((Address)addr).equals(arg_0), "address is " + addr, new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<Address>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }
}

