/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.time.Instant;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.formats.avro.AvroFormatOptions;
import org.apache.flink.formats.avro.AvroSerializationSchema;
import org.apache.flink.formats.avro.generated.Address;
import org.apache.flink.formats.avro.generated.UnionLogicalType;
import org.apache.flink.formats.avro.utils.AvroTestUtils;
import org.apache.flink.formats.avro.utils.TestDataGenerator;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class AvroSerializationSchemaTest {
    private static final Address address = TestDataGenerator.generateRandomAddress(new Random());

    AvroSerializationSchemaTest() {
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testGenericRecord(AvroFormatOptions.AvroEncoding encoding) throws Exception {
        AvroSerializationSchema serializationSchema = AvroSerializationSchema.forGeneric((Schema)address.getSchema(), (AvroFormatOptions.AvroEncoding)encoding);
        byte[] encodedAddress = AvroTestUtils.writeRecord((GenericRecord)address, Address.getClassSchema(), encoding);
        byte[] dataSerialized = serializationSchema.serialize((Object)address);
        Assertions.assertThat((byte[])dataSerialized).isEqualTo((Object)encodedAddress);
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testSpecificRecord(AvroFormatOptions.AvroEncoding encoding) throws Exception {
        AvroSerializationSchema serializer = AvroSerializationSchema.forSpecific(Address.class, (AvroFormatOptions.AvroEncoding)encoding);
        byte[] encodedAddress = AvroTestUtils.writeRecord((GenericRecord)address, Address.getClassSchema(), encoding);
        byte[] serializedAddress = serializer.serialize((Object)address);
        Assertions.assertThat((byte[])serializedAddress).isEqualTo((Object)encodedAddress);
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testSpecificRecordWithUnionLogicalType(AvroFormatOptions.AvroEncoding encoding) throws Exception {
        Random rnd = new Random();
        UnionLogicalType data = new UnionLogicalType(Instant.ofEpochMilli(rnd.nextLong()));
        AvroSerializationSchema serializer = AvroSerializationSchema.forSpecific(UnionLogicalType.class, (AvroFormatOptions.AvroEncoding)encoding);
        byte[] encodedData = AvroTestUtils.writeRecord(data, encoding);
        byte[] serializedData = serializer.serialize((Object)data);
        Assertions.assertThat((byte[])serializedData).isEqualTo((Object)encodedData);
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testSerializability(AvroFormatOptions.AvroEncoding encoding) throws Exception {
        AvroSerializationSchema ser = AvroSerializationSchema.forGeneric((Schema)AvroTestUtils.getSmallSchema(), (AvroFormatOptions.AvroEncoding)encoding);
        byte[] serBytes = InstantiationUtil.serializeObject((Object)ser);
        AvroSerializationSchema serCopy = (AvroSerializationSchema)InstantiationUtil.deserializeObject((byte[])serBytes, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Object)serCopy.getSchema()).isNull();
        serCopy.open(null);
        Assertions.assertThat((Object)serCopy.getSchema()).isNotNull();
        Assertions.assertThat((Object)serCopy.getSchema()).isEqualTo((Object)AvroTestUtils.getSmallSchema());
    }
}

