/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.formats.avro.AvroDeserializationSchema;
import org.apache.flink.formats.avro.AvroFormatOptions;
import org.apache.flink.formats.avro.AvroRowDataDeserializationSchema;
import org.apache.flink.formats.avro.AvroRowDataSerializationSchema;
import org.apache.flink.formats.avro.AvroSerializationSchema;
import org.apache.flink.formats.avro.AvroToRowDataConverters;
import org.apache.flink.formats.avro.RowDataToAvroConverters;
import org.apache.flink.formats.avro.generated.LogicalTimeRecord;
import org.apache.flink.formats.avro.generated.Timestamps;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.formats.avro.utils.AvroTestUtils;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.Row;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class AvroRowDataDeSerializationSchemaTest {
    AvroRowDataDeSerializationSchemaTest() {
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testDeserializeNullRow(AvroFormatOptions.AvroEncoding encoding) throws Exception {
        DataType dataType = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"bool", (DataType)DataTypes.BOOLEAN())}).nullable();
        AvroRowDataDeserializationSchema deserializationSchema = this.createDeserializationSchema(dataType, encoding, true);
        Assertions.assertThat((Object)deserializationSchema.deserialize(null)).isNull();
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testSerializeDeserialize(AvroFormatOptions.AvroEncoding encoding) throws Exception {
        DataType dataType = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"bool", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"tinyint", (DataType)DataTypes.TINYINT()), DataTypes.FIELD((String)"smallint", (DataType)DataTypes.SMALLINT()), DataTypes.FIELD((String)"int", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"bigint", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"float", (DataType)DataTypes.FLOAT()), DataTypes.FIELD((String)"double", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"bytes", (DataType)DataTypes.BYTES()), DataTypes.FIELD((String)"decimal", (DataType)DataTypes.DECIMAL((int)19, (int)6)), DataTypes.FIELD((String)"doubles", (DataType)DataTypes.ARRAY((DataType)DataTypes.DOUBLE())), DataTypes.FIELD((String)"time", (DataType)DataTypes.TIME((int)0)), DataTypes.FIELD((String)"date", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"timestamp3", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"timestamp3_2", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"map", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.BIGINT())), DataTypes.FIELD((String)"map2map", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()))), DataTypes.FIELD((String)"map2array", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.ARRAY((DataType)DataTypes.INT()))), DataTypes.FIELD((String)"nullEntryMap", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.STRING()))}).notNull();
        RowType rowType = (RowType)dataType.getLogicalType();
        Schema schema = AvroSchemaConverter.convertToSchema((LogicalType)rowType);
        GenericData.Record record = new GenericData.Record(schema);
        record.put(0, (Object)true);
        record.put(1, (Object)127);
        record.put(2, (Object)Short.MAX_VALUE);
        record.put(3, (Object)33);
        record.put(4, (Object)44L);
        record.put(5, (Object)Float.valueOf(12.34f));
        record.put(6, (Object)23.45);
        record.put(7, (Object)"hello avro");
        record.put(8, (Object)ByteBuffer.wrap(new byte[]{1, 2, 4, 5, 6, 7, 8, 12}));
        record.put(9, (Object)ByteBuffer.wrap(BigDecimal.valueOf(123456789L, 6).unscaledValue().toByteArray()));
        ArrayList<Double> doubles = new ArrayList<Double>();
        doubles.add(1.2);
        doubles.add(3.4);
        doubles.add(567.8901);
        record.put(10, doubles);
        record.put(11, (Object)18397);
        record.put(12, (Object)10087);
        record.put(13, (Object)1589530213123L);
        record.put(14, (Object)1589530213122L);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("flink", 12L);
        map.put("avro", 23L);
        record.put(15, map);
        HashMap map2map = new HashMap();
        HashMap<String, Integer> innerMap = new HashMap<String, Integer>();
        innerMap.put("inner_key1", 123);
        innerMap.put("inner_key2", 234);
        map2map.put("outer_key", innerMap);
        record.put(16, map2map);
        List<Integer> list1 = Arrays.asList(1, 2, 3, 4, 5, 6);
        List<Integer> list2 = Arrays.asList(11, 22, 33, 44, 55);
        HashMap<String, List<Integer>> map2list = new HashMap<String, List<Integer>>();
        map2list.put("list1", list1);
        map2list.put("list2", list2);
        record.put(17, map2list);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("key1", null);
        record.put(18, map2);
        AvroRowDataSerializationSchema serializationSchema = this.createSerializationSchema(dataType, encoding, true);
        AvroRowDataDeserializationSchema deserializationSchema = this.createDeserializationSchema(dataType, encoding, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        Encoder encoder = AvroTestUtils.createEncoder(encoding, schema, byteArrayOutputStream);
        datumWriter.write((Object)record, encoder);
        encoder.flush();
        byte[] input = byteArrayOutputStream.toByteArray();
        RowData rowData = deserializationSchema.deserialize(input);
        byte[] output = serializationSchema.serialize(rowData);
        Assertions.assertThat((byte[])output).isEqualTo((Object)input);
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testSerializeDeserializeBasedOnNestedSchema(AvroFormatOptions.AvroEncoding encoding) throws Exception {
        Schema innerSchema = AvroTestUtils.getSmallSchema();
        DataType dataType = AvroSchemaConverter.convertToDataType((String)innerSchema.toString());
        SchemaBuilder.FieldAssembler outerSchemaBuilder = SchemaBuilder.builder().record("outerSchemaName").fields();
        outerSchemaBuilder.name("before").type(Schema.createUnion((Schema[])new Schema[]{(Schema)SchemaBuilder.builder().nullType(), innerSchema})).withDefault(null);
        outerSchemaBuilder.name("after").type(Schema.createUnion((Schema[])new Schema[]{(Schema)SchemaBuilder.builder().nullType(), innerSchema})).withDefault(null);
        outerSchemaBuilder.name("op").type(Schema.createUnion((Schema[])new Schema[]{(Schema)SchemaBuilder.builder().nullType(), (Schema)SchemaBuilder.builder().stringType()})).withDefault(null);
        Schema outerSchema = (Schema)outerSchemaBuilder.endRecord();
        Schema nullableOuterSchema = Schema.createUnion((Schema[])new Schema[]{(Schema)SchemaBuilder.builder().nullType(), outerSchema});
        GenericData.Record innerRecord = new GenericData.Record(innerSchema);
        innerRecord.put(0, (Object)"test");
        GenericData.Record outerRecord = new GenericData.Record(outerSchema);
        outerRecord.put(0, null);
        outerRecord.put(1, (Object)innerRecord);
        outerRecord.put(2, (Object)"c");
        RowType rowType = (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"before", (DataType)((DataType)dataType.nullable())), DataTypes.FIELD((String)"after", (DataType)((DataType)dataType.nullable())), DataTypes.FIELD((String)"op", (DataType)DataTypes.STRING())}).getLogicalType();
        AvroRowDataSerializationSchema serializationSchema = new AvroRowDataSerializationSchema(rowType, (SerializationSchema)AvroSerializationSchema.forGeneric((Schema)nullableOuterSchema, (AvroFormatOptions.AvroEncoding)encoding), RowDataToAvroConverters.createConverter((LogicalType)rowType));
        AvroRowDataDeserializationSchema deserializationSchema = new AvroRowDataDeserializationSchema((DeserializationSchema)AvroDeserializationSchema.forGeneric((Schema)nullableOuterSchema, (AvroFormatOptions.AvroEncoding)encoding), AvroToRowDataConverters.createRowConverter((RowType)rowType), (TypeInformation)InternalTypeInfo.of((RowType)rowType));
        byte[] serBytes = InstantiationUtil.serializeObject((Object)serializationSchema);
        byte[] deserBytes = InstantiationUtil.serializeObject((Object)deserializationSchema);
        AvroRowDataSerializationSchema serCopy = (AvroRowDataSerializationSchema)InstantiationUtil.deserializeObject((byte[])serBytes, (ClassLoader)Thread.currentThread().getContextClassLoader());
        AvroRowDataDeserializationSchema deserCopy = (AvroRowDataDeserializationSchema)InstantiationUtil.deserializeObject((byte[])deserBytes, (ClassLoader)Thread.currentThread().getContextClassLoader());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GenericDatumWriter datumWriter = new GenericDatumWriter(nullableOuterSchema);
        BinaryEncoder encoder = null;
        if (encoding == AvroFormatOptions.AvroEncoding.BINARY) {
            encoder = EncoderFactory.get().binaryEncoder((OutputStream)byteArrayOutputStream, null);
        } else if (encoding == AvroFormatOptions.AvroEncoding.JSON) {
            encoder = EncoderFactory.get().jsonEncoder(nullableOuterSchema, (OutputStream)byteArrayOutputStream);
        }
        datumWriter.write((Object)outerRecord, (Encoder)encoder);
        encoder.flush();
        byte[] input = byteArrayOutputStream.toByteArray();
        RowData rowData = deserCopy.deserialize(input);
        serCopy.open(null);
        byte[] output = serCopy.serialize(rowData);
        Assertions.assertThat((byte[])output).isEqualTo((Object)input);
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testSpecificType(AvroFormatOptions.AvroEncoding encoding) throws Exception {
        LogicalTimeRecord record = new LogicalTimeRecord();
        Instant timestamp = Instant.parse("2010-06-30T01:20:20Z");
        record.setTypeTimestampMillis(timestamp);
        record.setTypeDate(LocalDate.parse("2014-03-01"));
        record.setTypeTimeMillis(LocalTime.parse("12:12:12"));
        SpecificDatumWriter datumWriter = new SpecificDatumWriter(LogicalTimeRecord.class);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Encoder encoder = AvroTestUtils.createEncoder(encoding, record.getSchema(), byteArrayOutputStream);
        datumWriter.write((Object)record, encoder);
        encoder.flush();
        byte[] input = byteArrayOutputStream.toByteArray();
        DataType dataType = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"type_timestamp_millis", (DataType)((DataType)DataTypes.TIMESTAMP((int)3).notNull())), DataTypes.FIELD((String)"type_date", (DataType)((DataType)DataTypes.DATE().notNull())), DataTypes.FIELD((String)"type_time_millis", (DataType)((DataType)DataTypes.TIME((int)3).notNull()))}).notNull();
        AvroRowDataSerializationSchema serializationSchema = this.createSerializationSchema(dataType, encoding, true);
        AvroRowDataDeserializationSchema deserializationSchema = this.createDeserializationSchema(dataType, encoding, true);
        RowData rowData = deserializationSchema.deserialize(input);
        byte[] output = serializationSchema.serialize(rowData);
        RowData rowData2 = deserializationSchema.deserialize(output);
        Assertions.assertThat((Object)rowData2).isEqualTo((Object)rowData);
        Assertions.assertThat((Instant)rowData.getTimestamp(0, 3).toInstant()).isEqualTo((Object)timestamp);
        Assertions.assertThat((String)((LocalDate)DataFormatConverters.LocalDateConverter.INSTANCE.toExternal((Object)rowData.getInt(1))).toString()).isEqualTo("2014-03-01");
        Assertions.assertThat((String)((LocalTime)DataFormatConverters.LocalTimeConverter.INSTANCE.toExternal((Object)rowData.getInt(2))).toString()).isEqualTo("12:12:12");
    }

    @ParameterizedTest
    @EnumSource(value=AvroFormatOptions.AvroEncoding.class)
    void testSerializationWithTypesMismatch(AvroFormatOptions.AvroEncoding encoding) throws Exception {
        AvroRowDataSerializationSchema serializationSchema = this.createSerializationSchema((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}).notNull(), encoding, true);
        GenericRowData rowData = new GenericRowData(2);
        rowData.setField(0, (Object)1);
        rowData.setField(1, (Object)2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> serializationSchema.serialize((RowData)rowData)).isInstanceOf(RuntimeException.class)).hasMessageContaining("Failed to serialize row.").hasStackTraceContaining("Fail to serialize at field: f1");
    }

    @Test
    void testTimestampTypeLegacyMapping() throws Exception {
        Tuple4<Class<? extends SpecificRecord>, SpecificRecord, GenericRecord, Row> testData = AvroTestUtils.getTimestampTestData();
        SpecificDatumWriter datumWriter = new SpecificDatumWriter(Timestamps.class);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)byteArrayOutputStream, null);
        datumWriter.write((Object)((Timestamps)((Object)testData.f1)), (Encoder)encoder);
        encoder.flush();
        DataType dataType = AvroSchemaConverter.convertToDataType((String)SpecificData.get().getSchema(Timestamps.class).toString());
        Assertions.assertThat((Object)((DataType)dataType.getChildren().get(2))).isEqualTo((Object)new AtomicDataType((LogicalType)new BigIntType(false)));
        Assertions.assertThat((Object)((DataType)dataType.getChildren().get(3))).isEqualTo((Object)new AtomicDataType((LogicalType)new BigIntType(false)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createSerializationSchema(dataType, AvroFormatOptions.AvroEncoding.BINARY, true)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Avro does not support TIMESTAMP type with precision: 6, it only supports precision less than 3.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createDeserializationSchema(dataType, AvroFormatOptions.AvroEncoding.BINARY, true)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Avro does not support TIMESTAMP type with precision: 6, it only supports precision less than 3.");
    }

    @Test
    void testTimestampTypeNewMapping() throws Exception {
        Tuple4<Class<? extends SpecificRecord>, SpecificRecord, GenericRecord, Row> testData = AvroTestUtils.getTimestampTestData();
        SpecificDatumWriter datumWriter = new SpecificDatumWriter(Timestamps.class);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)byteArrayOutputStream, null);
        datumWriter.write((Object)((Timestamps)((Object)testData.f1)), (Encoder)encoder);
        encoder.flush();
        byte[] input = byteArrayOutputStream.toByteArray();
        DataType dataType = AvroSchemaConverter.convertToDataType((String)SpecificData.get().getSchema(Timestamps.class).toString(), (boolean)false);
        AvroRowDataSerializationSchema serializationSchema = this.createSerializationSchema(dataType, AvroFormatOptions.AvroEncoding.BINARY, false);
        AvroRowDataDeserializationSchema deserializationSchema = this.createDeserializationSchema(dataType, AvroFormatOptions.AvroEncoding.BINARY, false);
        RowData rowData = deserializationSchema.deserialize(input);
        byte[] output = serializationSchema.serialize(rowData);
        RowData rowData2 = deserializationSchema.deserialize(output);
        Assertions.assertThat((Object)rowData2).isEqualTo((Object)rowData);
        Assertions.assertThat((String)rowData.getTimestamp(2, 3).toLocalDateTime().toString()).isEqualTo("2014-03-01T12:12:12.321");
        Assertions.assertThat((String)rowData.getTimestamp(3, 6).toLocalDateTime().toString()).isEqualTo("1970-01-01T00:02:03.456");
    }

    private AvroRowDataSerializationSchema createSerializationSchema(DataType dataType, AvroFormatOptions.AvroEncoding encoding, boolean legacyTimestampMapping) throws Exception {
        RowType rowType = (RowType)dataType.getLogicalType();
        AvroRowDataSerializationSchema serializationSchema = new AvroRowDataSerializationSchema(rowType, encoding, legacyTimestampMapping);
        serializationSchema.open(null);
        return serializationSchema;
    }

    private AvroRowDataDeserializationSchema createDeserializationSchema(DataType dataType, AvroFormatOptions.AvroEncoding encoding, boolean legacyTimestampMapping) throws Exception {
        RowType rowType = (RowType)dataType.getLogicalType();
        InternalTypeInfo typeInfo = InternalTypeInfo.of((RowType)rowType);
        AvroRowDataDeserializationSchema deserializationSchema = new AvroRowDataDeserializationSchema(rowType, (TypeInformation)typeInfo, encoding, legacyTimestampMapping);
        deserializationSchema.open(null);
        return deserializationSchema;
    }
}

