/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.avro.AvroOutputFormat;
import org.apache.flink.formats.avro.generated.Colors;
import org.apache.flink.formats.avro.generated.Fixed2;
import org.apache.flink.formats.avro.generated.User;
import org.apache.flink.mock.Whitebox;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AvroOutputFormatTest {
    AvroOutputFormatTest() {
    }

    @Test
    void testSetCodec() {
        AvroOutputFormat outputFormat = new AvroOutputFormat(User.class);
        try {
            outputFormat.setCodec(AvroOutputFormat.Codec.SNAPPY);
        }
        catch (Exception ex) {
            Assertions.fail((String)"unexpected exception");
        }
    }

    @Test
    void testSetCodecError() {
        boolean error = false;
        AvroOutputFormat outputFormat = new AvroOutputFormat(User.class);
        try {
            outputFormat.setCodec(null);
        }
        catch (Exception ex) {
            error = true;
        }
        Assertions.assertThat((boolean)error).isTrue();
    }

    @Test
    void testSerialization() throws Exception {
        this.serializeAndDeserialize(null, null);
        this.serializeAndDeserialize(null, User.SCHEMA$);
        for (AvroOutputFormat.Codec codec : AvroOutputFormat.Codec.values()) {
            this.serializeAndDeserialize(codec, null);
            this.serializeAndDeserialize(codec, User.SCHEMA$);
        }
    }

    private void serializeAndDeserialize(AvroOutputFormat.Codec codec, Schema schema) throws IOException, ClassNotFoundException {
        AvroOutputFormat outputFormat = new AvroOutputFormat(User.class);
        if (codec != null) {
            outputFormat.setCodec(codec);
        }
        if (schema != null) {
            outputFormat.setSchema(schema);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(outputFormat);
        }
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));){
            Object o = ois.readObject();
            Assertions.assertThat((Object)o).isInstanceOf(AvroOutputFormat.class);
            AvroOutputFormat restored = (AvroOutputFormat)o;
            AvroOutputFormat.Codec restoredCodec = (AvroOutputFormat.Codec)Whitebox.getInternalState((Object)restored, (String)"codec");
            Schema restoredSchema = (Schema)Whitebox.getInternalState((Object)restored, (String)"userDefinedSchema");
            Assertions.assertThat((Comparable)codec).isSameAs((Object)restoredCodec);
            Assertions.assertThat((Object)schema).isEqualTo((Object)restoredSchema);
        }
    }

    @Test
    void testCompression() throws Exception {
        Path outputPath = new Path(File.createTempFile("avro-output-file", "avro").getAbsolutePath());
        AvroOutputFormat outputFormat = new AvroOutputFormat(outputPath, User.class);
        outputFormat.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        Path compressedOutputPath = new Path(File.createTempFile("avro-output-file", "compressed.avro").getAbsolutePath());
        AvroOutputFormat compressedOutputFormat = new AvroOutputFormat(compressedOutputPath, User.class);
        compressedOutputFormat.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        compressedOutputFormat.setCodec(AvroOutputFormat.Codec.SNAPPY);
        this.output((AvroOutputFormat<User>)outputFormat);
        this.output((AvroOutputFormat<User>)compressedOutputFormat);
        Assertions.assertThat((long)this.fileSize(outputPath)).isGreaterThan(this.fileSize(compressedOutputPath));
        FileSystem fs = FileSystem.getLocalFileSystem();
        fs.delete(outputPath, false);
        fs.delete(compressedOutputPath, false);
    }

    private long fileSize(Path path) throws IOException {
        return path.getFileSystem().getFileStatus(path).getLen();
    }

    private void output(AvroOutputFormat<User> outputFormat) throws IOException {
        outputFormat.configure(new Configuration());
        outputFormat.open(new OutputFormat.InitializationContext(){

            public int getNumTasks() {
                return 1;
            }

            public int getTaskNumber() {
                return 1;
            }

            public int getAttemptNumber() {
                return 0;
            }
        });
        for (int i = 0; i < 100; ++i) {
            User user = new User();
            user.setName("testUser");
            user.setFavoriteNumber(1);
            user.setFavoriteColor("blue");
            user.setTypeBoolTest(true);
            user.setTypeArrayString(Collections.emptyList());
            user.setTypeArrayBoolean(Collections.emptyList());
            user.setTypeEnum(Colors.BLUE);
            user.setTypeMap(Collections.emptyMap());
            user.setTypeBytes(ByteBuffer.allocate(10));
            user.setTypeDate(LocalDate.parse("2014-03-01"));
            user.setTypeTimeMillis(LocalTime.parse("12:12:12"));
            user.setTypeTimeMicros(LocalTime.ofSecondOfDay(0L).plus(123456L, ChronoUnit.MICROS));
            user.setTypeTimestampMillis(Instant.parse("2014-03-01T12:12:12.321Z"));
            user.setTypeTimestampMicros(Instant.ofEpochSecond(0L).plus(123456L, ChronoUnit.MICROS));
            user.setTypeDecimalBytes(ByteBuffer.wrap(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
            user.setTypeDecimalFixed(new Fixed2(BigDecimal.valueOf(2000L, 2).unscaledValue().toByteArray()));
            outputFormat.writeRecord((Object)user);
        }
        outputFormat.close();
    }

    @Test
    void testGenericRecord() throws IOException {
        Path outputPath = new Path(File.createTempFile("avro-output-file", "generic.avro").getAbsolutePath());
        AvroOutputFormat outputFormat = new AvroOutputFormat(outputPath, GenericRecord.class);
        Schema schema = new Schema.Parser().parse("{\"type\":\"record\", \"name\":\"user\", \"fields\": [{\"name\":\"user_name\", \"type\":\"string\"}, {\"name\":\"favorite_number\", \"type\":\"int\"}, {\"name\":\"favorite_color\", \"type\":\"string\"}]}");
        outputFormat.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        outputFormat.setSchema(schema);
        this.output((AvroOutputFormat<GenericRecord>)outputFormat, schema);
        GenericDatumReader reader = new GenericDatumReader(schema);
        DataFileReader dataFileReader = new DataFileReader(new File(outputPath.getPath()), (DatumReader)reader);
        while (dataFileReader.hasNext()) {
            GenericRecord record = (GenericRecord)dataFileReader.next();
            Assertions.assertThat((String)record.get("user_name").toString()).isEqualTo("testUser");
            Assertions.assertThat((Object)record.get("favorite_number")).isEqualTo((Object)1);
            Assertions.assertThat((String)record.get("favorite_color").toString()).isEqualTo("blue");
        }
        FileSystem fs = FileSystem.getLocalFileSystem();
        fs.delete(outputPath, false);
    }

    private void output(AvroOutputFormat<GenericRecord> outputFormat, Schema schema) throws IOException {
        outputFormat.configure(new Configuration());
        outputFormat.open(new OutputFormat.InitializationContext(){

            public int getNumTasks() {
                return 1;
            }

            public int getTaskNumber() {
                return 1;
            }

            public int getAttemptNumber() {
                return 0;
            }
        });
        for (int i = 0; i < 100; ++i) {
            GenericData.Record record = new GenericData.Record(schema);
            record.put("user_name", (Object)"testUser");
            record.put("favorite_number", (Object)1);
            record.put("favorite_color", (Object)"blue");
            outputFormat.writeRecord((Object)record);
        }
        outputFormat.close();
    }
}

