/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import com.esotericsoftware.kryo.Kryo;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.core.testutils.FilteredClassLoader;
import org.apache.flink.formats.avro.utils.AvroKryoSerializerUtils;
import org.apache.flink.util.FlinkUserCodeClassLoader;
import org.apache.flink.util.FlinkUserCodeClassLoaders;
import org.apache.flink.util.MutableURLClassLoader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AvroKryoClassloadingTest {
    AvroKryoClassloadingTest() {
    }

    @Test
    void testKryoInChildClasspath() throws Exception {
        Class<AvroKryoSerializerUtils> avroClass = AvroKryoSerializerUtils.class;
        URL avroLocation = avroClass.getProtectionDomain().getCodeSource().getLocation();
        URL kryoLocation = Kryo.class.getProtectionDomain().getCodeSource().getLocation();
        FilteredClassLoader parentClassLoader = new FilteredClassLoader(avroClass.getClassLoader(), new String[]{AvroKryoSerializerUtils.class.getName()});
        MutableURLClassLoader userAppClassLoader = FlinkUserCodeClassLoaders.childFirst((URL[])new URL[]{avroLocation, kryoLocation}, (ClassLoader)parentClassLoader, (String[])((List)CoreOptions.ALWAYS_PARENT_FIRST_LOADER_PATTERNS.defaultValue()).toArray(new String[0]), (Consumer)FlinkUserCodeClassLoader.NOOP_EXCEPTION_HANDLER, (boolean)true);
        Class<?> userLoadedAvroClass = Class.forName(avroClass.getName(), false, (ClassLoader)userAppClassLoader);
        Assertions.assertThat(userLoadedAvroClass).isNotEqualTo(avroClass);
        Method m = userLoadedAvroClass.getMethod("addAvroGenericDataArrayRegistration", LinkedHashMap.class);
        LinkedHashMap map = new LinkedHashMap();
        m.invoke(userLoadedAvroClass.newInstance(), map);
        Assertions.assertThat(map).hasSize(1);
    }
}

