/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.rpc.OutOfMemoryHandler;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.SaslCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SaslDecryptionHandler
extends MessageToMessageDecoder<ByteBuf> {
    private static final Logger logger = LoggerFactory.getLogger((String)SaslDecryptionHandler.class.getCanonicalName());
    private final SaslCodec saslCodec;
    private final int maxWrappedSize;
    private final OutOfMemoryHandler outOfMemoryHandler;
    private final byte[] encodedMsg;
    private final ByteBuffer lengthOctets;

    SaslDecryptionHandler(SaslCodec saslCodec, int maxWrappedSize, OutOfMemoryHandler oomHandler) {
        this.saslCodec = saslCodec;
        this.outOfMemoryHandler = oomHandler;
        this.maxWrappedSize = maxWrappedSize;
        this.encodedMsg = new byte[maxWrappedSize];
        this.lengthOctets = ByteBuffer.allocate(4);
        this.lengthOctets.order(ByteOrder.BIG_ENDIAN);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        logger.trace("Added sasl-decryption-handler handler");
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        logger.trace("Removed sasl-decryption-handler handler");
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws IOException {
        if (!ctx.channel().isOpen()) {
            logger.trace("Channel closed before decoding the message of {} bytes", (Object)msg.readableBytes());
            msg.skipBytes(msg.readableBytes());
            return;
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("Trying to decrypt the encrypted message of size: {} with maxWrappedSize", (Object)msg.readableBytes());
            }
            msg.getBytes(msg.readerIndex(), this.lengthOctets.array(), 0, 4);
            int wrappedMsgLength = this.lengthOctets.getInt(0);
            msg.skipBytes(4);
            assert (msg.readableBytes() == wrappedMsgLength);
            if (wrappedMsgLength > this.maxWrappedSize) {
                throw new RpcException(String.format("Received encoded buffer size: %d is larger than negotiated maxWrappedSize: %d. Closing the connection as this is unexpected.", wrappedMsgLength, this.maxWrappedSize));
            }
            byte[] wrappedMsg = this.encodedMsg;
            msg.getBytes(msg.readerIndex(), wrappedMsg, 0, wrappedMsgLength);
            byte[] decodedMsg = this.saslCodec.unwrap(wrappedMsg, 0, wrappedMsgLength);
            if (logger.isTraceEnabled()) {
                logger.trace("Successfully decrypted incoming message. Length after decryption: {}", (Object)decodedMsg.length);
            }
            msg.skipBytes(wrappedMsgLength);
            ByteBuf decodedMsgBuf = ctx.alloc().buffer(decodedMsg.length);
            decodedMsgBuf.writeBytes(decodedMsg);
            out.add(decodedMsgBuf);
        }
        catch (OutOfMemoryException e) {
            logger.warn("Failure allocating buffer on incoming stream due to memory limits.");
            msg.resetReaderIndex();
            this.outOfMemoryHandler.handle();
        }
        catch (IOException e) {
            logger.error("Something went wrong while unwrapping the message: {} with MaxEncodeSize: {} and error: {}", new Object[]{msg, this.maxWrappedSize, e.getMessage()});
            throw e;
        }
    }
}

