/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.exec.physical.impl.ScreenCreator;
import org.apache.drill.exec.testing.Controls;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={JdbcTest.class})
public class StatementTest
extends JdbcTestBase {
    private static final Logger logger = LoggerFactory.getLogger(StatementTest.class);
    private static final Random RANDOMIZER = new Random(20150304L);
    private static final String SYS_VERSION_SQL = "select * from sys.version";
    private static final String SYS_RANDOM_SQL = "SELECT cast(random() as varchar) as myStr FROM (VALUES(1)) union SELECT cast(random() as varchar) as myStr FROM (VALUES(1)) union SELECT cast(random() as varchar) as myStr FROM (VALUES(1)) ";
    private static Connection connection;

    @BeforeClass
    public static void setUpStatement() throws SQLException {
        connection = new Driver().connect("jdbc:drill:zk=local", null);
    }

    @AfterClass
    public static void tearDownStatement() throws SQLException {
        connection.close();
    }

    @Test
    public void testDefaultGetQueryTimeout() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            int timeoutValue = stmt.getQueryTimeout();
            Assert.assertEquals((long)0L, (long)timeoutValue);
        }
    }

    @Test
    public void testInvalidSetQueryTimeout() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            int valueToSet = -10;
            try {
                stmt.setQueryTimeout(valueToSet);
            }
            catch (SQLException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"illegal timeout value"));
            }
        }
    }

    @Test
    public void testValidSetQueryTimeout() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            int valueToSet = RANDOMIZER.nextInt(59) + 1;
            logger.info("Setting timeout as {} seconds", (Object)valueToSet);
            stmt.setQueryTimeout(valueToSet);
            Assert.assertEquals((long)valueToSet, (long)stmt.getQueryTimeout());
        }
    }

    @Test
    public void testSetQueryTimeoutAsZero() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.setQueryTimeout(0);
            stmt.executeQuery(SYS_RANDOM_SQL);
            ResultSet rs = stmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                rs.getBytes(1);
                ++rowCount;
            }
            Assert.assertEquals((long)3L, (long)rowCount);
        }
    }

    @Test
    public void testClientTriggeredQueryTimeout() throws Exception {
        int timeoutDuration = 3;
        int rowsCounted = 0;
        try (Statement stmt = connection.createStatement();){
            stmt.setQueryTimeout(timeoutDuration);
            logger.info("Set a timeout of {} seconds", (Object)stmt.getQueryTimeout());
            ResultSet rs = stmt.executeQuery(SYS_RANDOM_SQL);
            try {
                while (rs.next()) {
                    rs.getString(1);
                    ++rowsCounted;
                    try {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(timeoutDuration + 1));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    logger.info("Paused for {} seconds", (Object)(timeoutDuration + 1));
                }
            }
            catch (SQLTimeoutException sqlEx) {
                logger.info("Counted " + rowsCounted + " rows before hitting timeout");
                if (stmt != null) {
                    stmt.close();
                }
                return;
            }
        }
        throw new Exception("Failed to trigger timeout of " + timeoutDuration + " sec");
    }

    @Test(expected=SQLTimeoutException.class)
    public void testServerTriggeredQueryTimeout() throws Exception {
        int timeoutDuration = 2;
        long serverPause = timeoutDuration + 2;
        int cleanupPause = 3;
        String controls = Controls.newBuilder().addTimedPause(ScreenCreator.class, "sending-data", 0, TimeUnit.SECONDS.toMillis(serverPause)).build();
        try (Connection exclusiveConnection = new Driver().connect("jdbc:drill:zk=local", null);){
            try (Statement stmt = exclusiveConnection.createStatement();){
                MatcherAssert.assertThat((Object)stmt.execute(String.format("ALTER session SET `%s` = '%s'", "drill.exec.testing.controls", controls)), (Matcher)CoreMatchers.equalTo((Object)true));
            }
            try {
                stmt = exclusiveConnection.createStatement();
                try {
                    stmt.setQueryTimeout(timeoutDuration);
                    logger.info("Set a timeout of {} seconds", (Object)stmt.getQueryTimeout());
                    ResultSet rs = stmt.executeQuery(SYS_VERSION_SQL);
                    while (rs.next()) {
                        rs.getBytes(1);
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (SQLTimeoutException sqlEx) {
                logger.info("SQLTimeoutException thrown: {}", (Object)sqlEx.getMessage());
                throw sqlEx;
            }
            finally {
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(cleanupPause));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Test
    public void testNonTriggeredQueryTimeout() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.setQueryTimeout(60);
            stmt.executeQuery(SYS_VERSION_SQL);
            ResultSet rs = stmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                rs.getBytes(1);
                ++rowCount;
            }
            Assert.assertEquals((long)1L, (long)rowCount);
        }
    }
}

