/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.drill.categories.FlakyTest;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={JdbcTest.class, FlakyTest.class})
public class TestInformationSchemaColumns
extends JdbcTestBase {
    private static final String VIEW_NAME = TestInformationSchemaColumns.class.getSimpleName() + "_View";
    private static Connection connection;
    private static ResultSetMetaData rowsMetadata;
    private static ResultSet mdrOptBOOLEAN;
    private static ResultSet mdrReqTINYINT;
    private static ResultSet mdrOptSMALLINT;
    private static ResultSet mdrReqINTEGER;
    private static ResultSet mdrOptBIGINT;
    private static ResultSet mdrOptREAL;
    private static ResultSet mdrOptFLOAT;
    private static ResultSet mdrReqDOUBLE;
    private static ResultSet mdrReqDECIMAL_5_3;
    private static ResultSet mdrReqVARCHAR_10;
    private static ResultSet mdrOptVARCHAR;
    private static ResultSet mdrReqCHAR_5;
    private static ResultSet mdrOptVARBINARY_16;
    private static ResultSet mdrOptBINARY_65536;
    private static ResultSet mdrReqDATE;
    private static ResultSet mdrReqTIME;
    private static ResultSet mdrOptTIME_7;
    private static ResultSet mdrOptTIMESTAMP;
    private static ResultSet mdrReqINTERVAL_Y;
    private static ResultSet mdrReqINTERVAL_3Y_Mo;
    private static ResultSet mdrReqINTERVAL_Mo;
    private static ResultSet mdrReqINTERVAL_D;
    private static ResultSet mdrReqINTERVAL_4D_H;
    private static ResultSet mdrReqINTERVAL_3D_Mi;
    private static ResultSet mdrReqINTERVAL_2D_S5;
    private static ResultSet mdrReqINTERVAL_H;
    private static ResultSet mdrReqINTERVAL_1H_Mi;
    private static ResultSet mdrReqINTERVAL_3H_S1;
    private static ResultSet mdrReqINTERVAL_Mi;
    private static ResultSet mdrReqINTERVAL_5Mi_S;
    private static ResultSet mdrReqINTERVAL_S;
    private static ResultSet mdrReqINTERVAL_3S;
    private static ResultSet mdrReqINTERVAL_3S1;
    private static ResultSet mdrReqARRAY;
    private static ResultSet mdrReqMAP;
    private static ResultSet mdrUnkSTRUCT;
    private static ResultSet mdrUnkUnion;

    private static String encodeAsSqlCharStrLiteral(String value) {
        return "'" + value.replaceAll("'", "''") + "'";
    }

    private static ResultSet setUpRow(String schemaName, String tableOrViewName, String columnName) throws SQLException {
        Statement stmt = connection.createStatement();
        ResultSet mdrUnk = stmt.executeQuery("SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_CATALOG = " + TestInformationSchemaColumns.encodeAsSqlCharStrLiteral("DRILL") + "  AND TABLE_SCHEMA  = " + TestInformationSchemaColumns.encodeAsSqlCharStrLiteral(schemaName) + "  AND TABLE_NAME    = " + TestInformationSchemaColumns.encodeAsSqlCharStrLiteral(tableOrViewName) + "  AND COLUMN_NAME   = " + TestInformationSchemaColumns.encodeAsSqlCharStrLiteral(columnName));
        Assert.assertTrue((String)("Test setup error:  No row for column DRILL . `" + schemaName + "` . `" + tableOrViewName + "` . `" + columnName + "`"), (boolean)mdrUnk.next());
        return mdrUnk;
    }

    @BeforeClass
    public static void setUpConnectionAndMetadataToCheck() throws Exception {
        connection = new Driver().connect("jdbc:drill:zk=local", TestInformationSchemaColumns.getDefaultProperties());
        Statement stmt = connection.createStatement();
        ResultSet util = stmt.executeQuery("USE dfs.tmp");
        Assert.assertTrue((boolean)util.next());
        Assert.assertTrue((String)("Error setting schema for test: " + util.getString(2)), (boolean)util.getBoolean(1));
        util = stmt.executeQuery("CREATE OR REPLACE VIEW " + VIEW_NAME + " AS SELECT \n  CAST( NULL    AS BOOLEAN            ) AS mdrOptBOOLEAN,        \n  \n  CAST(    1    AS INT            ) AS mdrReqTINYINT,        \n  CAST( NULL    AS INT           ) AS mdrOptSMALLINT,       \n  CAST(    2    AS INTEGER            ) AS mdrReqINTEGER,        \n  CAST( NULL    AS BIGINT             ) AS mdrOptBIGINT,         \n  \n  CAST( NULL    AS FLOAT               ) AS mdrOptREAL,           \n  CAST( NULL    AS FLOAT              ) AS mdrOptFLOAT,          \n  CAST(  3.3    AS DOUBLE             ) AS mdrReqDOUBLE,         \n  \n  CAST(  4.4    AS DECIMAL(5,3)       ) AS mdrReqDECIMAL_5_3,    \n  \n  CAST( 'Hi'    AS VARCHAR(10)        ) AS mdrReqVARCHAR_10,     \n  CAST( NULL    AS VARCHAR            ) AS mdrOptVARCHAR,        \n  CAST( '55'    AS CHAR(5)            ) AS mdrReqCHAR_5,         \n  CAST( NULL    AS VARBINARY(16)      ) AS mdrOptVARBINARY_16,   \n  CAST( NULL    AS VARBINARY(65536)   ) AS mdrOptBINARY_65536,   \n  CAST( NULL    AS BINARY(8)          ) AS mdrOptBINARY_8,       \n  \n                   DATE '2015-01-01'    AS mdrReqDATE,           \n                   TIME '23:59:59'      AS mdrReqTIME,           \n  CAST( NULL    AS TIME(7)            ) AS mdrOptTIME_7,         \n  CAST( NULL    AS TIMESTAMP          ) AS mdrOptTIMESTAMP,      \n  INTERVAL '1'     YEAR                 AS mdrReqINTERVAL_Y,     \n  INTERVAL '1-2'   YEAR(3) TO MONTH     AS mdrReqINTERVAL_3Y_Mo, \n  INTERVAL '2'     MONTH                AS mdrReqINTERVAL_Mo,    \n  INTERVAL '3'     DAY                  AS mdrReqINTERVAL_D,     \n  INTERVAL '3 4'   DAY(4) TO HOUR       AS mdrReqINTERVAL_4D_H,  \n  INTERVAL '3 4:5' DAY(3) TO MINUTE     AS mdrReqINTERVAL_3D_Mi, \n  INTERVAL '3 4:5:6' DAY(2) TO SECOND(5) AS mdrReqINTERVAL_2D_S5, \n  INTERVAL '4'     HOUR                 AS mdrReqINTERVAL_H,     \n  INTERVAL '4:5'   HOUR(1) TO MINUTE    AS mdrReqINTERVAL_1H_Mi, \n  INTERVAL '4:5:6' HOUR(3) TO SECOND(1) AS mdrReqINTERVAL_3H_S1, \n  INTERVAL '5'     MINUTE               AS mdrReqINTERVAL_Mi,    \n  INTERVAL '5:6'   MINUTE(5) TO SECOND  AS mdrReqINTERVAL_5Mi_S, \n  INTERVAL '6'     SECOND               AS mdrReqINTERVAL_S,     \n  INTERVAL '6'     SECOND(3)            AS mdrReqINTERVAL_3S,    \n  INTERVAL '6'     SECOND(3, 1)         AS mdrReqINTERVAL_3S1,   \n  '' \nFROM INFORMATION_SCHEMA.COLUMNS \nLIMIT 1 ");
        Assert.assertTrue((boolean)util.next());
        Assert.assertTrue((String)("Error creating temporary test-columns view " + VIEW_NAME + ": " + util.getString(2)), (boolean)util.getBoolean(1));
        mdrOptBOOLEAN = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrOptBOOLEAN");
        mdrReqINTEGER = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTEGER");
        mdrOptBIGINT = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrOptBIGINT");
        mdrOptFLOAT = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrOptFLOAT");
        mdrReqDOUBLE = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqDOUBLE");
        mdrReqDECIMAL_5_3 = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqDECIMAL_5_3");
        mdrReqVARCHAR_10 = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqVARCHAR_10");
        mdrOptVARCHAR = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrOptVARCHAR");
        mdrReqCHAR_5 = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqCHAR_5");
        mdrOptVARBINARY_16 = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrOptVARBINARY_16");
        mdrOptBINARY_65536 = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrOptBINARY_65536");
        mdrReqDATE = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqDATE");
        mdrReqTIME = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqTIME");
        mdrOptTIME_7 = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrOptTIME_7");
        mdrOptTIMESTAMP = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrOptTIMESTAMP");
        mdrReqINTERVAL_Y = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTERVAL_Y");
        mdrReqINTERVAL_3Y_Mo = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTERVAL_3Y_Mo");
        mdrReqINTERVAL_Mo = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTERVAL_Mo");
        mdrReqINTERVAL_D = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTERVAL_D");
        mdrReqINTERVAL_4D_H = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTERVAL_4D_H");
        mdrReqINTERVAL_3D_Mi = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTERVAL_3D_Mi");
        mdrReqINTERVAL_2D_S5 = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTERVAL_2D_S5");
        mdrReqINTERVAL_H = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTERVAL_H");
        mdrReqINTERVAL_1H_Mi = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTERVAL_1H_Mi");
        mdrReqINTERVAL_3H_S1 = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTERVAL_3H_S1");
        mdrReqINTERVAL_Mi = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTERVAL_Mi");
        mdrReqINTERVAL_5Mi_S = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTERVAL_5Mi_S");
        mdrReqINTERVAL_S = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTERVAL_S");
        mdrReqINTERVAL_3S = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTERVAL_3S");
        mdrReqINTERVAL_3S1 = TestInformationSchemaColumns.setUpRow("dfs.tmp", VIEW_NAME, "mdrReqINTERVAL_3S1");
        Statement stmt2 = connection.createStatement();
        ResultSet allColumns = stmt2.executeQuery("SELECT * FROM INFORMATION_SCHEMA.COLUMNS ");
        rowsMetadata = allColumns.getMetaData();
    }

    @AfterClass
    public static void tearDownConnection() throws SQLException {
        ResultSet util = connection.createStatement().executeQuery("DROP VIEW " + VIEW_NAME + "");
        Assert.assertTrue((boolean)util.next());
        Assert.assertTrue((String)("Error dropping temporary test-columns view " + VIEW_NAME + ": " + util.getString(2)), (boolean)util.getBoolean(1));
        connection.close();
    }

    private Integer getIntOrNull(ResultSet row, String columnName) throws SQLException {
        int value = row.getInt(columnName);
        return row.wasNull() ? null : Integer.valueOf(value);
    }

    @Ignore(value="unless and until all COLUMNS columns are present")
    @Test
    public void testMetadataHasRightNumberOfColumns() throws SQLException {
        MatcherAssert.assertThat((String)"column count", (Object)rowsMetadata.getColumnCount(), (Matcher)CoreMatchers.equalTo((Object)50));
    }

    @Test
    public void testMetadataHasInterimNumberOfColumns() throws SQLException {
        MatcherAssert.assertThat((String)"column count", (Object)rowsMetadata.getColumnCount(), (Matcher)CoreMatchers.equalTo((Object)24));
    }

    @Test
    public void test_TABLE_CATALOG_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(1), (Matcher)CoreMatchers.equalTo((Object)"TABLE_CATALOG"));
    }

    @Test
    public void test_TABLE_CATALOG_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptBOOLEAN.getString("TABLE_CATALOG"), (Matcher)CoreMatchers.equalTo((Object)"DRILL"));
    }

    @Test
    public void test_TABLE_CATALOG_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(1), (Matcher)CoreMatchers.equalTo((Object)"TABLE_CATALOG"));
    }

    @Test
    public void test_TABLE_CATALOG_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(1), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_TABLE_CATALOG_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(1), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Ignore(value="until resolved:  any requirement on nullability (DRILL-2420?)")
    @Test
    public void test_TABLE_CATALOG_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(1), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_TABLE_SCHEMA_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(2), (Matcher)CoreMatchers.equalTo((Object)"TABLE_SCHEMA"));
    }

    @Test
    public void test_TABLE_SCHEMA_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptBOOLEAN.getString("TABLE_SCHEMA"), (Matcher)CoreMatchers.equalTo((Object)"dfs.tmp"));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_TABLE_SCHEMA_hasRightValue_tdbARRAY() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqARRAY.getString("TABLE_SCHEMA"), (Matcher)CoreMatchers.equalTo((Object)"hive_test.default"));
    }

    @Test
    public void test_TABLE_SCHEMA_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(2), (Matcher)CoreMatchers.equalTo((Object)"TABLE_SCHEMA"));
    }

    @Test
    public void test_TABLE_SCHEMA_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(2), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_TABLE_SCHEMA_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(2), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Ignore(value="until resolved:  any requirement on nullability (DRILL-2420?)")
    @Test
    public void test_TABLE_SCHEMA_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(2), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_TABLE_NAME_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(3), (Matcher)CoreMatchers.equalTo((Object)"TABLE_NAME"));
    }

    @Test
    public void test_TABLE_NAME_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptBOOLEAN.getString("TABLE_NAME"), (Matcher)CoreMatchers.equalTo((Object)VIEW_NAME));
    }

    @Test
    public void test_TABLE_NAME_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(3), (Matcher)CoreMatchers.equalTo((Object)"TABLE_NAME"));
    }

    @Test
    public void test_TABLE_NAME_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(3), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_TABLE_NAME_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(3), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Ignore(value="until resolved:  any requirement on nullability (DRILL-2420?)")
    @Test
    public void test_TABLE_NAME_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(3), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_COLUMN_NAME_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(4), (Matcher)CoreMatchers.equalTo((Object)"COLUMN_NAME"));
    }

    @Test
    public void test_COLUMN_NAME_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptBOOLEAN.getString("COLUMN_NAME"), (Matcher)CoreMatchers.equalTo((Object)"mdrOptBOOLEAN"));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_COLUMN_NAME_hasRightValue_tdbARRAY() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqARRAY.getString("COLUMN_NAME"), (Matcher)CoreMatchers.equalTo((Object)"listtype"));
    }

    @Test
    public void test_COLUMN_NAME_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(4), (Matcher)CoreMatchers.equalTo((Object)"COLUMN_NAME"));
    }

    @Test
    public void test_COLUMN_NAME_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(4), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_COLUMN_NAME_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(4), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Ignore(value="until resolved:  any requirement on nullability (DRILL-2420?)")
    @Test
    public void test_COLUMN_NAME_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(4), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_ORDINAL_POSITION_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(5), (Matcher)CoreMatchers.equalTo((Object)"ORDINAL_POSITION"));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptBOOLEAN.getInt("ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrReqTINYINT() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqTINYINT.getInt("ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrOptSMALLINT() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptSMALLINT.getInt("ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrReqINTEGER() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTEGER.getInt("ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrOptBIGINT() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptBIGINT.getInt("ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrOptREAL() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptREAL.getInt("ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrOptFLOAT() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptFLOAT.getInt("ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)7));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrReqDOUBLE() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqDOUBLE.getInt("ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)8));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_ORDINAL_POSITION_hasRightValue_tdbARRAY() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqARRAY.getInt("ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)14));
    }

    @Test
    public void test_ORDINAL_POSITION_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(5), (Matcher)CoreMatchers.equalTo((Object)"ORDINAL_POSITION"));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(5), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(5), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(5), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_COLUMN_DEFAULT_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(6), (Matcher)CoreMatchers.equalTo((Object)"COLUMN_DEFAULT"));
    }

    @Test
    public void test_COLUMN_DEFAULT_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptBOOLEAN.getString("COLUMN_DEFAULT"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_COLUMN_DEFAULT_hasRightValue_tdbARRAY() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqARRAY.getString("COLUMN_DEFAULT"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_COLUMN_DEFAULT_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(6), (Matcher)CoreMatchers.equalTo((Object)"COLUMN_DEFAULT"));
    }

    @Test
    public void test_COLUMN_DEFAULT_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(6), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_COLUMN_DEFAULT_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(6), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_COLUMN_DEFAULT_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(6), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_IS_NULLABLE_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(7), (Matcher)CoreMatchers.equalTo((Object)"IS_NULLABLE"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrOptBOOLEAN.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqTINYINT() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrReqTINYINT.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptSMALLINT() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrOptSMALLINT.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqINTEGER() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrReqINTEGER.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptBIGINT() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrOptBIGINT.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptREAL() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrOptREAL.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptFLOAT() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrOptFLOAT.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqDOUBLE() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrReqDOUBLE.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrReqDECIMAL_5_3.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrReqVARCHAR_10.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptVARCHAR() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrOptVARCHAR.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqCHAR_5() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrReqCHAR_5.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrOptVARBINARY_16.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptBINARY_1048576() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrOptBINARY_65536.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqDATE() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrReqDATE.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqTIME() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrReqTIME.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptTIME_7() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrOptTIME_7.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrOptTIMESTAMP.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrReqINTERVAL_Y.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqINTERVAL_H_S3() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrReqINTERVAL_3H_S1.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_IS_NULLABLE_hasRightValue_tdbARRAY() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrReqARRAY.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_IS_NULLABLE_hasRightValue_tbdMAP() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrReqMAP.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    @Test
    public void test_IS_NULLABLE_hasRightValue_tbdSTRUCT() throws SQLException {
        MatcherAssert.assertThat((Object)mdrUnkSTRUCT.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
        MatcherAssert.assertThat((Object)mdrUnkSTRUCT.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    @Test
    public void test_IS_NULLABLE_hasRightValue_tbdUnion() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrUnkUnion.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)mdrUnkUnion.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(7), (Matcher)CoreMatchers.equalTo((Object)"IS_NULLABLE"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(7), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(7), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Ignore(value="until resolved:  any requirement on nullability (DRILL-2420?)")
    @Test
    public void test_IS_NULLABLE_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(7), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_DATA_TYPE_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(8), (Matcher)CoreMatchers.equalTo((Object)"DATA_TYPE"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptBOOLEAN.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"BOOLEAN"));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqTINYINT() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqTINYINT.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"TINYINT"));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptSMALLINT() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptSMALLINT.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"SMALLINT"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqINTEGER() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTEGER.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptBIGINT() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptBIGINT.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"BIGINT"));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptREAL() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptREAL.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"REAL"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptFLOAT() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptFLOAT.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"FLOAT"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqDOUBLE() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqDOUBLE.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"DOUBLE"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqDECIMAL_5_3.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"DECIMAL"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqVARCHAR_10.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptVARCHAR() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptVARCHAR.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqCHAR_5() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqCHAR_5.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptVARBINARY_16.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"BINARY VARYING"));
    }

    @Ignore(value="TODO(DRILL-3368): unignore when BINARY is implemented enough")
    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptBINARY_1048576() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptBINARY_65536.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"BINARY VARYING"));
        MatcherAssert.assertThat((Object)mdrOptBINARY_65536.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"BINARY"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqDATE() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqDATE.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"DATE"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqTIME() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqTIME.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"TIME"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptTIME_7() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptTIME_7.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"TIME"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptTIMESTAMP.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"TIMESTAMP"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_Y.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"INTERVAL"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqINTERVAL_H_S3() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_3H_S1.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"INTERVAL"));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DATA_TYPE_hasRightValue_tdbARRAY() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqARRAY.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"ARRAY"));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DATA_TYPE_hasRightValue_tbdMAP() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqMAP.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"MAP"));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DATA_TYPE_hasRightValue_tbdSTRUCT() throws SQLException {
        MatcherAssert.assertThat((Object)mdrUnkSTRUCT.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"STRUCT"));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DATA_TYPE_hasRightValue_tbdUnion() throws SQLException {
        MatcherAssert.assertThat((Object)mdrUnkUnion.getString("DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"OTHER"));
        Assert.fail((String)"Expected value is not resolved yet.");
    }

    @Test
    public void test_DATA_TYPE_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(8), (Matcher)CoreMatchers.equalTo((Object)"DATA_TYPE"));
    }

    @Test
    public void test_DATA_TYPE_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(8), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_DATA_TYPE_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(8), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Ignore(value="until resolved:  any requirement on nullability (DRILL-2420?)")
    @Test
    public void test_DATA_TYPE_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(8), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(9), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER_MAXIMUM_LENGTH"));
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBOOLEAN, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrReqTINYINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqTINYINT, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrOptSMALLINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptSMALLINT, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrReqINTEGER() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTEGER, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrOptBIGINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBIGINT, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrOptREAL() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptREAL, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrOptFLOAT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptFLOAT, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrReqDOUBLE() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDOUBLE, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDECIMAL_5_3, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqVARCHAR_10, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrOptVARCHAR() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptVARCHAR, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.equalTo((Object)65535));
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrReqCHAR_5() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqCHAR_5, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptVARBINARY_16, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.equalTo((Object)16));
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrOptBINARY_1048576() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBINARY_65536, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.equalTo((Object)65536));
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrReqDATE() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDATE, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrReqTIME() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqTIME, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrOptTIME_7() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptTIME_7, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptTIMESTAMP, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Y, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_mdrReqINTERVAL_H_S3() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_tdbARRAY() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_tbdMAP() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqMAP, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_tbdSTRUCT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightValue_tbdUnion() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkUnion, "CHARACTER_MAXIMUM_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(9), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER_MAXIMUM_LENGTH"));
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(9), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(9), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_CHARACTER_MAXIMUM_LENGTH_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(9), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(10), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER_OCTET_LENGTH"));
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBOOLEAN, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrReqTINYINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqTINYINT, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrOptBIGINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptREAL, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrOptSMALLINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptSMALLINT, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrReqINTEGER() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTEGER, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrOptREAL() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptREAL, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrOptFLOAT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptFLOAT, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrReqDOUBLE() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDOUBLE, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDECIMAL_5_3, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqVARCHAR_10, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.equalTo((Object)40));
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrOptVARCHAR() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptVARCHAR, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.equalTo((Object)262140));
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrReqCHAR_5() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqCHAR_5, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.equalTo((Object)20));
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptVARBINARY_16, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.equalTo((Object)16));
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrOptBINARY_1048576() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBINARY_65536, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.equalTo((Object)65536));
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrReqDATE() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDATE, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrReqTIME() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqTIME, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrOptTIME_7() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptTIME_7, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptTIMESTAMP, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Y, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_mdrReqINTERVAL_H_S3() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_tdbARRAY() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_tbdMAP() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqMAP, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_tbdSTRUCT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_CHARACTER_OCTET_LENGTH_hasRightValue_tbdUnion() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkUnion, "CHARACTER_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(10), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER_OCTET_LENGTH"));
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(10), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(10), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_CHARACTER_OCTET_LENGTH_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(10), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_NUMERIC_PRECISION_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(11), (Matcher)CoreMatchers.equalTo((Object)"NUMERIC_PRECISION"));
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBOOLEAN, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrReqTINYINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqTINYINT, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)8));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrOptSMALLINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptSMALLINT, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)16));
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrReqINTEGER() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTEGER, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)32));
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrOptBIGINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBIGINT, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)64));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrOptREAL() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptREAL, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)24));
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrOptFLOAT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptFLOAT, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)24));
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrReqDOUBLE() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDOUBLE, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)53));
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDECIMAL_5_3, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqVARCHAR_10, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrOptVARCHAR() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptVARCHAR, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrReqCHAR_5() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqCHAR_5, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptVARBINARY_16, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrOptBINARY_1048576() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBINARY_65536, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrReqDATE() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDATE, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrReqTIME() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqTIME, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrOptTIME_7() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptTIME_7, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptTIMESTAMP, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Y, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightValue_mdrReqINTERVAL_H_S3() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUMERIC_PRECISION_hasRightValue_tdbARRAY() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUMERIC_PRECISION_hasRightValue_tbdMAP() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqMAP, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUMERIC_PRECISION_hasRightValue_tbdSTRUCT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUMERIC_PRECISION_hasRightValue_tbdUnion() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkUnion, "NUMERIC_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(11), (Matcher)CoreMatchers.equalTo((Object)"NUMERIC_PRECISION"));
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(11), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(11), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_NUMERIC_PRECISION_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(11), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(12), (Matcher)CoreMatchers.equalTo((Object)"NUMERIC_PRECISION_RADIX"));
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBOOLEAN, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrReqTINYINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqTINYINT, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrOptSMALLINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptSMALLINT, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrReqINTEGER() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTEGER, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrOptBIGINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBIGINT, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrOptREAL() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptREAL, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrOptFLOAT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptFLOAT, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrReqDOUBLE() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDOUBLE, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDECIMAL_5_3, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqVARCHAR_10, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrOptVARCHAR() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptVARCHAR, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrReqCHAR_5() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqCHAR_5, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptVARBINARY_16, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrOptBINARY_1048576() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBINARY_65536, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrReqDATE() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDATE, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrReqTIME() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqTIME, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrOptTIME_7() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptTIME_7, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptTIMESTAMP, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Y, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_mdrReqINTERVAL_H_S3() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_tdbARRAY() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_tbdMAP() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqMAP, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_tbdSTRUCT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUMERIC_PRECISION_RADIX_hasRightValue_tbdUnion() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkUnion, "NUMERIC_PRECISION_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(12), (Matcher)CoreMatchers.equalTo((Object)"NUMERIC_PRECISION_RADIX"));
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(12), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(12), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_NUMERIC_PRECISION_RADIX_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(12), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_NUMERIC_SCALE_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(13), (Matcher)CoreMatchers.equalTo((Object)"NUMERIC_SCALE"));
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBOOLEAN, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrReqTINYINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqTINYINT, "NUMERIC_SCALE"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrOptSMALLINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptSMALLINT, "NUMERIC_SCALE"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrReqINTEGER() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTEGER, "NUMERIC_SCALE"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrOptBIGINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBIGINT, "NUMERIC_SCALE"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrOptREAL() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptREAL, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrOptFLOAT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptFLOAT, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrReqDOUBLE() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDOUBLE, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDECIMAL_5_3, "NUMERIC_SCALE"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqVARCHAR_10, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrOptVARCHAR() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptVARCHAR, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrReqCHAR_5() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqCHAR_5, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptVARBINARY_16, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrOptBINARY_1048576() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBINARY_65536, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrReqDATE() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDATE, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrReqTIME() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqTIME, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrOptTIME_7() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptTIME_7, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptTIMESTAMP, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Y, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightValue_mdrReqINTERVAL_H_S3() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUMERIC_SCALE_hasRightValue_tdbARRAY() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUMERIC_SCALE_hasRightValue_tbdMAP() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqMAP, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUMERIC_SCALE_hasRightValue_tbdSTRUCT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUMERIC_SCALE_hasRightValue_tbdUnion() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkUnion, "NUMERIC_SCALE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUMERIC_SCALE_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(13), (Matcher)CoreMatchers.equalTo((Object)"NUMERIC_SCALE"));
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(13), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(13), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_NUMERIC_SCALE_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(13), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_DATETIME_PRECISION_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(14), (Matcher)CoreMatchers.equalTo((Object)"DATETIME_PRECISION"));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBOOLEAN, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqTINYINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqTINYINT, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrOptSMALLINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptSMALLINT, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTEGER() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTEGER, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrOptBIGINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBIGINT, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrOptREAL() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptREAL, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrOptFLOAT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptFLOAT, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqDOUBLE() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDOUBLE, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDECIMAL_5_3, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqVARCHAR_10, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrOptVARCHAR() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptVARCHAR, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqCHAR_5() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqCHAR_5, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptVARBINARY_16, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrOptBINARY_1048576() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBINARY_65536, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqDATE() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDATE, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqTIME() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqTIME, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Ignore(value="TODO(DRILL-3225): unignore when datetime precision is implemented")
    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrOptTIME_7() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptTIME_7, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)7));
    }

    @Test
    @Ignore(value="TODO(DRILL-3225): unignore when datetime precision is implemented")
    public void test_DATETIME_PRECISION_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptTIMESTAMP, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Y, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTERVAL_3Y_Mo() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3Y_Mo, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTERVAL_Mo() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Mo, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTERVAL_D() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_D, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTERVAL_4D_H() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_4D_H, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTERVAL_3D_Mi() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3D_Mi, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTERVAL_2D_S5() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_2D_S5, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Ignore(value="Ignored after Calcite update")
    @Test
    public void test_DATETIME_PRECISION_hasINTERIMValue_mdrReqINTERVAL_2D_S5() throws SQLException {
        MatcherAssert.assertThat((String)"When DRILL-3244 fixed, un-ignore above method and purge this.", (Object)this.getIntOrNull(mdrReqINTERVAL_2D_S5, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTERVAL_H() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_H, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTERVAL_1H_Mi() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_1H_Mi, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTERVAL_H_S3() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Ignore(value="Ignored after Calcite update")
    @Test
    public void test_DATETIME_PRECISION_hasINTERIMValue_mdrReqINTERVAL_H_S3() throws SQLException {
        MatcherAssert.assertThat((String)"When DRILL-3244 fixed, un-ignore above method and purge this.", (Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTERVAL_Mi() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Mi, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTERVAL_5Mi_S() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_5Mi_S, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTERVAL_S() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_S, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTERVAL_3S() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3S, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightValue_mdrReqINTERVAL_3S1() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3S1, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Ignore(value="Ignored after Calcite update")
    @Test
    public void test_DATETIME_PRECISION_hasINTERIMValue_mdrReqINTERVAL_3S1() throws SQLException {
        MatcherAssert.assertThat((String)"When DRILL-3244 fixed, un-ignore above method and purge this.", (Object)this.getIntOrNull(mdrReqINTERVAL_3S1, "DATETIME_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DATETIME_PRECISION_hasRightValue_tdbARRAY() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DATETIME_PRECISION_hasRightValue_tbdMAP() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqMAP, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DATETIME_PRECISION_hasRightValue_tbdSTRUCT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DATETIME_PRECISION_hasRightValue_tbdUnion() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkUnion, "DATETIME_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DATETIME_PRECISION_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(14), (Matcher)CoreMatchers.equalTo((Object)"DATETIME_PRECISION"));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(14), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(14), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_DATETIME_PRECISION_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(14), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_INTERVAL_TYPE_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(15), (Matcher)CoreMatchers.equalTo((Object)"INTERVAL_TYPE"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptBOOLEAN.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqTINYINT() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqTINYINT.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrOptSMALLINT() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptSMALLINT.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTEGER() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTEGER.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrOptBIGINT() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptBIGINT.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrOptREAL() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptREAL.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrOptFLOAT() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptFLOAT.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqDOUBLE() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqDOUBLE.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqDECIMAL_5_3.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqVARCHAR_10.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrOptVARCHAR() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptVARCHAR.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqCHAR_5() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqCHAR_5.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptVARBINARY_16.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrOptBINARY_1048576() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptBINARY_65536.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqDATE() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqDATE.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqTIME() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqTIME.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrOptTIME_7() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptTIME_7.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        MatcherAssert.assertThat((Object)mdrOptTIMESTAMP.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_Y.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"YEAR"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_3Y_Mo() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_3Y_Mo.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"YEAR TO MONTH"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_2Mo() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_Mo.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"MONTH"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_D() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_D.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"DAY"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_4D_H() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_4D_H.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"DAY TO HOUR"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_3D_Mi() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_3D_Mi.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"DAY TO MINUTE"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_H_S3() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_3H_S1.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"HOUR TO SECOND"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_2D_S5() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_2D_S5.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"DAY TO SECOND"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_H() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_H.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"HOUR"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_1H_Mi() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_1H_Mi.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"HOUR TO MINUTE"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_3H_S1() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_3H_S1.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"HOUR TO SECOND"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_Mi() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_Mi.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"MINUTE"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_5Mi_S() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_5Mi_S.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"MINUTE TO SECOND"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_S() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_S.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"SECOND"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_3S() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_3S.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"SECOND"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightValue_mdrReqINTERVAL_3S1() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqINTERVAL_3S1.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.equalTo((Object)"SECOND"));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_INTERVAL_TYPE_hasRightValue_tdbARRAY() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqARRAY.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_INTERVAL_TYPE_hasRightValue_tbdMAP() throws SQLException {
        MatcherAssert.assertThat((Object)mdrReqMAP.getString("INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_INTERVAL_TYPE_hasRightValue_tbdSTRUCT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_INTERVAL_TYPE_hasRightValue_tbdUnion() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkUnion, "INTERVAL_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_TYPE_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(15), (Matcher)CoreMatchers.equalTo((Object)"INTERVAL_TYPE"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(15), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(15), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_INTERVAL_TYPE_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(15), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_INTERVAL_PRECISION_isAtRightPosition() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnLabel(16), (Matcher)CoreMatchers.equalTo((Object)"INTERVAL_PRECISION"));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBOOLEAN, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqTINYINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqTINYINT, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrOptSMALLINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptSMALLINT, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTEGER() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTEGER, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrOptBIGINT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBIGINT, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrOptREAL() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptREAL, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrOptFLOAT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptFLOAT, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqDOUBLE() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDOUBLE, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDECIMAL_5_3, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqVARCHAR_10, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrOptVARCHAR() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptVARCHAR, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqCHAR_5() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqCHAR_5, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptVARBINARY_16, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrOptBINARY_1048576() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptBINARY_65536, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqDATE() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqDATE, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqTIME() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqTIME, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrOptTIME_7() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptTIME_7, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrOptTIMESTAMP, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Y, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTERVAL_3Y_Mo() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3Y_Mo, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTERVAL_2Mo() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Mo, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTERVAL_D() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_D, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTERVAL_4D_H() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_4D_H, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTERVAL_3D_Mi() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3D_Mi, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTERVAL_2D_S5() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_2D_S5, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTERVAL_H() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_H, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTERVAL_1H_Mi() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_1H_Mi, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTERVAL_3H_S1() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTERVAL_Mi() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Mi, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTERVAL_5Mi_S() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_5Mi_S, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTERVAL_S() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_S, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTERVAL_3S() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3S, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightValue_mdrReqINTERVAL_3S1() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3S1, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_INTERVAL_PRECISION_hasRightValue_tdbARRAY() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_INTERVAL_PRECISION_hasRightValue_tbdMAP() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrReqMAP, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_INTERVAL_PRECISION_hasRightValue_tbdSTRUCT() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_INTERVAL_PRECISION_hasRightValue_tbdUnion() throws SQLException {
        MatcherAssert.assertThat((Object)this.getIntOrNull(mdrUnkUnion, "INTERVAL_PRECISION"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_INTERVAL_PRECISION_hasSameNameAndLabel() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnName(16), (Matcher)CoreMatchers.equalTo((Object)"INTERVAL_PRECISION"));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightTypeString() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnTypeName(16), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightTypeCode() throws SQLException {
        MatcherAssert.assertThat((Object)rowsMetadata.getColumnType(16), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_INTERVAL_PRECISION_hasRightNullability() throws SQLException {
        MatcherAssert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(16), (Matcher)CoreMatchers.equalTo((Object)1));
    }
}

