/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.SQLException;
import org.apache.calcite.avatica.AvaticaResultSetMetaData;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.Meta;
import org.apache.drill.jdbc.AlreadyClosedSqlException;
import org.apache.drill.jdbc.InvalidParameterSqlException;

public class DrillResultSetMetaDataImpl
extends AvaticaResultSetMetaData {
    private final AvaticaStatement statement;

    public DrillResultSetMetaDataImpl(AvaticaStatement statement, Object query, Meta.Signature signature) {
        super(statement, query, signature);
        this.statement = statement;
    }

    private void checkOpen() throws AlreadyClosedSqlException, SQLException {
        if (this.statement.isClosed() || this.statement.getResultSet() != null && this.statement.getResultSet().isClosed()) {
            throw new AlreadyClosedSqlException("ResultSetMetaData's ResultSet is already closed.");
        }
    }

    private void throwIfClosedOrOutOfBounds(int columnNumber) throws SQLException {
        this.checkOpen();
        if (1 > columnNumber || columnNumber > this.getColumnCount()) {
            throw new InvalidParameterSqlException("Column number " + columnNumber + " out of range of from 1 through " + this.getColumnCount() + " (column count)");
        }
    }

    public int getColumnCount() throws SQLException {
        this.checkOpen();
        return super.getColumnCount();
    }

    public boolean isAutoIncrement(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isAutoIncrement(columnNumber);
    }

    public boolean isCaseSensitive(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isCaseSensitive(columnNumber);
    }

    public boolean isSearchable(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isSearchable(columnNumber);
    }

    public boolean isCurrency(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isCurrency(columnNumber);
    }

    public int isNullable(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isNullable(columnNumber);
    }

    public boolean isSigned(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isSigned(columnNumber);
    }

    public int getColumnDisplaySize(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getColumnDisplaySize(columnNumber);
    }

    public String getColumnLabel(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getColumnLabel(columnNumber);
    }

    public String getColumnName(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getColumnName(columnNumber);
    }

    public String getSchemaName(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getSchemaName(columnNumber);
    }

    public int getPrecision(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getPrecision(columnNumber);
    }

    public int getScale(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getScale(columnNumber);
    }

    public String getTableName(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getTableName(columnNumber);
    }

    public String getCatalogName(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getCatalogName(columnNumber);
    }

    public int getColumnType(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getColumnType(columnNumber);
    }

    public String getColumnTypeName(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getColumnTypeName(columnNumber);
    }

    public boolean isReadOnly(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isReadOnly(columnNumber);
    }

    public boolean isWritable(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isWritable(columnNumber);
    }

    public boolean isDefinitelyWritable(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.isDefinitelyWritable(columnNumber);
    }

    public String getColumnClassName(int columnNumber) throws SQLException {
        this.throwIfClosedOrOutOfBounds(columnNumber);
        return super.getColumnClassName(columnNumber);
    }
}

