/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.apache.drill.test.TestTools;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={JdbcTest.class})
public class Drill2128GetColumnsDataTypeNotTypeCodeIntBugsTest
extends JdbcTestBase {
    private static Connection connection;
    private static DatabaseMetaData dbMetadata;
    @Rule
    public final TestRule TIMEOUT = TestTools.getTimeoutRule((int)120000);

    @BeforeClass
    public static void setUpConnection() throws Exception {
        Driver.load();
        connection = DriverManager.getConnection("jdbc:drill:zk=local");
        dbMetadata = connection.getMetaData();
    }

    @AfterClass
    public static void tearDownConnection() throws SQLException {
        connection.close();
    }

    @Test
    public void testColumn_DATA_TYPE_isInteger() throws Exception {
        ResultSet columns = dbMetadata.getColumns(null, null, null, null);
        Assert.assertTrue((String)"DatabaseMetaData.getColumns(...) returned no rows", (boolean)columns.next());
        do {
            int typeCode1 = columns.getInt("DATA_TYPE");
            MatcherAssert.assertThat((String)"Column 5's label", (Object)columns.getMetaData().getColumnLabel(5), (Matcher)CoreMatchers.equalTo((Object)"DATA_TYPE"));
            int typeCode2 = columns.getInt(5);
            MatcherAssert.assertThat((String)"getInt( 5 ) (expected to be same as getInt( \"DATA_TYPE\" ))", (Object)typeCode2, (Matcher)CoreMatchers.equalTo((Object)typeCode1));
            MatcherAssert.assertThat((Object)typeCode1, (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)2003), CoreMatchers.equalTo((Object)-5), CoreMatchers.equalTo((Object)-2), CoreMatchers.equalTo((Object)-7), CoreMatchers.equalTo((Object)2004), CoreMatchers.equalTo((Object)16), CoreMatchers.equalTo((Object)1), CoreMatchers.equalTo((Object)2005), CoreMatchers.equalTo((Object)70), CoreMatchers.equalTo((Object)91), CoreMatchers.equalTo((Object)3), CoreMatchers.equalTo((Object)2001), CoreMatchers.equalTo((Object)8), CoreMatchers.equalTo((Object)6), CoreMatchers.equalTo((Object)4), CoreMatchers.equalTo((Object)2000), CoreMatchers.equalTo((Object)-16), CoreMatchers.equalTo((Object)-4), CoreMatchers.equalTo((Object)-1), CoreMatchers.equalTo((Object)-15), CoreMatchers.equalTo((Object)2011), CoreMatchers.equalTo((Object)2), CoreMatchers.equalTo((Object)-9), CoreMatchers.equalTo((Object)1111), CoreMatchers.equalTo((Object)7), CoreMatchers.equalTo((Object)2006), CoreMatchers.equalTo((Object)-8), CoreMatchers.equalTo((Object)5), CoreMatchers.equalTo((Object)2009), CoreMatchers.equalTo((Object)2002), CoreMatchers.equalTo((Object)92), CoreMatchers.equalTo((Object)93), CoreMatchers.equalTo((Object)-6), CoreMatchers.equalTo((Object)-3), CoreMatchers.equalTo((Object)12)}));
        } while (columns.next());
    }

    @Test
    public void testColumn_TYPE_NAME_isString() throws Exception {
        ResultSet columns = dbMetadata.getColumns(null, "INFORMATION_SCHEMA", "COLUMNS", "ORDINAL_POSITION");
        Assert.assertTrue((String)"DatabaseMetaData.getColumns(...) returned no rows", (boolean)columns.next());
        String typeName1 = columns.getString("TYPE_NAME");
        MatcherAssert.assertThat((String)"getString( \"TYPE_NAME\" )", (Object)typeName1, (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
        try {
            int unexpected = columns.getInt("TYPE_NAME");
            Assert.fail((String)("getInt( \"TYPE_NAME\" ) didn't throw exception (and returned " + unexpected + ")"));
        }
        catch (SQLException unexpected) {
            // empty catch block
        }
        MatcherAssert.assertThat((String)"Column 6's label", (Object)columns.getMetaData().getColumnLabel(6), (Matcher)CoreMatchers.equalTo((Object)"TYPE_NAME"));
        String typeName2 = columns.getString(6);
        MatcherAssert.assertThat((String)"getString( 6 ) (expected to be same as getString( \"TYPE_NAME\" ))", (Object)typeName2, (Matcher)CoreMatchers.equalTo((Object)typeName1));
    }
}

