/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import com.google.common.base.Stopwatch;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.apache.drill.jdbc.DrillResultSet;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.apache.drill.test.TestTools;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTestQueryBase
extends JdbcTestBase {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTestQueryBase.class);
    @Rule
    public TestRule TIMEOUT = TestTools.getTimeoutRule((int)40000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void testQuery(String sql) throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean success = false;
        try (Connection conn = JdbcTestQueryBase.connect();){
            for (int x = 0; x < 1; ++x) {
                Stopwatch watch = Stopwatch.createStarted();
                Statement s = conn.createStatement();
                ResultSet r = s.executeQuery(sql);
                sb.append(String.format("QueryId: %s\n", r.unwrap(DrillResultSet.class).getQueryId()));
                boolean first = true;
                while (r.next()) {
                    int i;
                    ResultSetMetaData md = r.getMetaData();
                    if (first) {
                        for (i = 1; i <= md.getColumnCount(); ++i) {
                            sb.append(md.getColumnName(i));
                            sb.append('\t');
                        }
                        sb.append('\b');
                        first = false;
                    }
                    for (i = 1; i <= md.getColumnCount(); ++i) {
                        sb.append(r.getObject(i));
                        sb.append('\t');
                    }
                    sb.append('\n');
                }
                sb.append(String.format("Query completed in %d millis.\n", watch.elapsed(TimeUnit.MILLISECONDS)));
            }
            sb.append("\n\n\n");
            success = true;
        }
        finally {
            if (!success) {
                Thread.sleep(2000L);
            }
        }
        logger.info(sb.toString());
    }

    static {
        Driver.load();
    }
}

