/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.MissingResultsException;
import org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.client.ServerMethod;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.rpc.DrillRpcFuture;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.jdbc.impl.DrillColumnMetaDataList;
import org.apache.drill.jdbc.impl.DrillConnectionImpl;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillMetaImpl
extends MetaImpl {
    private static final Logger logger = LoggerFactory.getLogger(DrillMetaImpl.class);
    private static final int DECIMAL_DIGITS_REAL = 7;
    private static final int DECIMAL_DIGITS_FLOAT = 7;
    private static final int DECIMAL_DIGITS_DOUBLE = 15;
    private static final int RADIX_DATETIME = 10;
    private static final int RADIX_INTERVAL = 10;
    final DrillConnectionImpl connection;

    DrillMetaImpl(DrillConnectionImpl connection) {
        super((AvaticaConnection)connection);
        this.connection = connection;
    }

    private static Meta.Signature newSignature(String sql) {
        return new Meta.Signature((List)new DrillColumnMetaDataList(), sql, Collections.emptyList(), Collections.emptyMap(), null, Meta.StatementType.SELECT);
    }

    private Meta.MetaResultSet s(String s) {
        try {
            logger.debug("Running {}", (Object)s);
            AvaticaStatement statement = this.connection.createStatement();
            return Meta.MetaResultSet.create((String)this.connection.id, (int)statement.getId(), (boolean)true, (Meta.Signature)DrillMetaImpl.newSignature(s), null);
        }
        catch (Exception e) {
            throw new DrillRuntimeException("Failure while attempting to get DatabaseMetadata.", (Throwable)e);
        }
    }

    private static UserProtos.LikeFilter newLikeFilter(Meta.Pat pattern) {
        if (pattern == null || pattern.s == null) {
            return null;
        }
        return UserProtos.LikeFilter.newBuilder().setPattern(pattern.s).setEscape("\\").build();
    }

    private static Meta.Pat quote(String v) {
        if (v == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(v.length());
        block3: for (int index = 0; index < v.length(); ++index) {
            char c = v.charAt(index);
            switch (c) {
                case '%': 
                case '\\': 
                case '_': {
                    sb.append('\\').append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return Meta.Pat.of((String)sb.toString());
    }

    protected static ColumnMetaData.StructType drillFieldMetaData(Class<?> clazz) {
        ArrayList<ColumnMetaData> list = new ArrayList<ColumnMetaData>();
        for (Field field : clazz.getFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            NotNull notNull = field.getAnnotation(NotNull.class);
            boolean notNullable = notNull != null || field.getType().isPrimitive();
            list.add(DrillMetaImpl.drillColumnMetaData(AvaticaUtils.camelToUpper((String)field.getName()), list.size(), field.getType(), notNullable));
        }
        return ColumnMetaData.struct(list);
    }

    protected static ColumnMetaData drillColumnMetaData(String name, int index, Class<?> type, boolean notNullable) {
        TypeInfo pair = TypeInfo.get(type);
        ColumnMetaData.Rep rep = (ColumnMetaData.Rep)ColumnMetaData.Rep.VALUE_MAP.get(type);
        ColumnMetaData.ScalarType scalarType = ColumnMetaData.scalar((int)pair.sqlType, (String)pair.sqlTypeName, (ColumnMetaData.Rep)rep);
        return new ColumnMetaData(index, false, true, false, false, notNullable ? 0 : 1, true, -1, name, name, null, 0, 0, null, null, (ColumnMetaData.AvaticaType)scalarType, true, false, false, scalarType.columnClassName());
    }

    private Meta.MetaResultSet clientGetTables(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) {
        StringBuilder sb = new StringBuilder();
        sb.append("select TABLE_CATALOG as TABLE_CAT, TABLE_SCHEMA as TABLE_SCHEM, TABLE_NAME, TABLE_TYPE, '' as REMARKS, '' as TYPE_CAT, '' as TYPE_SCHEM, '' as TYPE_NAME, '' as SELF_REFERENCING_COL_NAME, '' as REF_GENERATION FROM INFORMATION_SCHEMA.`TABLES` WHERE 1=1 ");
        if (catalog != null) {
            sb.append(" AND TABLE_CATALOG = '" + DrillStringUtils.escapeSql((String)catalog) + "' ");
        }
        if (schemaPattern.s != null) {
            sb.append(" AND TABLE_SCHEMA like '" + DrillStringUtils.escapeSql((String)schemaPattern.s) + "'");
        }
        if (tableNamePattern.s != null) {
            sb.append(" AND TABLE_NAME like '" + DrillStringUtils.escapeSql((String)tableNamePattern.s) + "'");
        }
        if (typeList != null && typeList.size() > 0) {
            sb.append("AND (");
            for (int t = 0; t < typeList.size(); ++t) {
                if (t != 0) {
                    sb.append(" OR ");
                }
                sb.append(" TABLE_TYPE LIKE '" + DrillStringUtils.escapeSql((String)typeList.get(t)) + "' ");
            }
            sb.append(")");
        }
        sb.append(" ORDER BY TABLE_TYPE, TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME");
        return this.s(sb.toString());
    }

    private Meta.MetaResultSet serverGetTables(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) {
        UserProtos.LikeFilter catalogNameFilter = DrillMetaImpl.newLikeFilter(DrillMetaImpl.quote(catalog));
        UserProtos.LikeFilter schemaNameFilter = DrillMetaImpl.newLikeFilter(schemaPattern);
        UserProtos.LikeFilter tableNameFilter = DrillMetaImpl.newLikeFilter(tableNamePattern);
        return new MetadataAdapter<MetaImpl.MetaTable, UserProtos.GetTablesResp, UserProtos.TableMetadata>(MetaImpl.MetaTable.class){

            @Override
            protected UserProtos.RequestStatus getStatus(UserProtos.GetTablesResp response) {
                return response.getStatus();
            }

            @Override
            protected UserBitShared.DrillPBError getError(UserProtos.GetTablesResp response) {
                return response.getError();
            }

            @Override
            protected List<UserProtos.TableMetadata> getResult(UserProtos.GetTablesResp response) {
                return response.getTablesList();
            }

            @Override
            protected MetaImpl.MetaTable adapt(UserProtos.TableMetadata protoValue) {
                return new MetaImpl.MetaTable(protoValue.getCatalogName(), protoValue.getSchemaName(), protoValue.getTableName(), protoValue.getType());
            }
        }.getMeta(this.connection.getClient().getTables(catalogNameFilter, schemaNameFilter, tableNameFilter, typeList));
    }

    public Meta.MetaResultSet getTables(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) {
        if (this.connection.getConfig().isServerMetadataDisabled() || !this.connection.getClient().getSupportedMethods().contains(ServerMethod.GET_TABLES)) {
            return this.clientGetTables(catalog, schemaPattern, tableNamePattern, typeList);
        }
        return this.serverGetTables(catalog, schemaPattern, tableNamePattern, typeList);
    }

    private Meta.MetaResultSet clientGetColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT \n  TABLE_CATALOG                 as  TABLE_CAT, \n  TABLE_SCHEMA                  as  TABLE_SCHEM, \n  TABLE_NAME                    as  TABLE_NAME, \n  COLUMN_NAME                   as  COLUMN_NAME, \n  CASE DATA_TYPE \n    WHEN 'ARRAY'                       THEN 2003\n    WHEN 'BIGINT'                      THEN -5\n    WHEN 'BINARY'                      THEN -2\n    WHEN 'BINARY LARGE OBJECT'         THEN 2004\n    WHEN 'BINARY VARYING'              THEN -3\n    WHEN 'BIT'                         THEN -7\n    WHEN 'BOOLEAN'                     THEN 16\n    WHEN 'CHARACTER'                   THEN 1\n    WHEN 'CHARACTER LARGE OBJECT'      THEN 2005\n    WHEN 'CHARACTER VARYING'           THEN 12\n    WHEN 'DATALINK'                    THEN 70\n    WHEN 'DATE'                        THEN 91\n    WHEN 'DECIMAL'                     THEN 3\n    WHEN 'DISTINCT'                    THEN 2001\n    WHEN 'DOUBLE', 'DOUBLE PRECISION'  THEN 8\n    WHEN 'FLOAT'                       THEN 6\n    WHEN 'INTEGER'                     THEN 4\n    WHEN 'INTERVAL'                    THEN 1111\n    WHEN 'JAVA_OBJECT'                 THEN 2000\n    WHEN 'LONGNVARCHAR'                THEN -16\n    WHEN 'LONGVARBINARY'               THEN -4\n    WHEN 'LONGVARCHAR'                 THEN -1\n    WHEN 'MAP'                         THEN 1111\n    WHEN 'NATIONAL CHARACTER'          THEN -15\n    WHEN 'NATIONAL CHARACTER LARGE OBJECT' \n                                       THEN 2011\n    WHEN 'NULL'                        THEN 0\n    WHEN 'NUMERIC'                     THEN 2\n    WHEN 'NATIONAL CHARACTER'          THEN -15\n    WHEN 'NATIONAL CHARACTER VARYING'  THEN -9\n    WHEN 'OTHER'                       THEN 1111\n    WHEN 'REAL'                        THEN 7\n    WHEN 'REF'                         THEN 2006\n    WHEN 'ROWID'                       THEN -8\n    WHEN 'SMALLINT'                    THEN 5\n    WHEN 'SQLXML'                      THEN 2009\n    WHEN 'STRUCT'                      THEN 2002\n    WHEN 'TIME'                        THEN 92\n    WHEN 'TIMESTAMP'                   THEN 93\n    WHEN 'TINYINT'                     THEN -6\n    ELSE                                    1111\n  END                                    as  DATA_TYPE, \n  DATA_TYPE                     as  TYPE_NAME, \n  CASE DATA_TYPE \n    WHEN 'BOOLEAN', 'BIT'\n                         THEN 1 \n    WHEN 'TINYINT', 'SMALLINT', 'INTEGER', 'BIGINT', \n         'DECIMAL', 'NUMERIC', \n         'REAL', 'FLOAT', 'DOUBLE' \n                         THEN NUMERIC_PRECISION \n    WHEN 'CHARACTER', 'CHARACTER VARYING' \n                         THEN CHARACTER_MAXIMUM_LENGTH \n    WHEN 'DATE'          THEN 10 \n    WHEN 'TIME'          THEN \n      CASE \n        WHEN DATETIME_PRECISION > 0 \n                         THEN          8 + 1 + DATETIME_PRECISION\n        ELSE                           8\n      END \n    WHEN 'TIMESTAMP'     THEN \n      CASE \n        WHEN DATETIME_PRECISION > 0                            THEN 10 + 1 + 8 + 1 + DATETIME_PRECISION\n        ELSE                  10 + 1 + 8\n      END \n    WHEN 'INTERVAL'      THEN \n      INTERVAL_PRECISION \n      + \n      CASE INTERVAL_TYPE \n        WHEN 'YEAR', 'MONTH', 'DAY' THEN 2 \n        WHEN 'HOUR', 'MINUTE'       THEN 3 \n        WHEN 'YEAR TO MONTH'        THEN 5 \n        WHEN 'DAY TO HOUR'          THEN 6 \n        WHEN 'HOUR TO MINUTE'       THEN 6 \n        WHEN 'DAY TO MINUTE'        THEN 9 \n        ELSE \n          CASE INTERVAL_TYPE \n            WHEN 'DAY TO SECOND'    THEN 12 \n            WHEN 'HOUR TO SECOND'   THEN  9 \n            WHEN 'MINUTE TO SECOND' THEN  6 \n            WHEN 'SECOND'           THEN  3 \n            ELSE \n                                    0-INTERVAL_PRECISION - 1 \n          END \n          + \n          DATETIME_PRECISION\n          + \n          CASE \n            WHEN DATETIME_PRECISION > 0 THEN 1\n            ELSE                             0 \n          END\n      END \n    WHEN 'BINARY', 'BINARY VARYING' \n                         THEN CHARACTER_MAXIMUM_LENGTH \n    ELSE                      NULL \n  END                                    as  COLUMN_SIZE, \n  CHARACTER_MAXIMUM_LENGTH      as  BUFFER_LENGTH, \n  CASE  DATA_TYPE\n    WHEN 'TINYINT', 'SMALLINT', 'INTEGER', 'BIGINT', \n         'DECIMAL', 'NUMERIC'        THEN NUMERIC_SCALE \n    WHEN 'REAL'                      THEN 7\n    WHEN 'FLOAT'                     THEN 7\n    WHEN 'DOUBLE'                    THEN 15\n    WHEN 'DATE', 'TIME', 'TIMESTAMP' THEN DATETIME_PRECISION \n    WHEN 'INTERVAL'                  THEN DATETIME_PRECISION \n  END                                    as  DECIMAL_DIGITS, \n  CASE DATA_TYPE \n    WHEN 'TINYINT', 'SMALLINT', 'INTEGER', 'BIGINT', \n         'DECIMAL', 'NUMERIC', \n         'REAL', 'FLOAT', 'DOUBLE'   THEN NUMERIC_PRECISION_RADIX \n    WHEN 'INTERVAL'                  THEN 10\n    WHEN 'DATE', 'TIME', 'TIMESTAMP' THEN 10\n    ELSE                                  NULL\n  END                                    as  NUM_PREC_RADIX, \n  CASE IS_NULLABLE \n    WHEN 'YES'      THEN 1\n    WHEN 'NO'       THEN 0\n    WHEN ''         THEN 2\n    ELSE                 -1\n  END                                    as  NULLABLE, \n  CAST( NULL as VARCHAR )       as  REMARKS, \n  COLUMN_DEFAULT                as  COLUMN_DEF, \n  0                             as  SQL_DATA_TYPE, \n  0                             as  SQL_DATETIME_SUB, \n  CASE DATA_TYPE\n    WHEN 'CHARACTER', \n         'CHARACTER VARYING', \n         'NATIONAL CHARACTER', \n         'NATIONAL CHARACTER VARYING' \n                                 THEN CHARACTER_OCTET_LENGTH \n    ELSE                              NULL \n  END                                    as  CHAR_OCTET_LENGTH, \n  ORDINAL_POSITION              as  ORDINAL_POSITION, \n  IS_NULLABLE                   as  IS_NULLABLE, \n  CAST( NULL as VARCHAR )       as  SCOPE_CATALOG, \n  CAST( NULL as VARCHAR )       as  SCOPE_SCHEMA, \n  CAST( NULL as VARCHAR )       as  SCOPE_TABLE, \n  CAST( NULL as INTEGER )       as  SOURCE_DATA_TYPE, \n  ''                            as  IS_AUTOINCREMENT, \n  ''                            as  IS_GENERATEDCOLUMN \n  FROM INFORMATION_SCHEMA.COLUMNS \n  WHERE 1=1 ");
        if (catalog != null) {
            sb.append("\n  AND TABLE_CATALOG = '" + DrillStringUtils.escapeSql((String)catalog) + "'");
        }
        if (schemaPattern.s != null) {
            sb.append("\n  AND TABLE_SCHEMA like '" + DrillStringUtils.escapeSql((String)schemaPattern.s) + "'");
        }
        if (tableNamePattern.s != null) {
            sb.append("\n  AND TABLE_NAME like '" + DrillStringUtils.escapeSql((String)tableNamePattern.s) + "'");
        }
        if (columnNamePattern.s != null) {
            sb.append("\n  AND COLUMN_NAME like '" + DrillStringUtils.escapeSql((String)columnNamePattern.s) + "'");
        }
        sb.append("\n ORDER BY TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME");
        return this.s(sb.toString());
    }

    private Meta.MetaResultSet serverGetColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        UserProtos.LikeFilter catalogNameFilter = DrillMetaImpl.newLikeFilter(DrillMetaImpl.quote(catalog));
        UserProtos.LikeFilter schemaNameFilter = DrillMetaImpl.newLikeFilter(schemaPattern);
        UserProtos.LikeFilter tableNameFilter = DrillMetaImpl.newLikeFilter(tableNamePattern);
        UserProtos.LikeFilter columnNameFilter = DrillMetaImpl.newLikeFilter(columnNamePattern);
        return new MetadataAdapter<MetaColumn, UserProtos.GetColumnsResp, UserProtos.ColumnMetadata>(MetaColumn.class){

            @Override
            protected UserProtos.RequestStatus getStatus(UserProtos.GetColumnsResp response) {
                return response.getStatus();
            }

            @Override
            protected UserBitShared.DrillPBError getError(UserProtos.GetColumnsResp response) {
                return response.getError();
            }

            @Override
            protected List<UserProtos.ColumnMetadata> getResult(UserProtos.GetColumnsResp response) {
                return response.getColumnsList();
            }

            private int getDataType(UserProtos.ColumnMetadata value) {
                switch (value.getDataType()) {
                    case "ARRAY": {
                        return 2003;
                    }
                    case "BIGINT": {
                        return -5;
                    }
                    case "BINARY": {
                        return -2;
                    }
                    case "BINARY LARGE OBJECT": {
                        return 2004;
                    }
                    case "BINARY VARYING": {
                        return -3;
                    }
                    case "BIT": {
                        return -7;
                    }
                    case "BOOLEAN": {
                        return 16;
                    }
                    case "CHARACTER": {
                        return 1;
                    }
                    case "CHARACTER LARGE OBJECT": {
                        return 2005;
                    }
                    case "CHARACTER VARYING": {
                        return 12;
                    }
                    case "DATALINK": {
                        return 70;
                    }
                    case "DATE": {
                        return 91;
                    }
                    case "DECIMAL": {
                        return 3;
                    }
                    case "DISTINCT": {
                        return 2001;
                    }
                    case "DOUBLE": 
                    case "DOUBLE PRECISION": {
                        return 8;
                    }
                    case "FLOAT": {
                        return 6;
                    }
                    case "INTEGER": {
                        return 4;
                    }
                    case "INTERVAL": {
                        return 1111;
                    }
                    case "JAVA_OBJECT": {
                        return 2000;
                    }
                    case "LONGNVARCHAR": {
                        return -16;
                    }
                    case "LONGVARBINARY": {
                        return -4;
                    }
                    case "LONGVARCHAR": {
                        return -1;
                    }
                    case "MAP": {
                        return 1111;
                    }
                    case "NATIONAL CHARACTER": {
                        return -15;
                    }
                    case "NATIONAL CHARACTER LARGE OBJECT": {
                        return 2011;
                    }
                    case "NATIONAL CHARACTER VARYING": {
                        return -9;
                    }
                    case "NULL": {
                        return 0;
                    }
                    case "NUMERIC": {
                        return 2;
                    }
                    case "OTHER": {
                        return 1111;
                    }
                    case "REAL": {
                        return 7;
                    }
                    case "REF": {
                        return 2006;
                    }
                    case "ROWID": {
                        return -8;
                    }
                    case "SMALLINT": {
                        return 5;
                    }
                    case "SQLXML": {
                        return 2009;
                    }
                    case "STRUCT": {
                        return 2002;
                    }
                    case "TIME": {
                        return 92;
                    }
                    case "TIMESTAMP": {
                        return 93;
                    }
                    case "TINYINT": {
                        return -6;
                    }
                }
                return 1111;
            }

            Integer getDecimalDigits(UserProtos.ColumnMetadata value) {
                switch (value.getDataType()) {
                    case "TINYINT": 
                    case "SMALLINT": 
                    case "INTEGER": 
                    case "BIGINT": 
                    case "DECIMAL": 
                    case "NUMERIC": {
                        return value.hasNumericScale() ? Integer.valueOf(value.getNumericScale()) : null;
                    }
                    case "REAL": {
                        return 7;
                    }
                    case "FLOAT": {
                        return 7;
                    }
                    case "DOUBLE": {
                        return 15;
                    }
                    case "DATE": 
                    case "TIME": 
                    case "TIMESTAMP": 
                    case "INTERVAL": {
                        return value.getDateTimePrecision();
                    }
                }
                return null;
            }

            private Integer getNumPrecRadix(UserProtos.ColumnMetadata value) {
                switch (value.getDataType()) {
                    case "TINYINT": 
                    case "SMALLINT": 
                    case "INTEGER": 
                    case "BIGINT": 
                    case "DECIMAL": 
                    case "NUMERIC": 
                    case "REAL": 
                    case "FLOAT": 
                    case "DOUBLE": {
                        return value.getNumericPrecisionRadix();
                    }
                    case "INTERVAL": {
                        return 10;
                    }
                    case "DATE": 
                    case "TIME": 
                    case "TIMESTAMP": {
                        return 10;
                    }
                }
                return null;
            }

            private int getNullable(UserProtos.ColumnMetadata value) {
                if (!value.hasIsNullable()) {
                    return 2;
                }
                return value.getIsNullable() ? 1 : 0;
            }

            private String getIsNullable(UserProtos.ColumnMetadata value) {
                if (!value.hasIsNullable()) {
                    return "";
                }
                return value.getIsNullable() ? "YES" : "NO";
            }

            private Integer getCharOctetLength(UserProtos.ColumnMetadata value) {
                if (!value.hasCharMaxLength()) {
                    return null;
                }
                switch (value.getDataType()) {
                    case "CHARACTER": 
                    case "CHARACTER LARGE OBJECT": 
                    case "CHARACTER VARYING": 
                    case "LONGVARCHAR": 
                    case "LONGNVARCHAR": 
                    case "NATIONAL CHARACTER": 
                    case "NATIONAL CHARACTER LARGE OBJECT": 
                    case "NATIONAL CHARACTER VARYING": {
                        return value.getCharOctetLength();
                    }
                }
                return null;
            }

            @Override
            protected MetaColumn adapt(UserProtos.ColumnMetadata value) {
                return new MetaColumn(value.getCatalogName(), value.getSchemaName(), value.getTableName(), value.getColumnName(), this.getDataType(value), value.getDataType(), value.getColumnSize(), this.getDecimalDigits(value), this.getNumPrecRadix(value), this.getNullable(value), this.getCharOctetLength(value), value.getOrdinalPosition(), this.getIsNullable(value));
            }
        }.getMeta(this.connection.getClient().getColumns(catalogNameFilter, schemaNameFilter, tableNameFilter, columnNameFilter));
    }

    public Meta.MetaResultSet getColumns(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        if (this.connection.getConfig().isServerMetadataDisabled() || !this.connection.getClient().getSupportedMethods().contains(ServerMethod.GET_COLUMNS)) {
            return this.clientGetColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        return this.serverGetColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    private Meta.MetaResultSet serverGetSchemas(String catalog, Meta.Pat schemaPattern) {
        UserProtos.LikeFilter catalogNameFilter = DrillMetaImpl.newLikeFilter(DrillMetaImpl.quote(catalog));
        UserProtos.LikeFilter schemaNameFilter = DrillMetaImpl.newLikeFilter(schemaPattern);
        return new MetadataAdapter<MetaImpl.MetaSchema, UserProtos.GetSchemasResp, UserProtos.SchemaMetadata>(MetaImpl.MetaSchema.class){

            @Override
            protected UserProtos.RequestStatus getStatus(UserProtos.GetSchemasResp response) {
                return response.getStatus();
            }

            @Override
            protected List<UserProtos.SchemaMetadata> getResult(UserProtos.GetSchemasResp response) {
                return response.getSchemasList();
            }

            @Override
            protected UserBitShared.DrillPBError getError(UserProtos.GetSchemasResp response) {
                return response.getError();
            }

            @Override
            protected MetaImpl.MetaSchema adapt(UserProtos.SchemaMetadata value) {
                return new MetaImpl.MetaSchema(value.getCatalogName(), value.getSchemaName());
            }
        }.getMeta(this.connection.getClient().getSchemas(catalogNameFilter, schemaNameFilter));
    }

    private Meta.MetaResultSet clientGetSchemas(String catalog, Meta.Pat schemaPattern) {
        StringBuilder sb = new StringBuilder();
        sb.append("select SCHEMA_NAME as TABLE_SCHEM, CATALOG_NAME as TABLE_CAT  FROM INFORMATION_SCHEMA.SCHEMATA WHERE 1=1 ");
        if (catalog != null) {
            sb.append(" AND CATALOG_NAME = '" + DrillStringUtils.escapeSql((String)catalog) + "' ");
        }
        if (schemaPattern.s != null) {
            sb.append(" AND SCHEMA_NAME like '" + DrillStringUtils.escapeSql((String)schemaPattern.s) + "'");
        }
        sb.append(" ORDER BY CATALOG_NAME, SCHEMA_NAME");
        return this.s(sb.toString());
    }

    public Meta.MetaResultSet getSchemas(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern) {
        if (this.connection.getConfig().isServerMetadataDisabled() || !this.connection.getClient().getSupportedMethods().contains(ServerMethod.GET_SCHEMAS)) {
            return this.clientGetSchemas(catalog, schemaPattern);
        }
        return this.serverGetSchemas(catalog, schemaPattern);
    }

    private Meta.MetaResultSet serverGetCatalogs() {
        return new MetadataAdapter<MetaImpl.MetaCatalog, UserProtos.GetCatalogsResp, UserProtos.CatalogMetadata>(MetaImpl.MetaCatalog.class){

            @Override
            protected UserProtos.RequestStatus getStatus(UserProtos.GetCatalogsResp response) {
                return response.getStatus();
            }

            @Override
            protected List<UserProtos.CatalogMetadata> getResult(UserProtos.GetCatalogsResp response) {
                return response.getCatalogsList();
            }

            @Override
            protected UserBitShared.DrillPBError getError(UserProtos.GetCatalogsResp response) {
                return response.getError();
            }

            @Override
            protected MetaImpl.MetaCatalog adapt(UserProtos.CatalogMetadata protoValue) {
                return new MetaImpl.MetaCatalog(protoValue.getCatalogName());
            }
        }.getMeta(this.connection.getClient().getCatalogs(null));
    }

    private Meta.MetaResultSet clientGetCatalogs() {
        StringBuilder sb = new StringBuilder();
        sb.append("select CATALOG_NAME as TABLE_CAT  FROM INFORMATION_SCHEMA.CATALOGS ");
        sb.append(" ORDER BY CATALOG_NAME");
        return this.s(sb.toString());
    }

    public Meta.MetaResultSet getCatalogs(Meta.ConnectionHandle ch) {
        if (this.connection.getConfig().isServerMetadataDisabled() || !this.connection.getClient().getSupportedMethods().contains(ServerMethod.GET_CATALOGS)) {
            return this.clientGetCatalogs();
        }
        return this.serverGetCatalogs();
    }

    public Meta.StatementHandle prepare(Meta.ConnectionHandle ch, String sql, long maxRowCount) {
        Meta.StatementHandle result = super.createStatement(ch);
        result.signature = DrillMetaImpl.newSignature(sql);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle h, String sql, long maxRowCount, Meta.PrepareCallback callback) {
        Meta.Signature signature = DrillMetaImpl.newSignature(sql);
        try {
            Object object = callback.getMonitor();
            synchronized (object) {
                callback.clear();
                callback.assign(signature, null, -1L);
            }
            callback.execute();
            Meta.MetaResultSet metaResultSet = Meta.MetaResultSet.create((String)h.connectionId, (int)h.id, (boolean)false, (Meta.Signature)signature, null);
            return new Meta.ExecuteResult(Collections.singletonList(metaResultSet));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle handle, String sql, long maxRowCount, int maxRowsInFirstFrame, Meta.PrepareCallback callback) throws NoSuchStatementException {
        return this.prepareAndExecute(handle, sql, maxRowCount, callback);
    }

    public Meta.ExecuteBatchResult prepareAndExecuteBatch(Meta.StatementHandle statementHandle, List<String> list) throws NoSuchStatementException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName());
    }

    public Meta.ExecuteBatchResult executeBatch(Meta.StatementHandle statementHandle, List<List<TypedValue>> list) throws NoSuchStatementException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName());
    }

    public Meta.Frame fetch(Meta.StatementHandle statementHandle, long l, int i) throws NoSuchStatementException, MissingResultsException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName());
    }

    public Meta.ExecuteResult execute(Meta.StatementHandle statementHandle, List<TypedValue> list, long l) throws NoSuchStatementException {
        return new Meta.ExecuteResult(Collections.singletonList(Meta.MetaResultSet.create((String)statementHandle.connectionId, (int)statementHandle.id, (boolean)true, (Meta.Signature)statementHandle.signature, null)));
    }

    public Meta.ExecuteResult execute(Meta.StatementHandle statementHandle, List<TypedValue> list, int i) throws NoSuchStatementException {
        return this.execute(statementHandle, list, (long)i);
    }

    public void closeStatement(Meta.StatementHandle h) {
    }

    public boolean syncResults(Meta.StatementHandle statementHandle, QueryState queryState, long l) throws NoSuchStatementException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName());
    }

    public void commit(Meta.ConnectionHandle connectionHandle) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName());
    }

    public void rollback(Meta.ConnectionHandle connectionHandle) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName());
    }

    static interface Named {
        public String getName();
    }

    private abstract class MetadataAdapter<CalciteMetaType, Response, ResponseValue> {
        private final Class<? extends CalciteMetaType> clazz;

        public MetadataAdapter(Class<? extends CalciteMetaType> clazz) {
            this.clazz = clazz;
        }

        Meta.MetaResultSet getMeta(DrillRpcFuture<Response> future) {
            Object response;
            try {
                response = future.checkedGet();
            }
            catch (RpcException e) {
                throw new DrillRuntimeException((Throwable)new SQLException("Failure getting metadata", e));
            }
            if (this.getStatus(response) != UserProtos.RequestStatus.OK) {
                UserBitShared.DrillPBError error = this.getError(response);
                throw new DrillRuntimeException((Throwable)new SQLException("Failure getting metadata: " + error.getMessage()));
            }
            try {
                List tables = this.getResult(response).stream().map(this::adapt).collect(Collectors.toList());
                Meta.Frame frame = Meta.Frame.create((long)0L, (boolean)true, tables);
                ColumnMetaData.StructType fieldMetaData = DrillMetaImpl.drillFieldMetaData(this.clazz);
                Meta.Signature signature = Meta.Signature.create((List)fieldMetaData.columns, (String)"", Collections.emptyList(), (Meta.CursorFactory)Meta.CursorFactory.record(this.clazz), (Meta.StatementType)Meta.StatementType.SELECT);
                AvaticaStatement statement = DrillMetaImpl.this.connection.createStatement();
                return Meta.MetaResultSet.create((String)DrillMetaImpl.this.connection.id, (int)statement.getId(), (boolean)true, (Meta.Signature)signature, (Meta.Frame)frame);
            }
            catch (SQLException e) {
                throw new DrillRuntimeException((Throwable)new SQLException("Failure while attempting to get DatabaseMetadata.", e));
            }
        }

        protected abstract UserProtos.RequestStatus getStatus(Response var1);

        protected abstract UserBitShared.DrillPBError getError(Response var1);

        protected abstract List<ResponseValue> getResult(Response var1);

        protected abstract CalciteMetaType adapt(ResponseValue var1);
    }

    public static class MetaColumn
    implements Named {
        public final String tableCat;
        public final String tableSchem;
        public final String tableName;
        public final String columnName;
        public final int dataType;
        public final String typeName;
        public final Integer columnSize;
        public final Integer bufferLength = null;
        public final Integer decimalDigits;
        public final Integer numPrecRadix;
        public final int nullable;
        public final String remarks;
        public final String columnDef;
        public final Integer sqlDataType = null;
        public final Integer sqlDatetimeSub = null;
        public final Integer charOctetLength;
        public final int ordinalPosition;
        @NotNull
        public final String isNullable;
        public final String scopeCatalog;
        public final String scopeSchema;
        public final String scopeTable;
        public final Short sourceDataType = null;
        @NotNull
        public final String isAutoincrement = "";
        @NotNull
        public final String isGeneratedcolumn = "";

        public MetaColumn(String tableCat, String tableSchem, String tableName, String columnName, int dataType, String typeName, Integer columnSize, Integer decimalDigits, Integer numPrecRadix, int nullable, Integer charOctetLength, int ordinalPosition, String isNullable) {
            this.remarks = null;
            this.columnDef = null;
            this.scopeCatalog = null;
            this.scopeSchema = null;
            this.scopeTable = null;
            this.tableCat = tableCat;
            this.tableSchem = tableSchem;
            this.tableName = tableName;
            this.columnName = columnName;
            this.dataType = dataType;
            this.typeName = typeName;
            this.columnSize = columnSize;
            this.decimalDigits = decimalDigits;
            this.numPrecRadix = numPrecRadix;
            this.nullable = nullable;
            this.charOctetLength = charOctetLength;
            this.ordinalPosition = ordinalPosition;
            this.isNullable = isNullable;
        }

        @Override
        public String getName() {
            return this.columnName;
        }
    }

    private static class TypeInfo {
        private static final Map<Class<?>, TypeInfo> MAPPING = ImmutableMap.builder().put(Boolean.TYPE, (Object)TypeInfo.of(16, "BOOLEAN")).put(Boolean.class, (Object)TypeInfo.of(16, "BOOLEAN")).put(Byte.TYPE, (Object)TypeInfo.of(-6, "TINYINT")).put(Byte.class, (Object)TypeInfo.of(-6, "TINYINT")).put(Short.TYPE, (Object)TypeInfo.of(5, "SMALLINT")).put(Short.class, (Object)TypeInfo.of(5, "SMALLINT")).put(Integer.TYPE, (Object)TypeInfo.of(4, "INTEGER")).put(Integer.class, (Object)TypeInfo.of(4, "INTEGER")).put(Long.TYPE, (Object)TypeInfo.of(-5, "BIGINT")).put(Long.class, (Object)TypeInfo.of(-5, "BIGINT")).put(Float.TYPE, (Object)TypeInfo.of(6, "FLOAT")).put(Float.class, (Object)TypeInfo.of(6, "FLOAT")).put(Double.TYPE, (Object)TypeInfo.of(8, "DOUBLE")).put(Double.class, (Object)TypeInfo.of(8, "DOUBLE")).put(String.class, (Object)TypeInfo.of(12, "CHARACTER VARYING")).put(BigDecimal.class, (Object)TypeInfo.of(3, "DECIMAL")).put(Date.class, (Object)TypeInfo.of(91, "DATE")).put(Time.class, (Object)TypeInfo.of(92, "TIME")).put(Timestamp.class, (Object)TypeInfo.of(93, "TIMESTAMP")).build();
        private final int sqlType;
        private final String sqlTypeName;

        public TypeInfo(int sqlType, String sqlTypeName) {
            this.sqlType = sqlType;
            this.sqlTypeName = sqlTypeName;
        }

        private static TypeInfo of(int sqlType, String sqlTypeName) {
            return new TypeInfo(sqlType, sqlTypeName);
        }

        public static TypeInfo get(Class<?> clazz) {
            return MAPPING.get(clazz);
        }
    }
}

