/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.calcite.linq4j.Ord;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.exec.ExecTest;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.util.StoragePluginTestUtils;
import org.apache.drill.jdbc.CachingConnectionFactory;
import org.apache.drill.jdbc.ConnectionFactory;
import org.apache.drill.jdbc.ConnectionInfo;
import org.apache.drill.jdbc.SingleConnectionCachingFactory;
import org.apache.drill.jdbc.impl.DrillConnectionImpl;
import org.apache.drill.jdbc.impl.DrillConnectionUtils;
import org.apache.drill.shaded.guava.com.google.common.base.Function;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={JdbcTest.class})
public class JdbcTestBase
extends ExecTest {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTestBase.class);
    @Rule
    public final TestRule watcher = new TestWatcher(){

        protected void failed(Throwable e, Description description) {
            JdbcTestBase.reset();
        }
    };
    private static CachingConnectionFactory factory;

    @BeforeClass
    public static void setUpTestCase() {
        factory = new SingleConnectionCachingFactory(info -> {
            Connection connection = DriverManager.getConnection(info.getUrl(), info.getParamsAsProperties());
            JdbcTestBase.updateSchemaLocations(connection);
            return connection;
        });
    }

    protected static Connection connect(String url) throws SQLException {
        return JdbcTestBase.connect(url, JdbcTestBase.getDefaultProperties());
    }

    protected static Connection connect() throws SQLException {
        return JdbcTestBase.connect("jdbc:drill:zk=local", JdbcTestBase.getDefaultProperties());
    }

    protected static Connection connect(String url, Properties info) throws SQLException {
        Connection conn = factory.getConnection(new ConnectionInfo(url, info));
        JdbcTestBase.changeSchemaIfSupplied(conn, info);
        return conn;
    }

    private static void updateSchemaLocations(Connection conn) {
        if (conn instanceof DrillConnectionImpl) {
            StoragePluginRegistry storage = DrillConnectionUtils.getStorage((DrillConnectionImpl)conn);
            try {
                StoragePluginTestUtils.configureFormatPlugins((StoragePluginRegistry)storage);
                StoragePluginTestUtils.updateSchemaLocation((String)"dfs", (StoragePluginRegistry)storage, (File)dirTestWatcher.getDfsTestTmpDir(), (String[])new String[]{"tmp"});
                StoragePluginTestUtils.updateSchemaLocation((String)"dfs", (StoragePluginRegistry)storage, (File)dirTestWatcher.getRootDir(), (String[])new String[]{"root"});
                StoragePluginTestUtils.updateSchemaLocation((String)"dfs", (StoragePluginRegistry)storage, (File)dirTestWatcher.getRootDir(), (String[])new String[]{"default"});
            }
            catch (StoragePluginRegistry.PluginException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static void changeSchemaIfSupplied(Connection conn, Properties info) {
        String schema = info.getProperty("schema", null);
        if (!Strings.isNullOrEmpty((String)schema)) {
            JdbcTestBase.changeSchema(conn, schema);
        }
    }

    protected static void changeSchema(Connection conn, String schema) {
        String query = String.format("use %s", schema);
        try (Statement s = conn.createStatement();){
            ResultSet resultSet = s.executeQuery(query);
        }
        catch (SQLException e) {
            throw new RuntimeException("unable to change schema", e);
        }
    }

    protected static void reset() {
        try {
            factory.closeConnections();
        }
        catch (SQLException e) {
            throw new RuntimeException("error while closing connection factory", e);
        }
    }

    @AfterClass
    public static void tearDownTestCase() throws Exception {
        factory.closeConnections();
    }

    public static Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.setProperty("drill.tmp-dir", dirTestWatcher.getTmpDir().getAbsolutePath());
        properties.setProperty("drill.exec.sys.store.provider.local.write", "false");
        properties.setProperty("drill.exec.http.enabled", "false");
        return properties;
    }

    public static ModelAndSchema withModel(String model, String schema) {
        Properties info = JdbcTestBase.getDefaultProperties();
        info.setProperty("schema", schema);
        info.setProperty("model", "inline:" + model);
        return new ModelAndSchema(info, factory);
    }

    public static ModelAndSchema withFull(String schema) {
        Properties info = JdbcTestBase.getDefaultProperties();
        info.setProperty("schema", schema);
        return new ModelAndSchema(info, factory);
    }

    public static ModelAndSchema withNoDefaultSchema() {
        return new ModelAndSchema(JdbcTestBase.getDefaultProperties(), factory);
    }

    public static String toString(ResultSet resultSet, int expectedRecordCount) throws SQLException {
        StringBuilder buf = new StringBuilder();
        while (resultSet.next()) {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int n = metaData.getColumnCount();
            String sep = "";
            for (int i = 1; i <= n; ++i) {
                buf.append(sep).append(metaData.getColumnLabel(i)).append("=").append(resultSet.getObject(i));
                sep = "; ";
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public static String toString(ResultSet resultSet) throws SQLException {
        StringBuilder buf = new StringBuilder();
        List<Ord<String>> columns = JdbcTestBase.columnLabels(resultSet);
        while (resultSet.next()) {
            for (Ord<String> column : columns) {
                buf.append(column.i == 1 ? "" : "; ").append((String)column.e).append("=").append(resultSet.getObject(column.i));
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    static Set<String> toStringSet(ResultSet resultSet) throws SQLException {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        List<Ord<String>> columns = JdbcTestBase.columnLabels(resultSet);
        while (resultSet.next()) {
            StringBuilder buf = new StringBuilder();
            for (Ord<String> column : columns) {
                buf.append(column.i == 1 ? "" : "; ").append((String)column.e).append("=").append(resultSet.getObject(column.i));
            }
            builder.add((Object)buf.toString());
            buf.setLength(0);
        }
        return builder.build();
    }

    static List<String> toStrings(ResultSet resultSet) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        List<Ord<String>> columns = JdbcTestBase.columnLabels(resultSet);
        while (resultSet.next()) {
            buf.setLength(0);
            for (Ord<String> column : columns) {
                buf.append(column.i == 1 ? "" : "; ").append((String)column.e).append("=").append(resultSet.getObject(column.i));
            }
            list.add(buf.toString());
        }
        return list;
    }

    private static List<Ord<String>> columnLabels(ResultSet resultSet) throws SQLException {
        int n = resultSet.getMetaData().getColumnCount();
        ArrayList<Ord<String>> columns = new ArrayList<Ord<String>>();
        for (int i = 1; i <= n; ++i) {
            columns.add((Ord<String>)Ord.of((int)i, (Object)resultSet.getMetaData().getColumnLabel(i)));
        }
        return columns;
    }

    @Ignore(value="Usually disabled; enable temporarily to check tests")
    @Test
    public void testJdbcTestConnectionResettingCompatibility() {
        Assert.fail((String)"Intentional failure--did other test methods still run?");
    }

    private static interface ConnectionFactoryAdapter {
        public Connection createConnection() throws Exception;
    }

    public static class TestDataConnection {
        private final ConnectionFactoryAdapter adapter;
        private final String sql;

        TestDataConnection(ConnectionFactoryAdapter adapter, String sql) {
            this.adapter = adapter;
            this.sql = sql;
        }

        public TestDataConnection returns(String expected) throws Exception {
            try (Connection connection = this.adapter.createConnection();){
                TestDataConnection testDataConnection;
                block13: {
                    Statement statement = connection.createStatement();
                    try {
                        ResultSet resultSet = statement.executeQuery(this.sql);
                        expected = expected.trim();
                        String result = JdbcTestBase.toString(resultSet).trim();
                        resultSet.close();
                        if (!expected.equals(result)) {
                            Assert.fail((String)String.format("Generated string:\n%s\ndoes not match:\n%s", result, expected));
                        }
                        testDataConnection = this;
                        if (statement == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return testDataConnection;
            }
        }

        public TestDataConnection returnsSet(Set<String> expected) throws Exception {
            try (Connection connection = this.adapter.createConnection();){
                TestDataConnection testDataConnection;
                block13: {
                    Statement statement = connection.createStatement();
                    try {
                        ResultSet resultSet = statement.executeQuery(this.sql);
                        Set<String> result = JdbcTestBase.toStringSet(resultSet);
                        resultSet.close();
                        if (!expected.equals(result)) {
                            Assert.fail((String)String.format("Generated set:\n%s\ndoes not match:\n%s", result, expected));
                        }
                        testDataConnection = this;
                        if (statement == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return testDataConnection;
            }
        }

        public TestDataConnection returnsUnordered(String ... expecteds) throws Exception {
            try (Connection connection = this.adapter.createConnection();){
                TestDataConnection testDataConnection;
                block12: {
                    Statement statement = connection.createStatement();
                    try {
                        ResultSet resultSet = statement.executeQuery(this.sql);
                        Assert.assertEquals(this.unsortedList(Arrays.asList(expecteds)), this.unsortedList(JdbcTestBase.toStrings(resultSet)));
                        resultSet.close();
                        testDataConnection = this;
                        if (statement == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return testDataConnection;
            }
        }

        public TestDataConnection displayResults(int recordCount) throws Exception {
            try (Connection connection = this.adapter.createConnection();){
                TestDataConnection testDataConnection;
                block12: {
                    Statement statement = connection.createStatement();
                    try {
                        ResultSet resultSet = statement.executeQuery(this.sql);
                        logger.debug(JdbcTestBase.toString(resultSet, recordCount));
                        resultSet.close();
                        testDataConnection = this;
                        if (statement == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return testDataConnection;
            }
        }

        private SortedSet<String> unsortedList(List<String> strings) {
            TreeSet<String> set = new TreeSet<String>();
            for (String string : strings) {
                set.add(string + "\n");
            }
            return set;
        }

        /*
         * Exception decompiling
         */
        public LogicalPlan logicalPlan() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public <T extends LogicalOperator> T planContains(Class<T> operatorClazz) {
            return (T)this.logicalPlan().getSortedOperators().stream().filter(input -> input.getClass().equals(operatorClazz)).findFirst().get();
        }

        private static /* synthetic */ Void lambda$logicalPlan$0(String[] plan0, String o) {
            plan0[0] = o;
            return null;
        }
    }

    public static class ModelAndSchema {
        private final Properties info;
        private final ConnectionFactoryAdapter adapter;

        public ModelAndSchema(Properties info, ConnectionFactory factory) {
            this.info = info;
            this.adapter = () -> factory.getConnection(new ConnectionInfo("jdbc:drill:zk=local", this.info));
        }

        public TestDataConnection sql(String sql) {
            return new TestDataConnection(this.adapter, sql);
        }

        public <T> T withConnection(Function<Connection, T> function) throws Exception {
            try (Connection connection = this.adapter.createConnection();){
                Object object = function.apply((Object)connection);
                return (T)object;
            }
        }
    }
}

