/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.jdbc.JdbcTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.Period;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={JdbcTest.class})
public class ResultSetMetaDataTest
extends JdbcTestBase {
    private static final String VIEW_NAME = ResultSetMetaDataTest.class.getSimpleName() + "_View";
    private static Connection connection;
    private static ResultSet viewRow;
    private static ResultSetMetaData rowMetadata;
    private static int columnCount;
    private static int ordOptBOOLEAN;
    private static int ordReqBOOLEAN;
    private static int ordReqSMALLINT;
    private static int ordReqINTEGER;
    private static int ordReqBIGINT;
    private static int ordReqREAL;
    private static int ordReqFLOAT;
    private static int ordReqDOUBLE;
    private static int ordReqDECIMAL_5_3;
    private static int ordReqVARCHAR_10;
    private static int ordOptVARCHAR;
    private static int ordReqCHAR_5;
    private static int ordOptVARBINARY_16;
    private static int ordOptBINARY_1048576;
    private static int ordReqDATE;
    private static int ordReqTIME_2;
    private static int ordOptTIME_7;
    private static int ordReqTIMESTAMP_4;
    private static int ordReqINTERVAL_Y;
    private static int ordReqINTERVAL_3Y_Mo;
    private static int ordReqINTERVAL_10Y_Mo;
    private static int ordReqINTERVAL_Mo;
    private static int ordReqINTERVAL_D;
    private static int ordReqINTERVAL_4D_H;
    private static int ordReqINTERVAL_3D_Mi;
    private static int ordReqINTERVAL_2D_S5;
    private static int ordReqINTERVAL_H;
    private static int ordReqINTERVAL_1H_Mi;
    private static int ordReqINTERVAL_3H_S1;
    private static int ordReqINTERVAL_Mi;
    private static int ordReqINTERVAL_5Mi_S;
    private static int ordReqINTERVAL_S;
    private static int ordReqINTERVAL_3S;
    private static int ordReqINTERVAL_3S1;

    @BeforeClass
    public static void setUpConnectionAndMetadataToCheck() throws Exception {
        connection = ResultSetMetaDataTest.connect("jdbc:drill:zk=local");
        Statement stmt = connection.createStatement();
        ResultSet util = stmt.executeQuery("USE `dfs.tmp`");
        Assert.assertTrue((boolean)util.next());
        Assert.assertTrue((String)("Error setting schema for test: " + util.getString(2)), (boolean)util.getBoolean(1));
        columnCount = 0;
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE OR REPLACE VIEW `" + VIEW_NAME + "` AS SELECT ");
        buf.append("\n CAST( NULL    AS BOOLEAN      ) AS mdrOptBOOLEAN, ");
        ++columnCount;
        ordOptBOOLEAN = columnCount++;
        buf.append("\n TRUE                            AS mdrReqBOOLEAN, ");
        ordReqBOOLEAN = columnCount++;
        buf.append("\n CAST(    2    AS INTEGER      ) AS mdrOptINTEGER, ");
        ordReqINTEGER = columnCount++;
        buf.append("\n CAST( 15      AS BIGINT       ) AS mdrReqBIGINT, ");
        ordReqBIGINT = columnCount++;
        buf.append("\n CAST(  3.2    AS FLOAT        ) AS mdrReqFLOAT, ");
        ordReqFLOAT = columnCount++;
        buf.append("\n CAST(  3.3    AS DOUBLE       ) AS mdrReqDOUBLE, ");
        ordReqDOUBLE = columnCount++;
        buf.append("\n CAST(  4.4    AS DECIMAL(5,3) ) AS mdrReqDECIMAL_5_3, ");
        ordReqDECIMAL_5_3 = columnCount++;
        buf.append("\n CAST( 'Hi'    AS VARCHAR(10)  ) AS mdrReqVARCHAR_10, ");
        ordReqVARCHAR_10 = columnCount++;
        buf.append("\n CAST( NULL    AS VARCHAR      ) AS mdrOptVARCHAR, ");
        ordOptVARCHAR = columnCount++;
        buf.append("\n CAST( '55'    AS CHAR(5)      ) AS mdrReqCHAR_5, ");
        ordReqCHAR_5 = columnCount++;
        buf.append("\n       DATE '2015-01-01'            AS mdrReqDATE, ");
        ordReqDATE = columnCount++;
        buf.append("\n CAST( TIME '23:59:59.123' AS TIME(2) ) AS mdrReqTIME_2, ");
        ordReqTIME_2 = columnCount++;
        buf.append("\n CAST( NULL                AS TIME(7) ) AS mdrOptTIME_7, ");
        ordOptTIME_7 = columnCount++;
        buf.append("\n CAST( TIMESTAMP '2015-01-01 23:59:59.12345' AS TIMESTAMP(4) ) AS mdrReqTIMESTAMP_4, ");
        ordReqTIMESTAMP_4 = columnCount++;
        buf.append("\n INTERVAL '1'     YEAR              AS mdrReqINTERVAL_Y, ");
        ordReqINTERVAL_Y = columnCount++;
        buf.append("\n INTERVAL '1-2'   YEAR(3) TO MONTH  AS mdrReqINTERVAL_3Y_Mo, ");
        ordReqINTERVAL_3Y_Mo = columnCount++;
        buf.append("\n INTERVAL '1-2'   YEAR(10) TO MONTH AS mdrReqINTERVAL_10Y_Mo, ");
        ordReqINTERVAL_10Y_Mo = columnCount++;
        buf.append("\n INTERVAL '-2'    MONTH             AS mdrReqINTERVAL_Mo, ");
        ordReqINTERVAL_Mo = columnCount++;
        buf.append("\n INTERVAL '3'     DAY               AS mdrReqINTERVAL_D, ");
        ordReqINTERVAL_D = columnCount++;
        buf.append("\n INTERVAL '3 4'   DAY(4) TO HOUR    AS mdrReqINTERVAL_4D_H, ");
        ordReqINTERVAL_4D_H = columnCount++;
        buf.append("\n INTERVAL '3 4:5' DAY(3) TO MINUTE  AS mdrReqINTERVAL_3D_Mi, ");
        ordReqINTERVAL_3D_Mi = columnCount++;
        buf.append("\n INTERVAL '3 4:5:6' DAY(2) TO SECOND(5) AS mdrReqINTERVAL_2D_S5, ");
        ordReqINTERVAL_2D_S5 = columnCount++;
        buf.append("\n INTERVAL '4'     HOUR              AS mdrReqINTERVAL_H, ");
        ordReqINTERVAL_H = columnCount++;
        buf.append("\n INTERVAL '4:5'   HOUR(1) TO MINUTE AS mdrReqINTERVAL_1H_Mi, ");
        ordReqINTERVAL_1H_Mi = columnCount++;
        buf.append("\n INTERVAL '4:5:6' HOUR(3) TO SECOND(1) AS mdrReqINTERVAL_3H_S1, ");
        ordReqINTERVAL_3H_S1 = columnCount++;
        buf.append("\n INTERVAL '5'     MINUTE            AS mdrReqINTERVAL_Mi, ");
        ordReqINTERVAL_Mi = columnCount++;
        buf.append("\n INTERVAL '5:6'   MINUTE(5) TO SECOND AS mdrReqINTERVAL_5Mi_S, ");
        ordReqINTERVAL_5Mi_S = columnCount++;
        buf.append("\n INTERVAL '6'     SECOND          AS mdrReqINTERVAL_S, ");
        ordReqINTERVAL_S = columnCount++;
        buf.append("\n INTERVAL '6'     SECOND(3)       AS mdrReqINTERVAL_3S, ");
        ordReqINTERVAL_3S = columnCount++;
        buf.append("\n INTERVAL '6'     SECOND(3, 1)    AS mdrReqINTERVAL_3S1, ");
        ordReqINTERVAL_3S1 = columnCount++;
        buf.append("\n ''");
        buf.append("\nFROM INFORMATION_SCHEMA.COLUMNS LIMIT 1 ");
        String query = buf.toString();
        util = stmt.executeQuery(query);
        Assert.assertTrue((boolean)util.next());
        Assert.assertTrue((String)("Error creating temporary test-columns view " + VIEW_NAME + ": " + util.getString(2)), (boolean)util.getBoolean(1));
        viewRow = stmt.executeQuery("SELECT * FROM " + VIEW_NAME + " LIMIT 1 ");
        viewRow.next();
        rowMetadata = viewRow.getMetaData();
    }

    @AfterClass
    public static void tearDownConnection() throws SQLException {
        ResultSet util = connection.createStatement().executeQuery("DROP VIEW " + VIEW_NAME + "");
        Assert.assertTrue((boolean)util.next());
        Assert.assertTrue((String)("Error dropping temporary test-columns view " + VIEW_NAME + ": " + util.getString(2)), (boolean)util.getBoolean(1));
        connection.close();
    }

    @Test
    public void test_getColumnCount() throws SQLException {
        Assert.assertThat((String)"column count", (Object)rowMetadata.getColumnCount(), (Matcher)CoreMatchers.equalTo((Object)columnCount));
    }

    @Test
    public void test_isAutoIncrement_returnsFalse() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isAutoIncrement(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void test_isCaseSensitive_nameThisNonSpecific() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isCaseSensitive(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void test_isSearchable_returnsTrue() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isSearchable(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void test_isCurrency_returnsFalse() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isCurrency(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void test_isNullable_forNullable() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isNullable(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_isNullable_forRequired() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isNullable(ordReqINTEGER), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_isSigned_forBOOLEAN() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isSigned(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void test_isSigned_forINTEGER() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isSigned(ordReqINTEGER), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void test_isSigned_forDOUBLE() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isSigned(ordReqDOUBLE), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void test_isSigned_forDECIMAL_5_3() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isSigned(ordReqDECIMAL_5_3), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void test_isSigned_forVARCHAR() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isSigned(ordReqVARCHAR_10), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    @Ignore(value="TODO(DRILL-3368): unignore when VARBINARY is implemented enough")
    public void test_isSigned_forBINARY_1048576() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isSigned(ordOptBINARY_1048576), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void test_isSigned_forDate() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isSigned(ordReqDATE), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void test_isSigned_forTIME_2() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isSigned(ordReqTIME_2), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void test_isSigned_forTIMESTAMP_4() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isSigned(ordReqTIMESTAMP_4), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void test_isSigned_forINTERVAL_Y() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isSigned(ordReqINTERVAL_Y), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void test_getColumnDisplaySize_forBOOLEAN() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnDisplaySize(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_getColumnLabel_getsName() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnLabel(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)"mdrOptBOOLEAN"));
    }

    @Test
    public void test_getColumnName_getsName() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnName(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)"mdrOptBOOLEAN"));
    }

    @Test
    public void test_getSchemaName_forViewGetsName() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getSchemaName(ordOptBOOLEAN), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)"dfs.tmp"), (Matcher)CoreMatchers.equalTo((Object)"")));
    }

    @Test
    public void test_getPrecision_forBOOLEAN() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getPrecision(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Ignore(value="TODO(DRILL-3355): unignore when getPrecision(...) implemented")
    @Test
    public void test_getPrecision_forINTEGER() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getPrecision(ordReqINTEGER), (Matcher)CoreMatchers.equalTo((Object)32));
        Assert.assertThat((Object)rowMetadata.getPrecision(ordReqINTEGER), (Matcher)CoreMatchers.equalTo((Object)10));
        Assert.assertThat((Object)rowMetadata.getPrecision(ordReqINTEGER), (Matcher)CoreMatchers.equalTo((Object)9));
    }

    @Ignore(value="TODO(DRILL-3355): unignore when getPrecision(...) implemented")
    @Test
    public void test_getPrecision_forDOUBLE() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getPrecision(ordReqDOUBLE), (Matcher)CoreMatchers.equalTo((Object)53));
        Assert.assertThat((Object)rowMetadata.getPrecision(ordReqINTEGER), (Matcher)CoreMatchers.equalTo((Object)7));
        Assert.assertThat((Object)rowMetadata.getPrecision(ordReqDOUBLE), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Ignore(value="TODO(DRILL-3367): unignore when DECIMAL is no longer DOUBLE")
    @Test
    public void test_getPrecision_forDECIMAL_5_3() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getPrecision(ordReqDECIMAL_5_3), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void test_getScale_forBOOLEAN() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getScale(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_getScale_forINTEGER() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getScale(ordReqINTEGER), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Ignore(value="TODO(DRILL-3367): unignore when DECIMAL is no longer DOUBLE")
    @Test
    public void test_getScale_forDECIMAL_5_3() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getScale(ordReqDECIMAL_5_3), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_getTableName_forViewGetsName() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getTableName(ordOptBOOLEAN), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)VIEW_NAME), (Matcher)CoreMatchers.equalTo((Object)"")));
    }

    @Test
    public void test_getCatalogName_getsCatalogName() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getCatalogName(ordOptBOOLEAN), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)"DRILL"), (Matcher)CoreMatchers.equalTo((Object)"")));
    }

    @Test
    public void test_getColumnType_forBOOLEAN() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)16));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_getColumnType_forSMALLINT() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordReqSMALLINT), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void test_getColumnType_forINTEGER() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordReqINTEGER), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_getColumnType_forBIGINT() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordReqBIGINT), (Matcher)CoreMatchers.equalTo((Object)-5));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_getColumnType_forREAL() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordReqREAL), (Matcher)CoreMatchers.equalTo((Object)7));
    }

    @Test
    public void test_getColumnType_forFLOAT() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordReqFLOAT), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_getColumnType_forDOUBLE() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordReqDOUBLE), (Matcher)CoreMatchers.equalTo((Object)8));
    }

    @Ignore(value="TODO(DRILL-3367): unignore when DECIMAL is no longer DOUBLE")
    @Test
    public void test_getColumnType_forDECIMAL_5_3() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordReqDECIMAL_5_3), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_getColumnType_forVARCHAR_10() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordReqVARCHAR_10), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_getColumnType_forVARCHAR() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordOptVARCHAR), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Ignore(value="TODO(DRILL-3369): unignore when CHAR is no longer VARCHAR")
    @Test
    public void test_getColumnType_forCHAR_5() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordReqCHAR_5), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Ignore(value="TODO(DRILL-3368): unignore when VARBINARY is implemented enough")
    @Test
    public void test_getColumnType_forVARBINARY_16() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordOptVARBINARY_16), (Matcher)CoreMatchers.equalTo((Object)-3));
    }

    @Ignore(value="TODO(DRILL-3368): unignore when BINARY is implemented enough")
    @Test
    public void test_getColumnType_forBINARY_1048576CHECK() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordOptBINARY_1048576), (Matcher)CoreMatchers.equalTo((Object)-3));
    }

    @Test
    public void test_getColumnType_forDATE() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordReqDATE), (Matcher)CoreMatchers.equalTo((Object)91));
    }

    @Test
    public void test_getColumnType_forTIME_2() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordReqTIME_2), (Matcher)CoreMatchers.equalTo((Object)92));
    }

    @Test
    public void test_getColumnType_forTIME_7() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordOptTIME_7), (Matcher)CoreMatchers.equalTo((Object)92));
    }

    @Test
    public void test_getColumnType_forTIMESTAMP_4() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordReqTIMESTAMP_4), (Matcher)CoreMatchers.equalTo((Object)93));
    }

    @Test
    public void test_getColumnType_forINTERVAL_Y() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordReqINTERVAL_Y), (Matcher)CoreMatchers.equalTo((Object)1111));
    }

    @Test
    public void test_getColumnType_forINTERVAL_H_S3() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnType(ordReqINTERVAL_3H_S1), (Matcher)CoreMatchers.equalTo((Object)1111));
    }

    @Test
    public void test_getColumnTypeName_forBOOLEAN() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)"BOOLEAN"));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_getColumnTypeName_forSMALLINT() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordReqSMALLINT), (Matcher)CoreMatchers.equalTo((Object)"SMALLINT"));
    }

    @Test
    public void test_getColumnTypeName_forINTEGER() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordReqINTEGER), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_getColumnTypeName_forBIGINT() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordReqBIGINT), (Matcher)CoreMatchers.equalTo((Object)"BIGINT"));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_getColumnTypeName_forREAL() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordReqREAL), (Matcher)CoreMatchers.equalTo((Object)"REAL"));
    }

    @Test
    public void test_getColumnTypeName_forFLOAT() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordReqFLOAT), (Matcher)CoreMatchers.equalTo((Object)"FLOAT"));
    }

    @Test
    public void test_getColumnTypeName_forDOUBLE() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordReqDOUBLE), (Matcher)CoreMatchers.equalTo((Object)"DOUBLE"));
    }

    @Ignore(value="TODO(DRILL-3367): unignore when DECIMAL is no longer DOUBLE")
    @Test
    public void test_getColumnTypeName_forDECIMAL_5_3() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordReqDECIMAL_5_3), (Matcher)CoreMatchers.equalTo((Object)"DECIMAL"));
    }

    @Test
    public void test_getColumnTypeName_forVARCHAR() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordOptVARCHAR), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Ignore(value="TODO(DRILL-3369): unignore when CHAR is no longer VARCHAR")
    @Test
    public void test_getColumnTypeName_forCHAR() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordReqCHAR_5), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER"));
    }

    @Ignore(value="TODO(DRILL-3368): unignore when VARBINARY is implemented enough")
    @Test
    public void test_getColumnTypeName_forVARBINARY() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordOptVARBINARY_16), (Matcher)CoreMatchers.equalTo((Object)"BINARY VARYING"));
    }

    @Ignore(value="TODO(DRILL-3368): unignore when BINARY is implemented enough")
    @Test
    public void test_getColumnTypeName_forBINARY() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordOptBINARY_1048576), (Matcher)CoreMatchers.equalTo((Object)"BINARY"));
    }

    @Test
    public void test_getColumnTypeName_forDATE() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordReqDATE), (Matcher)CoreMatchers.equalTo((Object)"DATE"));
    }

    @Test
    public void test_getColumnTypeName_forTIME_2() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordReqTIME_2), (Matcher)CoreMatchers.equalTo((Object)"TIME"));
    }

    @Test
    public void test_getColumnTypeName_forTIMESTAMP_4() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordReqTIMESTAMP_4), (Matcher)CoreMatchers.equalTo((Object)"TIMESTAMP"));
    }

    @Test
    public void test_getColumnTypeName_forINTERVAL_Y() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordReqINTERVAL_Y), (Matcher)CoreMatchers.equalTo((Object)"INTERVAL YEAR TO MONTH"));
    }

    @Test
    public void test_getColumnTypeName_forINTERVAL_D() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnTypeName(ordReqINTERVAL_4D_H), (Matcher)CoreMatchers.equalTo((Object)"INTERVAL DAY TO SECOND"));
    }

    @Test
    public void test_isReadOnly_nameThisNonSpecific() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isReadOnly(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void test_isWritable_nameThisNonSpecific() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isWritable(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void test_isDefinitelyWritable_nameThisNonSpecific() throws SQLException {
        Assert.assertThat((Object)rowMetadata.isDefinitelyWritable(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void test_getColumnClassName_forBOOLEAN_isBoolean() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordOptBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)Boolean.class.getName()));
    }

    @Test
    public void test_getColumnClassName_forBOOLEAN_matches() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqBOOLEAN), (Matcher)CoreMatchers.equalTo((Object)viewRow.getObject(ordReqBOOLEAN).getClass().getName()));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_getColumnClassName_forSMALLINT_isShort() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqSMALLINT), (Matcher)CoreMatchers.equalTo((Object)Short.class.getName()));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_getColumnClassName_forSMALLINT_matches() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqSMALLINT), (Matcher)CoreMatchers.equalTo((Object)viewRow.getObject(ordReqSMALLINT).getClass().getName()));
    }

    @Test
    public void test_getColumnClassName_forINTEGER_isInteger() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqINTEGER), (Matcher)CoreMatchers.equalTo((Object)Integer.class.getName()));
    }

    @Test
    public void test_getColumnClassName_forINTEGER_matches() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqINTEGER), (Matcher)CoreMatchers.equalTo((Object)viewRow.getObject(ordReqINTEGER).getClass().getName()));
    }

    @Test
    public void test_getColumnClassName_forBIGINT_isLong() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqBIGINT), (Matcher)CoreMatchers.equalTo((Object)Long.class.getName()));
    }

    @Test
    public void test_getColumnClassName_forBIGINT_matches() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqBIGINT), (Matcher)CoreMatchers.equalTo((Object)viewRow.getObject(ordReqBIGINT).getClass().getName()));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_getColumnClassName_forREAL_isFloat() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqREAL), (Matcher)CoreMatchers.equalTo((Object)Float.class.getName()));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_getColumnClassName_forREAL_matches() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqREAL), (Matcher)CoreMatchers.equalTo((Object)viewRow.getObject(ordReqREAL).getClass().getName()));
    }

    @Test
    public void test_getColumnClassName_forFLOAT_isFloat() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqFLOAT), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)Float.class.getName()), (Matcher)CoreMatchers.equalTo((Object)Double.class.getName())));
    }

    @Test
    public void test_getColumnClassName_forFLOAT_matches() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqFLOAT), (Matcher)CoreMatchers.equalTo((Object)viewRow.getObject(ordReqFLOAT).getClass().getName()));
    }

    @Test
    public void test_getColumnClassName_forDOUBLE_isDouble() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqDOUBLE), (Matcher)CoreMatchers.equalTo((Object)Double.class.getName()));
    }

    @Test
    public void test_getColumnClassName_forDOUBLE_matches() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqDOUBLE), (Matcher)CoreMatchers.equalTo((Object)viewRow.getObject(ordReqDOUBLE).getClass().getName()));
    }

    @Ignore(value="TODO(DRILL-3367): unignore when DECIMAL is no longer DOUBLE")
    @Test
    public void test_getColumnClassName_forDECIMAL_5_3_isBigDecimal() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqDECIMAL_5_3), (Matcher)CoreMatchers.equalTo((Object)BigDecimal.class.getName()));
    }

    @Test
    public void test_getColumnClassName_forDECIMAL_5_3_matches() throws SQLException, ClassNotFoundException {
        Class<?> requiredClass = Class.forName(rowMetadata.getColumnClassName(ordReqDECIMAL_5_3));
        Class<?> actualClass = viewRow.getObject(ordReqDECIMAL_5_3).getClass();
        Assert.assertTrue((String)("actual class " + actualClass.getName() + " is not assignable to required class " + requiredClass), (boolean)requiredClass.isAssignableFrom(actualClass));
    }

    @Test
    public void test_getColumnClassName_forVARCHAR_10_isString() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqVARCHAR_10), (Matcher)CoreMatchers.equalTo((Object)String.class.getName()));
    }

    @Test
    public void test_getColumnClassName_forVARCHAR_10_matches() throws SQLException, ClassNotFoundException {
        Class<?> requiredClass = Class.forName(rowMetadata.getColumnClassName(ordReqVARCHAR_10));
        Class<?> actualClass = viewRow.getObject(ordReqVARCHAR_10).getClass();
        Assert.assertTrue((String)("actual class " + actualClass.getName() + " is not assignable to required class " + requiredClass), (boolean)requiredClass.isAssignableFrom(actualClass));
    }

    @Test
    public void test_getColumnClassName_forDATE_isDate() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqDATE), (Matcher)CoreMatchers.equalTo((Object)Date.class.getName()));
    }

    @Test
    public void test_getColumnClassName_forDATE_matches() throws SQLException, ClassNotFoundException {
        Class<?> requiredClass = Class.forName(rowMetadata.getColumnClassName(ordReqDATE));
        Class<?> actualClass = viewRow.getObject(ordReqDATE).getClass();
        Assert.assertTrue((String)("actual class " + actualClass.getName() + " is not assignable to required class " + requiredClass), (boolean)requiredClass.isAssignableFrom(actualClass));
    }

    @Test
    public void test_getColumnClassName_forTIME_2_isTime() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqTIME_2), (Matcher)CoreMatchers.equalTo((Object)Time.class.getName()));
    }

    @Test
    public void test_getColumnClassName_forTIME_2_matches() throws SQLException, ClassNotFoundException {
        Class<?> requiredClass = Class.forName(rowMetadata.getColumnClassName(ordReqTIME_2));
        Class<?> actualClass = viewRow.getObject(ordReqTIME_2).getClass();
        Assert.assertTrue((String)("actual class " + actualClass.getName() + " is not assignable to required class " + requiredClass), (boolean)requiredClass.isAssignableFrom(actualClass));
    }

    @Test
    public void test_getColumnClassName_forTIMESTAMP_4_isDate() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqTIMESTAMP_4), (Matcher)CoreMatchers.equalTo((Object)Timestamp.class.getName()));
    }

    @Test
    public void test_getColumnClassName_forTIMESTAMP_4_matches() throws SQLException, ClassNotFoundException {
        Class<?> requiredClass = Class.forName(rowMetadata.getColumnClassName(ordReqTIMESTAMP_4));
        Class<?> actualClass = viewRow.getObject(ordReqTIMESTAMP_4).getClass();
        Assert.assertTrue((String)("actual class " + actualClass.getName() + " is not assignable to required class " + requiredClass), (boolean)requiredClass.isAssignableFrom(actualClass));
    }

    @Test
    public void test_getColumnClassName_forINTERVAL_10Y_Mo_isJodaPeriod() throws SQLException {
        Assert.assertThat((Object)rowMetadata.getColumnClassName(ordReqINTERVAL_10Y_Mo), (Matcher)CoreMatchers.equalTo((Object)Period.class.getName()));
    }

    @Test
    public void test_getColumnClassName_forINTERVAL_10Y_Mo_matches() throws SQLException, ClassNotFoundException {
        Class<?> requiredClass = Class.forName(rowMetadata.getColumnClassName(ordReqINTERVAL_10Y_Mo));
        Class<?> actualClass = viewRow.getObject(ordReqINTERVAL_10Y_Mo).getClass();
        Assert.assertTrue((String)("actual class " + actualClass.getName() + " is not assignable to required class " + requiredClass), (boolean)requiredClass.isAssignableFrom(actualClass));
    }
}

