/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import java.sql.Connection;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.test.JdbcTestQueryBase;
import org.apache.drill.test.TestTools;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={JdbcTest.class})
public class Bug1735ConnectionCloseTest
extends JdbcTestQueryBase {
    static final Logger logger = LoggerFactory.getLogger(Bug1735ConnectionCloseTest.class);
    @Rule
    public TestRule TIMEOUT = TestTools.getTimeoutRule((int)120000);
    private static final String STATUS_SERVER_PROPERTY_NAME = "drill.exec.http.enabled";
    private static final String origStatusServerPropValue = System.getProperty("drill.exec.http.enabled", "true");
    private static final int SMALL_ITERATION_COUNT = 3;
    private static final int LARGE_ITERATION_COUNT = 1000;

    @BeforeClass
    public static void setUpClass() {
        System.setProperty(STATUS_SERVER_PROPERTY_NAME, "false");
    }

    @AfterClass
    public static void tearDownClass() {
        System.setProperty(STATUS_SERVER_PROPERTY_NAME, origStatusServerPropValue);
    }

    @Test
    public void testCloseDoesntLeakResourcesBasic() throws Exception {
        for (int i = 1; i <= 3; ++i) {
            Connection connection = new Driver().connect("jdbc:drill:zk=local", Bug1735ConnectionCloseTest.getDefaultProperties());
            connection.close();
        }
    }

    @Ignore(value="Normally suppressed because slow")
    @Test
    public void testCloseDoesntLeakResourcesMany() throws Exception {
        for (int i = 1; i <= 1000; ++i) {
            Connection connection = new Driver().connect("jdbc:drill:zk=local", Bug1735ConnectionCloseTest.getDefaultProperties());
            connection.close();
        }
    }
}

