/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.jdbc.JdbcTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={SlowTest.class, JdbcTest.class})
public class ConnectionInfoTest
extends JdbcTestBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @After
    public void tearDown() {
        ConnectionInfoTest.reset();
    }

    @Test
    public void testQuotingIdentifiersProperty() throws Exception {
        Connection connection = ConnectionInfoTest.connect("jdbc:drill:zk=local;quoting_identifiers='\"'");
        DatabaseMetaData dbmd = connection.getMetaData();
        Assert.assertThat((Object)dbmd.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)Quoting.DOUBLE_QUOTE.string));
        ConnectionInfoTest.reset();
        connection = ConnectionInfoTest.connect("jdbc:drill:zk=local;quoting_identifiers=[");
        dbmd = connection.getMetaData();
        Assert.assertThat((Object)dbmd.getIdentifierQuoteString(), (Matcher)CoreMatchers.equalTo((Object)Quoting.BRACKET.string));
    }

    @Test
    public void testIncorrectCharacterForQuotingIdentifiers() throws Exception {
        this.thrown.expect(SQLException.class);
        this.thrown.expectMessage(CoreMatchers.containsString((String)"Option planner.parser.quoting_identifiers must be one of: [`, \", []"));
        ConnectionInfoTest.connect("jdbc:drill:zk=local;quoting_identifiers=&");
    }

    @Test
    public void testSetSchemaUsingConnectionMethod() throws Exception {
        Connection connection = ConnectionInfoTest.connect("jdbc:drill:zk=local");
        Assert.assertNull((Object)connection.getSchema());
        connection.setSchema("dfs.tmp");
        Assert.assertEquals((Object)"dfs.tmp", (Object)connection.getSchema());
    }

    @Test
    public void testIncorrectlySetSchema() throws Exception {
        Connection connection = ConnectionInfoTest.connect("jdbc:drill:zk=local");
        this.thrown.expect(SQLException.class);
        this.thrown.expectMessage("Error when setting schema");
        connection.setSchema("ABC");
    }

    @Test
    public void testSchemaInConnectionString() throws Exception {
        Connection connection = ConnectionInfoTest.connect("jdbc:drill:zk=local;schema=sys");
        Assert.assertEquals((Object)"sys", (Object)connection.getSchema());
    }
}

