/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.concurrent.Semaphore;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={JdbcTest.class})
public class StatementMaxRowsTest
extends JdbcTestBase {
    private static final Random RANDOMIZER = new Random(20150304L);
    private static final String SYS_OPTIONS_SQL = "SELECT * FROM sys.options";
    private static final String SYS_OPTIONS_SQL_LIMIT_10 = "SELECT * FROM sys.options LIMIT 12";
    private static final String ALTER_SYS_OPTIONS_MAX_ROWS_LIMIT_X = "ALTER SYSTEM SET `exec.query.max_rows`=";
    private static final Semaphore maxRowsSysOptionLock = new Semaphore(1);
    private static Connection connection;

    @BeforeClass
    public static void setUpStatement() throws SQLException {
        connection = new Driver().connect("jdbc:drill:zk=local", null);
    }

    @AfterClass
    public static void tearDownStatement() throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    @Before
    public void getExclusiveLock() {
        maxRowsSysOptionLock.acquireUninterruptibly();
    }

    @After
    public void releaseExclusiveLock() {
        maxRowsSysOptionLock.release();
    }

    @Test
    public void testDefaultGetMaxRows() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            int maxRowsValue = stmt.getMaxRows();
            Assert.assertEquals((long)0L, (long)maxRowsValue);
        }
    }

    @Test
    public void testInvalidSetMaxRows() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            int valueToSet = -10;
            int origMaxRows = stmt.getMaxRows();
            try {
                stmt.setMaxRows(valueToSet);
            }
            catch (SQLException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)("illegal maxRows value: " + valueToSet)));
            }
            Assert.assertEquals((long)origMaxRows, (long)stmt.getMaxRows());
        }
    }

    @Test
    public void testValidSetMaxRows() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            int valueToSet = RANDOMIZER.nextInt(59) + 1;
            stmt.setMaxRows(valueToSet);
            Assert.assertEquals((long)valueToSet, (long)stmt.getMaxRows());
        }
    }

    @Test
    public void testSetMaxRowsAsZero() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.setMaxRows(0);
            stmt.executeQuery(SYS_OPTIONS_SQL);
            ResultSet rs = stmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                rs.getBytes(1);
                ++rowCount;
            }
            rs.close();
            Assert.assertTrue((rowCount > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSetMaxRowsLowerThanQueryLimit() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            int valueToSet = RANDOMIZER.nextInt(9) + 1;
            stmt.setMaxRows(valueToSet);
            stmt.executeQuery(SYS_OPTIONS_SQL_LIMIT_10);
            ResultSet rs = stmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                rs.getBytes(1);
                ++rowCount;
            }
            rs.close();
            Assert.assertEquals((long)valueToSet, (long)rowCount);
        }
    }

    @Test
    public void testSetMaxRowsHigherThanQueryLimit() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            int valueToSet = RANDOMIZER.nextInt(10) + 11;
            stmt.setMaxRows(valueToSet);
            stmt.executeQuery(SYS_OPTIONS_SQL_LIMIT_10);
            ResultSet rs = stmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                rs.getBytes(1);
                ++rowCount;
            }
            rs.close();
            Assert.assertTrue((valueToSet > rowCount ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSetMaxRowsLowerThanSystemLimit() throws SQLException {
        int sysValueToSet = RANDOMIZER.nextInt(5) + 6;
        this.setSystemMaxRows(sysValueToSet);
        try (Statement stmt = connection.createStatement();){
            int valueToSet = RANDOMIZER.nextInt(5) + 1;
            stmt.setMaxRows(valueToSet);
            stmt.executeQuery(SYS_OPTIONS_SQL);
            ResultSet rs = stmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                rs.getBytes(1);
                ++rowCount;
            }
            rs.close();
            Assert.assertEquals((long)valueToSet, (long)rowCount);
        }
        this.setSystemMaxRows(0);
    }

    @Test
    public void testSetMaxRowsHigherThanSystemLimit() throws SQLException {
        int sysValueToSet = RANDOMIZER.nextInt(5) + 6;
        this.setSystemMaxRows(sysValueToSet);
        try (Statement stmt = connection.createStatement();){
            int valueToSet = RANDOMIZER.nextInt(5) + 11;
            stmt.setMaxRows(valueToSet);
            stmt.executeQuery(SYS_OPTIONS_SQL);
            ResultSet rs = stmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                rs.getBytes(1);
                ++rowCount;
            }
            rs.close();
            Assert.assertEquals((long)sysValueToSet, (long)rowCount);
        }
        this.setSystemMaxRows(0);
    }

    private void setSystemMaxRows(int sysValueToSet) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.executeQuery(ALTER_SYS_OPTIONS_MAX_ROWS_LIMIT_X + sysValueToSet);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
            }
            rs.close();
        }
    }
}

