/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcApiSqlException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={JdbcTest.class})
public class ConnectionTransactionMethodsTest {
    private static Connection connection;

    @BeforeClass
    public static void setUpConnection() throws SQLException {
        connection = new Driver().connect("jdbc:drill:zk=local", null);
    }

    @AfterClass
    public static void tearDownConnection() throws SQLException {
        connection.close();
    }

    @Test
    public void testGetTransactionIsolationSaysNone() throws SQLException {
        Assert.assertThat((Object)connection.getTransactionIsolation(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testSetTransactionIsolationNoneExitsNormally() throws SQLException {
        connection.setTransactionIsolation(0);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testSetTransactionIsolationReadUncommittedThrows() throws SQLException {
        try {
            connection.setTransactionIsolation(1);
        }
        catch (SQLFeatureNotSupportedException e) {
            Assert.assertThat((String)"Missing requested-level string", (Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"TRANSACTION_READ_UNCOMMITTED"));
            Assert.assertThat((String)"Missing (or reworded) expected description", (Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"transaction isolation level"));
            Assert.assertThat((String)"Missing current-level string", (Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"TRANSACTION_NONE"));
            throw e;
        }
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testSetTransactionIsolationReadCommittedThrows() throws SQLException {
        connection.setTransactionIsolation(2);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testSetTransactionIsolationRepeatableReadThrows() throws SQLException {
        connection.setTransactionIsolation(4);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testSetTransactionIsolationSerializableThrows() throws SQLException {
        connection.setTransactionIsolation(8);
    }

    @Test(expected=JdbcApiSqlException.class)
    public void testSetTransactionIsolationBadIntegerThrows() throws SQLException {
        connection.setTransactionIsolation(15);
    }

    @Test
    public void testGetAutoCommitSaysAuto() throws SQLException {
        Assert.assertThat((Object)connection.getAutoCommit(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testSetAutoCommitTrueExitsNormally() throws SQLException {
        connection.setAutoCommit(true);
    }

    @Test(expected=JdbcApiSqlException.class)
    public void testCommitThrows() throws SQLException {
        connection.commit();
    }

    @Test(expected=JdbcApiSqlException.class)
    public void testRollbackThrows() throws SQLException {
        connection.rollback();
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testSetSavepointUnamed() throws SQLException {
        connection.setSavepoint();
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testSetSavepointNamed() throws SQLException {
        connection.setSavepoint("savepoint name");
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testRollbackSavepoint() throws SQLException {
        connection.rollback(null);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void testReleaseSavepoint() throws SQLException {
        connection.releaseSavepoint(null);
    }
}

